/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.MobsPrank;

import com.j2k.MobsPrank.PrankSnowballGoal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class PrankHandler {
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("99999999-0000-0000-0000-000000000000");

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            if (!event.getLevel().m_5776_()) {
                this.boostSpeed(mob);
                this.clearVanillaGoals(mob);
                this.addPrankGoals(mob);
            }
        }
    }

    @SubscribeEvent
    public void onProjectileHit(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof Snowball) {
            EntityHitResult entityHit;
            Snowball snowball = (Snowball)projectile;
            HitResult hitResult = event.getRayTraceResult();
            if (hitResult instanceof EntityHitResult && (hitResult = (entityHit = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)hitResult;
                Entity entity = snowball.m_19749_();
                if (entity instanceof PathfinderMob) {
                    PathfinderMob shooter = (PathfinderMob)entity;
                    victim.m_6469_(victim.m_269291_().m_269390_((Entity)snowball, (Entity)shooter), 2.0f);
                    Vec3 motion = snowball.m_20184_().m_82541_();
                    victim.m_5997_(motion.f_82479_ * 0.5, 0.25, motion.f_82481_ * 0.5);
                    victim.f_19864_ = true;
                }
            }
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        if (event.getSource().m_7639_() instanceof PathfinderMob && !(event.getSource().m_7640_() instanceof Snowball)) {
            event.setAmount(0.0f);
        }
    }

    private void boostSpeed(PathfinderMob mob) {
        if (mob.m_21051_(Attributes.f_22279_) != null && mob.m_21051_(Attributes.f_22279_).m_22111_(SPEED_MODIFIER_UUID) == null) {
            mob.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier(SPEED_MODIFIER_UUID, "Prank Speed", 0.15, AttributeModifier.Operation.ADDITION));
        }
    }

    private void clearVanillaGoals(PathfinderMob mob) {
        try {
            Set goals = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)mob.f_21345_, (String)"f_25353_");
            if (goals != null) {
                ArrayList<Goal> toRemove = new ArrayList<Goal>();
                List<Class> bannedGoals = Arrays.asList(MeleeAttackGoal.class, ZombieAttackGoal.class, RangedBowAttackGoal.class, SwellGoal.class, PanicGoal.class, AvoidEntityGoal.class, FleeSunGoal.class);
                block2: for (WrappedGoal wrapped : goals) {
                    for (Class banned : bannedGoals) {
                        if (!banned.isAssignableFrom(wrapped.m_26015_().getClass())) continue;
                        toRemove.add(wrapped.m_26015_());
                        continue block2;
                    }
                }
                toRemove.forEach(arg_0 -> ((GoalSelector)mob.f_21345_).m_25363_(arg_0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addPrankGoals(PathfinderMob mob) {
        mob.f_21345_.m_25352_(0, (Goal)new PrankSnowballGoal(mob, 1.3, 15, 25.0f));
        mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)mob, PathfinderMob.class, true));
        mob.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)mob, Player.class, true));
    }
}

