/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.api;

import dev.shadowsoffire.apothic_attributes.ALConfig;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import java.math.BigDecimal;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class ALCombatRules {
    public static float getDamageAfterProtection(LivingEntity target, DamageSource src, float amount, float protPoints) {
        Entity entity = src.getEntity();
        if (entity instanceof LivingEntity) {
            float pierce;
            LivingEntity attacker = (LivingEntity)entity;
            float shred = (float)attacker.getAttributeValue(ALObjects.Attributes.PROT_SHRED);
            if (shred > 0.001f) {
                protPoints *= 1.0f - shred;
            }
            if ((pierce = (float)attacker.getAttributeValue(ALObjects.Attributes.PROT_PIERCE)) > 0.001f) {
                protPoints -= pierce;
            }
        }
        if (protPoints <= 0.0f) {
            return amount;
        }
        return amount * ALCombatRules.getProtDamageReduction(protPoints);
    }

    public static float getProtDamageReduction(float protPoints) {
        if (ALConfig.getProtExpr().isPresent()) {
            return ALConfig.getProtExpr().get().setVariable("protPoints", new BigDecimal(protPoints)).eval().floatValue();
        }
        return 1.0f - Math.min(0.025f * protPoints, 0.85f);
    }

    public static float getDamageAfterArmor(LivingEntity target, DamageSource src, float amount, float armor, float toughness) {
        Level bypassResist2;
        Entity entity = src.getEntity();
        if (entity instanceof LivingEntity) {
            float pierce;
            LivingEntity attacker = (LivingEntity)entity;
            float shred = (float)attacker.getAttributeValue(ALObjects.Attributes.ARMOR_SHRED);
            float bypassResist2 = ALCombatRules.getBypassResistance(amount, armor, toughness);
            if (shred > 0.001f) {
                armor *= 1.0f - (shred *= 1.0f - bypassResist2);
            }
            if ((pierce = (float)attacker.getAttributeValue(ALObjects.Attributes.ARMOR_PIERCE)) > 0.001f) {
                armor -= (pierce *= 1.0f - bypassResist2);
            }
        }
        if (armor <= 0.0f) {
            return amount + ALConfig.negativeArmorFactor * -armor * amount;
        }
        float reduction = ALCombatRules.getArmorDamageReduction(amount, armor, toughness);
        if (src.getWeaponItem() != null && (bypassResist2 = target.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)bypassResist2;
            float effectiveness = 1.0f - reduction;
            effectiveness = Mth.clamp((float)EnchantmentHelper.modifyArmorEffectiveness((ServerLevel)serverlevel, (ItemStack)src.getWeaponItem(), (Entity)target, (DamageSource)src, (float)effectiveness), (float)0.0f, (float)1.0f);
            reduction = 1.0f - effectiveness;
        }
        return amount * reduction;
    }

    public static float getAValue(float damage) {
        if (ALConfig.getAValueExpr().isPresent()) {
            return ALConfig.getAValueExpr().get().setVariable("damage", new BigDecimal(damage)).eval().floatValue();
        }
        return damage < 20.0f ? 10.0f : 10.0f + (damage - 20.0f) / 2.0f;
    }

    public static float getArmorDamageReduction(float damage, float armor, float toughness) {
        float a = ALCombatRules.getAValue(damage);
        if (ALConfig.getArmorExpr().isPresent()) {
            return ALConfig.getArmorExpr().get().setVariable("a", new BigDecimal(a)).setVariable("damage", new BigDecimal(damage)).setVariable("armor", new BigDecimal(armor)).setVariable("toughness", new BigDecimal(toughness)).eval().floatValue();
        }
        return a / (a + armor);
    }

    public static float getBypassResistance(float damage, float armor, float toughness) {
        if (ALConfig.getToughnessExpr().isPresent()) {
            float bypassResist = ALConfig.getToughnessExpr().get().setVariable("damage", new BigDecimal(damage)).setVariable("armor", new BigDecimal(armor)).setVariable("toughness", new BigDecimal(toughness)).eval().floatValue();
            return Math.clamp(bypassResist, 0.0f, 1.0f);
        }
        return Math.min(toughness * 0.02f, 0.6f);
    }
}

