/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.client;

import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.client.ModifierSource;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class AttributeModifierComponent
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE = ApothicAttributes.loc("textures/gui/attribute_component.png");
    @Nullable
    private final ModifierSource<?> source;
    private final List<FormattedCharSequence> text;

    public AttributeModifierComponent(@Nullable ModifierSource<?> source, FormattedText text, Font font, int maxWidth) {
        this.source = source;
        this.text = font.split(text, maxWidth);
    }

    public int getHeight() {
        return this.text.size() * 10;
    }

    public int getWidth(Font font) {
        return this.text.stream().map(arg_0 -> ((Font)font).width(arg_0)).map(w -> w + 12).max(Integer::compareTo).get();
    }

    public void renderImage(Font font, int x, int y, GuiGraphics gfx) {
        gfx.blit(TEXTURE, x, y, 0, this.source == null ? 9.0f : 0.0f, 0.0f, 9, 9, 18, 9);
        if (this.source == null) {
            return;
        }
        this.source.render(gfx, font, x, y);
    }

    public void renderText(Font font, int pX, int pY, Matrix4f pMatrix4f, MultiBufferSource.BufferSource pBufferSource) {
        FormattedCharSequence line = this.text.get(0);
        font.drawInBatch(line, (float)(pX + 12), (float)pY, -1, true, pMatrix4f, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        for (int i = 1; i < this.text.size(); ++i) {
            line = this.text.get(i);
            float f = pX;
            Objects.requireNonNull(font);
            font.drawInBatch(line, f, (float)(pY + i * (9 + 1)), -1, true, pMatrix4f, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }
}

