/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.json.OptionalStackCodec;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;

public class HandToJsonCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(arg -> Component.translatable((String)"placebo.cmd.not_found", (Object[])new Object[]{arg}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.literal((String)"hand").executes(ctx -> {
            try {
                String str = HandToJsonCommand.toJsonStr(((CommandSourceStack)ctx.getSource()).getEntity().getWeaponItem(), (RegistryOps<JsonElement>)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)((CommandSourceStack)ctx.getSource()).getServer().registryAccess()));
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)str));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return 0;
        }));
    }

    public static String toJsonStr(ItemStack stack, RegistryOps<JsonElement> ops) throws IOException {
        JsonElement json = (JsonElement)OptionalStackCodec.INSTANCE.encodeStart(ops, (Object)stack).getOrThrow();
        StringWriter str = new StringWriter();
        JsonWriter writer = GSON.newJsonWriter((Writer)str);
        writer.setIndent("    ");
        GSON.toJson((Object)json, JsonObject.class, writer);
        return String.format("Currently Held Item:\n%s", str.toString());
    }
}

