/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.command;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.redspace.ironsjewelry.command.GenerateSiteData;
import io.redspace.ironsjewelry.command.PatternCommandArgument;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.core.data.PlayerData;
import io.redspace.ironsjewelry.loot.LootInjectionHandler;
import io.redspace.ironsjewelry.registry.AssetHandlerRegistry;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import io.redspace.ironsjewelry.registry.DataAttachmentRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import io.redspace.ironsjewelry.registry.ItemRegistry;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.loading.FMLLoader;

public class IronsDebugCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.irons_spellbooks.create_imbued_sword.failed"));
    private static final SuggestionProvider<CommandSourceStack> PATTERN_SUGGESTIONS = (context, builder) -> {
        Registry<PatternDefinition> registry = IronsJewelryRegistries.patternRegistry(((CommandSourceStack)context.getSource()).registryAccess());
        Set resources = registry.stream().map(arg_0 -> registry.getKey(arg_0)).collect(Collectors.toSet());
        return SharedSuggestionProvider.suggestResource(resources, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ironsJewelry").requires(p_138819_ -> p_138819_.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"learnPattern").then(Commands.argument((String)"pattern", (ArgumentType)PatternCommandArgument.patternArgument()).suggests(PATTERN_SUGGESTIONS).executes(commandContext -> IronsDebugCommand.learnPattern((CommandSourceStack)commandContext.getSource(), (String)commandContext.getArgument("pattern", String.class))))).then(Commands.literal((String)"all").executes(context -> IronsDebugCommand.learnAllPatterns((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"unlearnAll").executes(context -> IronsDebugCommand.unlearnAllPatterns((CommandSourceStack)context.getSource()))))).then(Commands.literal((String)"createPatternItem").then(Commands.argument((String)"pattern", (ArgumentType)PatternCommandArgument.patternArgument()).suggests(PATTERN_SUGGESTIONS).executes(commandContext -> IronsDebugCommand.createPatternItem((CommandSourceStack)commandContext.getSource(), (String)commandContext.getArgument("pattern", String.class)))));
        if (!FMLLoader.isProduction()) {
            command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").then(Commands.literal((String)"countCombos").executes(commandContext -> IronsDebugCommand.enumerateCombos((CommandSourceStack)commandContext.getSource())))).then(Commands.literal((String)"generateSiteData").executes(commandContext -> GenerateSiteData.generateSiteData((CommandSourceStack)commandContext.getSource())))).then(Commands.literal((String)"exportHeldItem").executes(commandContext -> IronsDebugCommand.exportHeldItem((CommandSourceStack)commandContext.getSource())))).then(Commands.literal((String)"lootTracker").executes(commandContext -> IronsDebugCommand.dumpLootInfo((CommandSourceStack)commandContext.getSource()))));
        }
        pDispatcher.register(command);
    }

    private static int enumerateCombos(CommandSourceStack source) {
        RegistryAccess registry = source.registryAccess();
        int total = 0;
        Registry<MaterialDefinition> materials = IronsJewelryRegistries.materialRegistry(registry);
        for (PatternDefinition patternDefinition : IronsJewelryRegistries.patternRegistry(registry)) {
            ArrayList<Integer> lengths = new ArrayList<Integer>();
            for (PartIngredient part : patternDefinition.partTemplate()) {
                int option = 0;
                for (MaterialDefinition materialDefinition : materials) {
                    if (!((PartDefinition)part.part().value()).canUseMaterial(materialDefinition.materialType())) continue;
                    ++option;
                }
                lengths.add(option);
            }
            int subtotal = (Integer)lengths.getFirst();
            for (int i = 1; i < lengths.size(); ++i) {
                subtotal *= ((Integer)lengths.get(i)).intValue();
            }
            total += subtotal;
        }
        source.sendSystemMessage((Component)Component.literal((String)String.valueOf(total)));
        return total;
    }

    private static int createPatternItem(CommandSourceStack source, String patternId) throws CommandSyntaxException {
        Registry<PatternDefinition> registry;
        Optional pattern;
        if (!((String)patternId).contains(":")) {
            patternId = "irons_jewelry:" + (String)patternId;
        }
        if ((pattern = (registry = IronsJewelryRegistries.patternRegistry(source.registryAccess())).getHolder(ResourceLocation.parse((String)patternId))).isPresent()) {
            ServerPlayer serverPlayer = source.getPlayer();
            ItemStack stack = new ItemStack((ItemLike)ItemRegistry.RECIPE.get());
            stack.set(ComponentRegistry.STORED_PATTERN, (Object)((Holder.Reference)pattern.get()));
            serverPlayer.getInventory().add(stack);
            return 1;
        }
        throw ERROR_FAILED.create();
    }

    private static int learnPattern(CommandSourceStack source, String patternId) throws CommandSyntaxException {
        ServerPlayer serverPlayer;
        Registry<PatternDefinition> registry;
        PatternDefinition pattern;
        if (!((String)patternId).contains(":")) {
            patternId = "irons_jewelry:" + (String)patternId;
        }
        if ((pattern = (PatternDefinition)(registry = IronsJewelryRegistries.patternRegistry(source.registryAccess())).get(ResourceLocation.parse((String)patternId))) != null && (serverPlayer = source.getPlayer()) != null) {
            return ((PlayerData)serverPlayer.getData(DataAttachmentRegistry.PLAYER_DATA)).learnAndSync(serverPlayer, (Holder<PatternDefinition>)registry.wrapAsHolder((Object)pattern)) ? 1 : 0;
        }
        throw ERROR_FAILED.create();
    }

    private static int learnAllPatterns(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer != null) {
            PlayerData data = (PlayerData)serverPlayer.getData(DataAttachmentRegistry.PLAYER_DATA);
            Registry<PatternDefinition> registry = IronsJewelryRegistries.patternRegistry(source.registryAccess());
            for (Map.Entry entry : registry.entrySet()) {
                data.learn((Holder<PatternDefinition>)registry.wrapAsHolder((Object)((PatternDefinition)entry.getValue())));
            }
            data.sync(serverPlayer);
            return 1;
        }
        throw ERROR_FAILED.create();
    }

    private static int unlearnAllPatterns(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer != null) {
            PlayerData data = (PlayerData)serverPlayer.getData(DataAttachmentRegistry.PLAYER_DATA);
            data.getLearnedPatterns().clear();
            data.sync(serverPlayer);
            return 1;
        }
        throw ERROR_FAILED.create();
    }

    private static int dumpLootInfo(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer != null) {
            int maxLength = 0;
            Set<Map.Entry<ResourceLocation, Float>> entries = LootInjectionHandler.TRACKED_LOOT_TABLES.entrySet();
            for (Map.Entry<ResourceLocation, Float> entry : entries) {
                if (entry.getKey().toString().length() <= maxLength) continue;
                maxLength = entry.getKey().toString().length();
            }
            for (Map.Entry<ResourceLocation, Float> entry : entries) {
                Object message = entry.getKey().toString();
                message = (String)message + Strings.repeat((char)'.', (int)(maxLength + 3 - ((String)message).length())) + String.valueOf(entry.getValue());
                serverPlayer.sendSystemMessage((Component)Component.literal((String)message));
            }
            return 1;
        }
        throw ERROR_FAILED.create();
    }

    private static int exportHeldItem(CommandSourceStack source) throws CommandSyntaxException {
        JewelryData jewelry;
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer != null && (jewelry = JewelryData.get(serverPlayer.getMainHandItem())).isValid()) {
            try {
                NativeImage image = new NativeImage(16, 16, false);
                ((PatternDefinition)jewelry.pattern().value()).partTemplate().stream().map(PartIngredient::part).forEach(part -> {
                    Holder<MaterialDefinition> material = jewelry.parts().get(part);
                    TextureAtlasSprite sprite = AssetHandlerRegistry.JEWELRY_HANDLER.get().getSprite(AssetHandlerRegistry.JEWELRY_HANDLER.get().getSpriteLocation((Holder<PartDefinition>)part, material));
                    NativeImage layer = sprite.contents().getOriginalImage();
                    int[] pixels = layer.getPixelsRGBA();
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            int i = y * 16 + x;
                            int rgba = pixels[i];
                            int alpha = rgba >> 24 & 0xFF;
                            if (alpha == 0) continue;
                            image.setPixelRGBA(x, y, rgba);
                        }
                    }
                });
                String fileName = serverPlayer.getMainHandItem().getHoverName().getString().toLowerCase(Locale.ENGLISH).chars().mapToObj(i -> ResourceLocation.isAllowedInResourceLocation((char)((char)i)) ? String.valueOf((char)i) : "_").collect(Collectors.joining()) + ".png";
                Path dirPath = Path.of("screenshots/irons_jewelry", new String[0]);
                Path filePath = dirPath.resolve(fileName);
                if (Files.notExists(dirPath, new LinkOption[0])) {
                    Files.createDirectories(dirPath, new FileAttribute[0]);
                }
                if (Files.notExists(filePath, new LinkOption[0])) {
                    Files.createFile(filePath, new FileAttribute[0]);
                }
                image.writeToFile(filePath);
                MutableComponent component = Component.literal((String)("Exported " + fileName)).withStyle(ChatFormatting.UNDERLINE).withStyle(p_168608_ -> p_168608_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, filePath.toString())));
                serverPlayer.sendSystemMessage((Component)component);
            }
            catch (Exception e) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)("Failed to make image file: " + e.getMessage())));
            }
            return 1;
        }
        throw ERROR_FAILED.create();
    }
}

