/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.actions.IAction;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import io.redspace.ironsjewelry.utils.DamageHelper;
import io.redspace.ironsjewelry.utils.Utils;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record ApplyDamageAction(Holder<DamageType> damageType, QualityScalar amount, Optional<Double> maximumDamage, Optional<Holder<SoundEvent>> soundEvent) implements IAction
{
    public static final MapCodec<ApplyDamageAction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)DamageType.CODEC.fieldOf("damageType").forGetter(ApplyDamageAction::damageType), (App)QualityScalar.CODEC.fieldOf("amount").forGetter(ApplyDamageAction::amount), (App)Codec.DOUBLE.optionalFieldOf("maximum").forGetter(ApplyDamageAction::maximumDamage), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(ApplyDamageAction::soundEvent)).apply((Applicative)builder, ApplyDamageAction::new));

    @Override
    public void apply(ServerLevel serverLevel, double quality, boolean applyToSelf, ServerPlayer wearer, Entity entity) {
        ServerPlayer target;
        DamageSource damageSource = new DamageSource(this.damageType, null, (Entity)wearer, wearer.position());
        float damage = this.getDamage(quality);
        Object object = target = applyToSelf ? wearer : entity;
        if (applyToSelf) {
            DamageHelper.ignoreNextKnockback((LivingEntity)wearer);
        } else if (wearer.getUUID().equals(target.getUUID())) {
            return;
        }
        target.hurt(damageSource, damage);
        this.soundEvent.ifPresent(arg_0 -> ApplyDamageAction.lambda$apply$1((Entity)target, arg_0));
    }

    public float getDamage(double quality) {
        return this.maximumDamage.map(max -> Float.valueOf((float)Math.min(this.amount.sample(quality), max))).orElseGet(() -> Float.valueOf((float)this.amount.sample(quality))).floatValue();
    }

    @Override
    public Component formatTooltip(BonusInstance bonusInstance, boolean applyToSelf) {
        String damage = Utils.stringTruncation(this.getDamage(bonusInstance.quality()), 1);
        ResourceKey key = this.damageType.getKey();
        MutableComponent typeComponent = Component.empty();
        if (key != null) {
            ResourceLocation location = key.location();
            typeComponent = Component.translatable((String)String.format("damage_type.%s.%s", location.getNamespace(), location.getPath()));
        }
        return Component.translatable((String)(applyToSelf ? "action.irons_jewelry.apply_damage.self" : "action.irons_jewelry.apply_damage.entity"), (Object[])new Object[]{Component.literal((String)damage).withStyle(ChatFormatting.RED), typeComponent});
    }

    @Override
    public Component simpleDescription(MutableComponent actionName) {
        if (this.damageType().getKey() == null) {
            return Component.empty();
        }
        ResourceLocation location = this.damageType().getKey().location();
        MutableComponent typeComponent = Component.translatable((String)String.format("damage_type.%s.%s", location.getNamespace(), location.getPath()));
        return actionName.append(" ").append((Component)Component.translatable((String)"action.irons_jewelry.apply_damage.description", (Object[])new Object[]{Float.valueOf(this.getDamage(1.0)), typeComponent}));
    }

    @Override
    public MapCodec<? extends IAction> codec() {
        return CODEC;
    }

    private static /* synthetic */ void lambda$apply$1(Entity target, Holder sound) {
        target.playSound((SoundEvent)sound.value());
    }
}

