/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;

public record QualityScalar(double baseAmount, double qualityScalar, double min, Optional<Double> max) {
    public static final Codec<QualityScalar> DIRECT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.DOUBLE.fieldOf("base").forGetter(QualityScalar::baseAmount), (App)Codec.DOUBLE.fieldOf("scalar").forGetter(QualityScalar::qualityScalar), (App)Codec.DOUBLE.optionalFieldOf("min", (Object)0.0).forGetter(QualityScalar::min), (App)Codec.DOUBLE.optionalFieldOf("max").forGetter(QualityScalar::max)).apply((Applicative)builder, QualityScalar::new));
    public static final Codec<QualityScalar> CONSTANT_CODEC = Codec.DOUBLE.xmap(d -> new QualityScalar((double)d, 0.0, 0.0, Optional.empty()), scalar -> scalar.baseAmount);
    public static final Codec<QualityScalar> CODEC = Codec.withAlternative(DIRECT_CODEC, CONSTANT_CODEC);

    public QualityScalar(double baseAmount, double qualityScalar) {
        this(baseAmount, qualityScalar, 0.0, Optional.empty());
    }

    public QualityScalar(double baseAmount) {
        this(baseAmount, 0.0, 0.0, Optional.empty());
    }

    public double sample(double quality) {
        double d = this.baseAmount + (quality - 1.0) * this.qualityScalar;
        if (this.baseAmount < 0.0) {
            d = Math.min(d, this.min);
            if (this.max.isPresent()) {
                d = Math.max(d, this.max.get());
            }
        } else {
            d = Math.max(d, this.min);
            if (this.max.isPresent()) {
                d = Math.min(d, this.max.get());
            }
        }
        return d;
    }
}

