/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.utils;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class Utils {
    public static <T> Codec<T> byIdCodec(Function<ResourceLocation, Optional<T>> idToObj, Function<T, ResourceLocation> objToId) {
        return ResourceLocation.CODEC.comapFlatMap(resourceLocation -> ((Optional)idToObj.apply((ResourceLocation)resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key: " + String.valueOf(resourceLocation))), objToId);
    }

    public static <T> StreamCodec<ByteBuf, T> idStreamCodec(Function<ResourceLocation, T> idToObj, Function<T, ResourceLocation> objToId) {
        return ResourceLocation.STREAM_CODEC.map(idToObj, objToId);
    }

    public static <L, R, T> T mapEither(Either<L, R> either, Function<L, T> leftToValue, Function<R, T> rightToValue) {
        if (either.left().isPresent()) {
            return leftToValue.apply(either.left().get());
        }
        if (either.right().isPresent()) {
            return rightToValue.apply(either.right().get());
        }
        throw new NoSuchElementException("Neither right nor left present in either");
    }

    public static Optional<Holder<MaterialDefinition>> getMaterialForIngredient(RegistryAccess access, ItemStack ingredient) {
        Registry<MaterialDefinition> r = IronsJewelryRegistries.materialRegistry(access);
        return r.stream().filter(material -> material.ingredient().test(ingredient)).map(arg_0 -> r.wrapAsHolder(arg_0)).findFirst();
    }

    public static List<BonusInstance> getEquippedBonuses(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.has(ComponentRegistry.JEWELRY_COMPONENT)).stream().flatMap(slot -> JewelryData.get(slot.stack()).getBonuses().stream()).toList()).orElse(List.of());
    }

    public static List<ItemStack> getEquippedJewelry(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.has(ComponentRegistry.JEWELRY_COMPONENT)).stream().map(SlotResult::stack).toList()).orElse(List.of());
    }

    public static List<FormattedCharSequence> rasterizeComponentList(List<? extends Component> components) {
        return components.stream().map(component -> FormattedCharSequence.forward((String)component.getString(), (Style)component.getStyle())).toList();
    }

    public static String timeFromTicks(float ticks, int decimalPlaces) {
        float ticks_to_seconds = 20.0f;
        float seconds_to_minutes = 60.0f;
        String affix = "s";
        float time = ticks / ticks_to_seconds;
        if (time > seconds_to_minutes) {
            time /= seconds_to_minutes;
            affix = "m";
        }
        return Utils.stringTruncation(time, decimalPlaces) + affix;
    }

    public static String stringTruncation(double f, int decimalPlaces) {
        if (f == Math.floor(f)) {
            return Integer.toString((int)f);
        }
        double multiplier = Math.pow(10.0, decimalPlaces);
        double truncatedValue = Math.floor(f * multiplier) / multiplier;
        String result = Double.toString(truncatedValue);
        result = (result = result.replaceAll("0*$", "")).endsWith(".") ? result.substring(0, result.length() - 1) : result;
        return result;
    }

    public static String digitalTimeFromTicks(int ticks) {
        return Utils.digitalTimeFromTicks(ticks, false);
    }

    public static String digitalTimeFromTicks(int ticks, boolean showZeroMinutes) {
        Object time = "";
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        int hours = minutes / 60;
        if (minutes >= 60) {
            time = (String)time + String.format("%s:", hours);
        }
        if (seconds >= 60 || showZeroMinutes) {
            time = (String)time + String.format("%s:", minutes % 60);
        }
        if (seconds >= 10) {
            time = (String)time + seconds % 60 / 10;
        } else if (minutes > 0 || showZeroMinutes) {
            time = (String)time + "0";
        }
        time = (String)time + seconds % 10;
        return time;
    }

    public static ItemStack createExampleJewelryItem(RegistryAccess registryAccess, Holder<PatternDefinition> patternHolder) {
        PatternDefinition pattern = (PatternDefinition)patternHolder.value();
        ItemStack output = new ItemStack(pattern.jewelryType().item());
        Holder iron = (Holder)IronsJewelryRegistries.materialRegistry(registryAccess).getHolder(IronsJewelry.id("example")).get();
        Map<Holder<PartDefinition>, Holder<MaterialDefinition>> parts = pattern.partTemplate().stream().map(PartIngredient::part).collect(Collectors.toMap(Function.identity(), p -> iron));
        JewelryData jewelryData = JewelryData.renderable((Holder<PatternDefinition>)IronsJewelryRegistries.patternRegistry(Minecraft.getInstance().level.registryAccess()).wrapAsHolder((Object)pattern), parts);
        output.set(ComponentRegistry.JEWELRY_COMPONENT, (Object)jewelryData);
        List<MutableComponent> bonuses = pattern.getPatternBonusesTooltip();
        if (!bonuses.isEmpty()) {
            bonuses.set(0, Component.translatable((String)"tooltip.irons_jewelry.bonus_crafted_header").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
            bonuses.add(0, Component.empty());
            output.set(DataComponents.LORE, (Object)new ItemLore(bonuses.stream().map(component -> component.withStyle(component.getStyle().withItalic(Boolean.valueOf(false)))).toList()));
        }
        return output;
    }
}

