/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.core;

import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.common.core.RayCastPerspective;
import com.onewhohears.onewholibs.common.network.toserver.ToServerCanSeePos;
import com.onewhohears.onewholibs.util.UtilEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class DistantRayCastManagerClient {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void handleS2CRayCast(int rayCastId, RayCastPerspective perspective, int perspectiveEntityId, Vec3 targetPos, double throWater, double throBlock) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel level = m.f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(perspectiveEntityId);
        if (entity == null) {
            LOGGER.warn("Resieved Ray Cast Packet for an entity that doesn't exist in the client level with id {}", (Object)perspectiveEntityId);
            return;
        }
        int renderDistanceBlocks = Math.min(192, m.f_91066_.m_193772_() * 16);
        boolean result = UtilEntity.isLocalVisionBlocked((Level)level, entity.m_146892_(), targetPos, throWater, throBlock, renderDistanceBlocks);
        DistantRayCastManagerClient.sendRayCastResult(rayCastId, perspective, result);
    }

    public static void sendRayCastResult(int rayCastId, RayCastPerspective perspective, boolean result) {
        new ToServerCanSeePos(rayCastId, perspective, result).sendToServer();
    }
}

