/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.client.model.obj.ObjBakedModel;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModelsImpl;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandler;
import com.onewhohears.onewholibs.client.model.obj.ObjUnbakedModel;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.Vec3f;
import dev.architectury.registry.ReloadListenerRegistry;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public abstract class ObjEntityModels
implements ResourceManagerReloadListener {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static ObjEntityModels instance;
    public static final String DIRECTORY = "models/entity";
    public static final String MODEL_FILE_TYPE = ".obj";
    public static final String MATERIAL_FILE_TYPE = ".mtl";
    public static final String OVERRIDE_FILE_TYPE = ".json";
    public static final String NULL_MODEL_NAME = "simple_test";
    private final Map<String, ModelOverrides> modelOverrides = new HashMap<String, ModelOverrides>();
    private final Map<String, ObjModelHandler> modelHandlers = new HashMap<String, ObjModelHandler>();
    public static final ModelOverrides NO_OVERRIDES;

    public static ObjEntityModels get() {
        return instance;
    }

    public static void close() {
        instance = null;
    }

    public static void register() {
        instance = ObjEntityModels.createNew();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)instance);
    }

    public static ObjEntityModels createNew() {
        return new ObjEntityModelsImpl();
    }

    protected ObjEntityModels() {
    }

    public ObjModelHandler getObjModelHandler(String id) {
        if (!this.modelHandlers.containsKey(id)) {
            this.modelHandlers.put(id, this.createObjModelHandler(id));
        }
        return this.modelHandlers.get(id);
    }

    protected abstract ObjModelHandler createObjModelHandler(String var1);

    public void m_6213_(ResourceManager manager) {
        LOGGER.info("RELOAD ASSETS: models/entity");
        this.readModelOverrides(manager);
        this.modelHandlers.clear();
        this.setupObjModels(manager);
    }

    protected abstract void setupObjModels(ResourceManager var1);

    public abstract void bakeModels();

    public ModelOverrides getModelOverride(String name) {
        if (!this.modelOverrides.containsKey(name)) {
            return NO_OVERRIDES;
        }
        return this.modelOverrides.get(name);
    }

    public abstract boolean hasModel(String var1);

    public abstract ObjUnbakedModel getUnbakedModel(String var1);

    public abstract ObjBakedModel getBakedModel(String var1);

    public void readModelOverrides(ResourceManager manager) {
        this.modelOverrides.clear();
        manager.m_214159_(DIRECTORY, key -> key.m_135815_().endsWith(OVERRIDE_FILE_TYPE)).forEach((key, resource) -> {
            try {
                String name = new File(key.m_135815_()).getName().replace(OVERRIDE_FILE_TYPE, "");
                if (this.modelOverrides.containsKey(name)) {
                    LOGGER.warn("ERROR: Can't have 2 model overrides with the same name! {}", key);
                    return;
                }
                JsonObject json = (JsonObject)UtilParse.GSON.fromJson((Reader)resource.m_215508_(), JsonObject.class);
                this.modelOverrides.put(name, new ModelOverrides(json));
                LOGGER.debug("ADDING OVERRIDE = {}", key);
            }
            catch (Exception e) {
                LOGGER.warn("ERROR: SKIPPING {} because {}", (Object)key.toString(), (Object)e.getMessage());
                e.printStackTrace();
            }
        });
    }

    static {
        NO_OVERRIDES = new ModelOverrides();
    }

    public static class ModelOverrides {
        public float scale = 1.0f;
        public float[] scale3d = new float[]{1.0f, 1.0f, 1.0f};
        public Vec3f translate = new Vec3f();
        public float[] rotation = new float[]{0.0f, 0.0f, 0.0f};
        private boolean none = false;

        public ModelOverrides(JsonObject json) {
            if (json.has("scale_all") && json.get("scale_all").isJsonPrimitive()) {
                this.scale = UtilParse.getFloatSafe(json, "scale_all", 1.0f);
            }
            if (json.has("scale")) {
                JsonElement scaleEle = json.get("scale");
                if (scaleEle.isJsonObject()) {
                    Vec3 scaleVec = UtilParse.readVec3(json, "scale");
                    this.scale3d[0] = (float)scaleVec.m_7096_();
                    this.scale3d[1] = (float)scaleVec.m_7098_();
                    this.scale3d[2] = (float)scaleVec.m_7094_();
                } else if (scaleEle.isJsonPrimitive()) {
                    this.scale = json.get("scale").getAsFloat();
                }
            }
            if (json.has("scalex")) {
                this.scale3d[0] = json.get("scalex").getAsFloat();
            }
            if (json.has("scaley")) {
                this.scale3d[1] = json.get("scaley").getAsFloat();
            }
            if (json.has("scalez")) {
                this.scale3d[2] = json.get("scalez").getAsFloat();
            }
            if (json.has("translate") && json.get("translate").isJsonObject()) {
                this.translate = UtilParse.readVec3f(json, "translate");
            } else {
                if (json.has("translatex")) {
                    this.translate.add(json.get("translatex").getAsFloat(), 0.0f, 0.0f);
                }
                if (json.has("translatey")) {
                    this.translate.add(0.0f, json.get("translatey").getAsFloat(), 0.0f);
                }
                if (json.has("translatez")) {
                    this.translate.add(0.0f, 0.0f, json.get("translatez").getAsFloat());
                }
            }
            if (json.has("rotation") && json.get("rotation").isJsonObject()) {
                Vec3 rotVec = UtilParse.readVec3(json, "rotation");
                this.rotation[0] = (float)rotVec.m_7096_();
                this.rotation[1] = (float)rotVec.m_7098_();
                this.rotation[2] = (float)rotVec.m_7094_();
            } else {
                if (json.has("rotationx")) {
                    this.rotation[0] = json.get("rotationx").getAsFloat();
                }
                if (json.has("rotationy")) {
                    this.rotation[1] = json.get("rotationy").getAsFloat();
                }
                if (json.has("rotationz")) {
                    this.rotation[2] = json.get("rotationz").getAsFloat();
                }
            }
        }

        private ModelOverrides() {
            this.none = true;
        }

        public boolean isNone() {
            return this.none;
        }

        public void apply(PoseStack poseStack) {
            if (this.isNone()) {
                return;
            }
            this.applyRotation(poseStack);
            poseStack.m_252880_(this.translate.x(), this.translate.y(), this.translate.z());
            poseStack.m_85841_(this.scale * this.scale3d[0], this.scale * this.scale3d[1], this.scale * this.scale3d[2]);
        }

        public void applyNoTranslate(PoseStack poseStack) {
            if (this.isNone()) {
                return;
            }
            this.applyRotation(poseStack);
            poseStack.m_85841_(this.scale * this.scale3d[0], this.scale * this.scale3d[1], this.scale * this.scale3d[2]);
        }

        public void applyRotation(PoseStack poseStack) {
            if (this.isNone()) {
                return;
            }
            if (this.rotation[0] != 0.0f) {
                poseStack.m_252781_(Vec3f.XP.rotationDegrees(this.rotation[0]).convert());
            }
            if (this.rotation[1] != 0.0f) {
                poseStack.m_252781_(Vec3f.YN.rotationDegrees(this.rotation[1]).convert());
            }
            if (this.rotation[2] != 0.0f) {
                poseStack.m_252781_(Vec3f.ZP.rotationDegrees(this.rotation[2]).convert());
            }
        }
    }
}

