/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj.customanims;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModel;
import com.onewhohears.onewholibs.client.model.obj.customanims.CustomAnims;
import com.onewhohears.onewholibs.client.model.obj.customanims.EntityModelTransform;
import com.onewhohears.onewholibs.client.model.obj.customanims.EntityModelTransformGroup;
import com.onewhohears.onewholibs.util.math.Mat4f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;

public class CustomAnimsEntityModel<T extends Entity>
extends ObjEntityModel<T> {
    protected final Map<String, EntityModelTransform<T>> transforms = new HashMap<String, EntityModelTransform<T>>();

    public CustomAnimsEntityModel(String model_id, JsonArray anims) {
        super(model_id);
        for (int i = 0; i < anims.size(); ++i) {
            JsonObject anim = anims.get(i).getAsJsonObject();
            EntityModelTransform t = CustomAnims.get(anim);
            if (t == null) continue;
            String model_part_key = t.getKey();
            if (this.transforms.containsKey(model_part_key)) {
                EntityModelTransform t0 = this.transforms.get(model_part_key);
                if (t0.isGroup()) {
                    t0.addTransform(t);
                    continue;
                }
                EntityModelTransformGroup<T> tg = new EntityModelTransformGroup<T>(model_part_key, t0, t);
                this.transforms.put(model_part_key, tg);
                continue;
            }
            this.transforms.put(model_part_key, t);
        }
    }

    @Override
    protected void addComponentTransforms(Map<String, Mat4f> transforms, T entity, float partialTicks) {
        super.addComponentTransforms(transforms, entity, partialTicks);
        for (EntityModelTransform<T> trans : this.transforms.values()) {
            transforms.put(trans.getKey(), trans.getTransform(entity, partialTicks));
        }
    }
}

