/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.bbanims;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KeyframeAnimParser;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KeyframeAnimation;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.bbanims.BBAnim;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.Vec3f;
import dev.architectury.registry.ReloadListenerRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public class BlockBenchAnims
implements KeyframeAnimParser {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static BlockBenchAnims instance;
    public static final String DIRECTORY = "bb_animations";
    public static final String ANIM_FILE_TYPE = ".json";
    public static final String PIVOTS_FILE_TYPE = ".txt";
    public static final String COMPATIBLE_FORMAT_VERSIONS = "1.8.0";
    private static final Map<String, BBAnim> animMap;

    public static BlockBenchAnims get() {
        return instance;
    }

    public static void close() {
        instance = null;
    }

    public static void register() {
        instance = new BlockBenchAnims();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)instance);
    }

    private BlockBenchAnims() {
    }

    public void m_6213_(ResourceManager manager) {
        LOGGER.info("RELOAD ASSETS: bb_animations");
        animMap.clear();
        manager.m_214159_(DIRECTORY, key -> key.m_135815_().endsWith(ANIM_FILE_TYPE)).forEach((key, resource) -> {
            try {
                String name = new File(key.m_135815_()).getName().replace(ANIM_FILE_TYPE, "");
                if (animMap.containsKey(name)) {
                    LOGGER.warn("ERROR: Can't have 2 animations with the same name! {}", key);
                    return;
                }
                JsonObject json = (JsonObject)UtilParse.GSON.fromJson((Reader)resource.m_215508_(), JsonObject.class);
                String pivotLoc = key.m_135827_() + ":bb_animations/" + name + PIVOTS_FILE_TYPE;
                Optional pivotRec = manager.m_213713_(new ResourceLocation(pivotLoc));
                HashMap<String, Vec3f> pivots = new HashMap<String, Vec3f>();
                if (pivotRec.isPresent()) {
                    this.readPivots((Resource)pivotRec.get(), pivots);
                    LOGGER.debug("PIVOTS: {} {}", (Object)name, (Object)pivots.size());
                }
                this.processBBJson(name, json, pivots);
            }
            catch (Exception e) {
                LOGGER.error("ERROR: SKIPPING {} because {}", key, (Object)e.getMessage());
                e.printStackTrace();
            }
        });
    }

    protected void readPivots(Resource pivotRec, Map<String, Vec3f> pivots) throws Exception {
        BufferedReader bufferedReader = pivotRec.m_215508_();
        String line = bufferedReader.readLine();
        while (line != null) {
            String[] params = line.split(" ");
            String bone = params[0];
            float x = Float.parseFloat(params[1]);
            float y = Float.parseFloat(params[2]);
            float z = Float.parseFloat(params[3]);
            pivots.put(bone, new Vec3f(x, y, z));
            line = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    protected void processBBJson(String fileName, JsonObject json, Map<String, Vec3f> pivots) throws Exception {
        String formatVersion = json.get("format_version").getAsString();
        if (!formatVersion.equals(COMPATIBLE_FORMAT_VERSIONS)) {
            throw new InvalidPropertiesFormatException("Block Bench animation format version " + formatVersion + " is not supported!");
        }
        JsonObject animations = json.get("animations").getAsJsonObject();
        Set animJsons = animations.entrySet();
        for (Map.Entry animJson : animJsons) {
            String animName = fileName + "." + (String)animJson.getKey();
            animMap.put(animName, BlockBenchAnims.getBBAnimFromJson(((JsonElement)animJson.getValue()).getAsJsonObject(), pivots));
            LOGGER.debug("ADD: {}", (Object)animName);
        }
    }

    private static BBAnim getBBAnimFromJson(JsonObject json, Map<String, Vec3f> pivots) throws Exception {
        return new BBAnim(json, pivots);
    }

    @Override
    public KeyframeAnimation getAnimation(String animation_id) {
        return animMap.get(animation_id);
    }

    static {
        animMap = new HashMap<String, BBAnim>();
    }
}

