/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.onewhohears.onewholibs.common.network.toclient.ToClientTestPreset;
import com.onewhohears.onewholibs.data.jsonpreset.test.TestPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.test.TestPresets;
import com.onewhohears.onewholibs.util.CommandUtil;
import com.onewhohears.onewholibs.util.UtilMCText;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TestPresetCommand {
    public TestPresetCommand(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"test_preset").requires(stack -> stack.m_6761_(2))).then(CommandUtil.presetIdArgument(TestPresets.get()).executes(TestPresetCommand.testPreset())));
    }

    private static Command<CommandSourceStack> testPreset() {
        return context -> {
            String presetId = StringArgumentType.getString((CommandContext)context, (String)"preset_id");
            if (!TestPresets.get().has(presetId)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.literal("The Test Preset " + presetId + " does not exist!"));
                return 0;
            }
            TestPresetStats stats = (TestPresetStats)TestPresets.get().get(presetId);
            if (stats == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.literal("The Test Preset " + presetId + " does not exist!"));
                return 0;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> UtilMCText.literal("The Test Preset " + presetId + " has a value of " + stats.getValue() + "!"), false);
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player != null) {
                new ToClientTestPreset(presetId).sendTo(player);
            }
            return 1;
        };
    }
}

