/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.event;

import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class OWLEvents {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final Event<GetJsonPresetListeners> GET_JSON_PRESET_LISTENERS = EventFactory.createLoop(GetJsonPresetListeners.class);
    public static final Event<RegisterPresetTypesEvent> REGISTER_PRESET_TYPES = EventFactory.createEventResult(RegisterPresetTypesEvent.class);
    public static final Event<OnSyncBoolGameRuleEvent> SYNC_BOOL_GAME_RULE = EventFactory.createEventResult(OnSyncBoolGameRuleEvent.class);
    public static final Event<OnSyncIntGameRuleEvent> SYNC_INT_GAME_RULE = EventFactory.createEventResult(OnSyncIntGameRuleEvent.class);

    @NotNull
    public static List<JsonPresetReloadListener<?>> getJsonPresetReloadListeners() {
        ArrayList gathered = new ArrayList();
        ((GetJsonPresetListeners)GET_JSON_PRESET_LISTENERS.invoker()).gather(gathered);
        return gathered;
    }

    public static void registerAllJsonPresetReloadListeners() {
        List<JsonPresetReloadListener<?>> listeners = OWLEvents.getJsonPresetReloadListeners();
        listeners.forEach(listener -> {
            LOGGER.info("Registering Json Preset Reload Listener: {}", (Object)listener.m_7812_());
            listener.registerDefaultPresetTypes();
            ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)listener);
        });
    }

    public static void registerPresetTypesEvent() {
        ((RegisterPresetTypesEvent)REGISTER_PRESET_TYPES.invoker()).register();
    }

    @FunctionalInterface
    public static interface GetJsonPresetListeners {
        public void gather(List<JsonPresetReloadListener<?>> var1);
    }

    @FunctionalInterface
    public static interface RegisterPresetTypesEvent {
        public void register();
    }

    @FunctionalInterface
    public static interface OnSyncBoolGameRuleEvent {
        public void sync(String var1, boolean var2);
    }

    @FunctionalInterface
    public static interface OnSyncIntGameRuleEvent {
        public void sync(String var1, int var2);
    }
}

