/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.network.toclient;

import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.common.event.OWLEvents;
import com.onewhohears.onewholibs.common.network.OWLPacketHandler;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.sun.nio.sctp.IllegalReceiveException;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ToClientDataPackSync
extends BaseS2CMessage {
    static final Logger LOGGER = LogUtils.getLogger();

    public ToClientDataPackSync() {
    }

    public MessageType getType() {
        return OWLPacketHandler.S2C_DATA_PACK_SYNC;
    }

    public void write(FriendlyByteBuf buffer) {
        List<JsonPresetReloadListener<?>> listeners = OWLEvents.getJsonPresetReloadListeners();
        buffer.writeInt(listeners.size());
        for (JsonPresetReloadListener<?> listener : listeners) {
            buffer.m_130070_(listener.m_7812_());
            listener.writeToBuffer(buffer);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
    }

    public ToClientDataPackSync(FriendlyByteBuf buffer) {
        OWLEvents.registerPresetTypesEvent();
        List<JsonPresetReloadListener<?>> listeners = OWLEvents.getJsonPresetReloadListeners();
        int num = buffer.readInt();
        for (int i = 0; i < num; ++i) {
            String name = buffer.m_130277_();
            JsonPresetReloadListener<?> listener = this.getListenerByName(name, listeners);
            if (listener == null) {
                LOGGER.error("Received Json preset data for unknown super type {}. The super type must be registered on the client side as well. Contact developer.", (Object)name);
                throw new IllegalReceiveException("Received Json preset data for unknown super type " + name + ". The super type must be registered on the client side as well. Contact developer.");
            }
            listener.registerDefaultPresetTypes();
            listener.readBuffer(buffer);
        }
    }

    @Nullable
    private JsonPresetReloadListener<?> getListenerByName(String name, List<JsonPresetReloadListener<?>> listeners) {
        for (JsonPresetReloadListener<?> listener : listeners) {
            if (!listener.m_7812_().equals(name)) continue;
            return listener;
        }
        return null;
    }
}

