/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.network.toclient;

import com.onewhohears.onewholibs.common.command.CustomGameRules;
import com.onewhohears.onewholibs.common.event.OWLEvents;
import com.onewhohears.onewholibs.common.network.OWLPacketHandler;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;

public class ToClientSyncGameRules
extends BaseS2CMessage {
    private final MinecraftServer server;

    public ToClientSyncGameRules(@NotNull MinecraftServer server) {
        this.server = server;
    }

    public ToClientSyncGameRules(FriendlyByteBuf buffer) {
        this.server = null;
        int boolNum = buffer.readInt();
        for (int i = 0; i < boolNum; ++i) {
            String id = buffer.m_130277_();
            boolean bool = buffer.readBoolean();
            ((OWLEvents.OnSyncBoolGameRuleEvent)OWLEvents.SYNC_BOOL_GAME_RULE.invoker()).sync(id, bool);
        }
        int intNum = buffer.readInt();
        for (int i = 0; i < intNum; ++i) {
            String id = buffer.m_130277_();
            int integer = buffer.readInt();
            ((OWLEvents.OnSyncIntGameRuleEvent)OWLEvents.SYNC_INT_GAME_RULE.invoker()).sync(id, integer);
        }
    }

    public MessageType getType() {
        return OWLPacketHandler.S2C_SYNC_GAME_RULES;
    }

    public void write(FriendlyByteBuf buffer) {
        GameRules gamerules = this.server.m_129900_();
        buffer.writeInt(CustomGameRules.getSyncBools().size());
        CustomGameRules.getSyncBools().forEach(booleanValueKey -> {
            buffer.m_130070_(booleanValueKey.m_46328_());
            buffer.writeBoolean(gamerules.m_46207_(booleanValueKey));
        });
        buffer.writeInt(CustomGameRules.getSyncInts().size());
        CustomGameRules.getSyncInts().forEach(integerValueKey -> {
            buffer.m_130070_(integerValueKey.m_46328_());
            buffer.writeInt(gamerules.m_46215_(integerValueKey));
        });
    }

    public void handle(NetworkManager.PacketContext context) {
    }
}

