/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.crafting;

import com.onewhohears.onewholibs.data.crafting.forge.IngredientStackImpl;
import com.onewhohears.onewholibs.util.UtilItem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IngredientStack
extends Ingredient {
    public final int cost;

    public static IngredientStack fromItem(String itemId, int cost) {
        return new IngredientStack((Ingredient.Value)new Ingredient.ItemValue(UtilItem.getItem(itemId).m_7968_()), cost);
    }

    public static IngredientStack fromItem(ItemStack item, int cost) {
        return new IngredientStack((Ingredient.Value)new Ingredient.ItemValue(item), cost);
    }

    public static IngredientStack fromTag(String tagId, int cost) {
        return new IngredientStack((Ingredient.Value)new Ingredient.TagValue(IngredientStack.createItemTag(tagId)), cost);
    }

    public static TagKey<Item> createItemTag(String id) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.m_135820_((String)id));
    }

    public static IngredientStack fromIngredient(Ingredient ingredient) {
        Ingredient.Value[] values = new Ingredient.Value[ingredient.m_43908_().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new Ingredient.ItemValue(ingredient.m_43908_()[i]);
        }
        return new IngredientStack(Stream.of(values), 1);
    }

    @NotNull
    public static IngredientStack fromNetwork(FriendlyByteBuf buffer) {
        Stream<Ingredient.Value> stream = buffer.m_236845_(FriendlyByteBuf::m_130267_).stream().map(Ingredient.ItemValue::new);
        int cost = buffer.readInt();
        return new IngredientStack(stream, cost);
    }

    public static void toNetwork(FriendlyByteBuf buffer, Ingredient ingredient) {
        IngredientStack.dissolve(ingredient);
        buffer.m_236828_(Arrays.asList(ingredient.f_43903_), FriendlyByteBuf::m_130055_);
        if (ingredient instanceof IngredientStack) {
            IngredientStack stack = (IngredientStack)ingredient;
            buffer.writeInt(stack.cost);
        } else {
            buffer.writeInt(1);
        }
    }

    protected IngredientStack(Ingredient.Value value, int cost) {
        this(Stream.of(value), cost);
    }

    protected IngredientStack(Stream<Ingredient.Value> values, int cost) {
        super(values);
        this.cost = cost;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        ItemStack[] items = this.m_43908_();
        if (items.length == 0) {
            return stack.m_41619_();
        }
        for (ItemStack itemstack : items) {
            if (!itemstack.m_150930_(stack.m_41720_()) || stack.m_41613_() < this.cost) continue;
            return true;
        }
        return false;
    }

    public ItemStack @NotNull [] m_43908_() {
        ItemStack[] items;
        for (ItemStack item : items = super.m_43908_()) {
            item.m_41764_(this.cost);
        }
        return items;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void dissolve(Ingredient ingredient) {
        IngredientStackImpl.dissolve(ingredient);
    }
}

