/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class JsonPresetGenerator<T extends JsonPresetStats>
implements DataProvider {
    protected final Logger LOGGER = LogUtils.getLogger();
    protected final PackOutput.PathProvider pathProvider;
    public final Map<ResourceLocation, T> GEN_MAP = new HashMap<ResourceLocation, T>();

    public JsonPresetGenerator(PackOutput output, String kind) {
        this(output, kind, PackOutput.Target.DATA_PACK);
    }

    public JsonPresetGenerator(PackOutput output, String kind, PackOutput.Target target) {
        this.pathProvider = output.m_245269_(target, kind);
    }

    protected abstract void registerPresets();

    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.GEN_MAP.clear();
        this.registerPresets();
        HashSet set = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        Consumer<JsonPresetStats> consumer = preset -> {
            this.LOGGER.debug("GENERATING: {}", (Object)preset.getKey().toString());
            if (!set.add(preset.getKey())) {
                throw new IllegalStateException("Duplicate Preset! " + String.valueOf(preset.getKey()));
            }
            Path path = this.pathProvider.m_245731_(preset.getKey());
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)preset.getJsonData(), (Path)path));
        };
        this.generatePresets(consumer);
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected void generatePresets(Consumer<T> consumer) {
        this.GEN_MAP.forEach((key, preset) -> consumer.accept(preset));
    }

    public void addPresetToGenerate(T preset) {
        this.GEN_MAP.put(((JsonPresetStats)preset).getKey(), preset);
    }
}

