/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.data.jsonpreset.PresetStatsHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface JsonPresetReloader<T extends JsonPresetStats> {
    @Nullable
    default public T get(String id) {
        if (id == null) {
            return null;
        }
        if (!this.has(id)) {
            return null;
        }
        return (T)((JsonPresetStats)this.getPresetMap().get(id));
    }

    @Nullable
    default public PresetStatsHolder<T> getHolder(String id) {
        if (id == null) {
            return null;
        }
        if (!this.has(id)) {
            return null;
        }
        return new PresetStatsHolder(this, id);
    }

    default public boolean has(String id) {
        return this.getPresetMap().containsKey(id);
    }

    public T[] getAll();

    public T[] getNewArray(int var1);

    default public String[] getAllIds() {
        String[] names = new String[this.getAll().length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.getAll()[i].getId();
        }
        return names;
    }

    public int getReloads();

    default public int getNum() {
        return this.getPresetMap().size();
    }

    public Map<String, T> getPresetMap();

    public Map<String, JsonPresetType> getTypeMap();

    @Nullable
    default public T getFromJson(ResourceLocation key, JsonObject json) {
        if (!json.has("presetType")) {
            return null;
        }
        String presetType = json.get("presetType").getAsString();
        JsonPresetType type = this.getTypeMap().get(presetType);
        if (type == null) {
            this.getLogger().warn("ERROR: Preset Type {} has not been registered!", (Object)presetType);
            return null;
        }
        return type.createStats(key, json);
    }

    default public void addPresetType(JsonPresetType type) {
        this.getTypeMap().put(type.getId(), type);
    }

    public Logger getLogger();

    default public void mergeCopyWithParentPresets() {
        this.getLogger().info("MERGING COPIES WITH PARENT PRESETS {}", (Object)this.m_7812_());
        this.getPresetMap().forEach(this::mergeWithParent);
        this.getPresetMap().forEach((id, preset) -> {
            if (preset.isCopy()) {
                this.getPresetMap().put((String)id, preset.getType().createStats(preset.getKey(), preset.copyJsonData()));
            }
        });
    }

    default public void mergeWithParent(String id, T preset) {
        if (!((JsonPresetStats)preset).isCopy() || ((JsonPresetStats)preset).hasBeenMerged()) {
            return;
        }
        if (!this.has(((JsonPresetStats)preset).getCopyId())) {
            this.getLogger().warn("ERROR: Preset {} does not exist so {} can't be merged!", (Object)((JsonPresetStats)preset).getCopyId(), (Object)id);
            return;
        }
        T copy = this.get(((JsonPresetStats)preset).getCopyId());
        if (copy == null) {
            this.getLogger().warn("MERGE FAIL: {} can't merge because {} doesn't exist!", (Object)id, (Object)((JsonPresetStats)preset).getCopyId());
            return;
        }
        if (((JsonPresetStats)copy).isCopy() && !((JsonPresetStats)copy).hasBeenMerged()) {
            this.mergeWithParent(((JsonPresetStats)copy).getId(), copy);
        }
        if (!((JsonPresetStats)preset).mergeWithParent((JsonPresetStats)copy)) {
            this.getLogger().warn("MERGE FAIL: {} with {}", (Object)id, (Object)((JsonPresetStats)copy).getId());
            return;
        }
        this.getLogger().info("MERGED: {} with {}", (Object)id, (Object)((JsonPresetStats)copy).getId());
    }

    public String m_7812_();

    default public <K extends T> List<K> getPresetsOfType(JsonPresetType type) {
        ArrayList presets = new ArrayList();
        this.getPresetMap().forEach((id, preset) -> {
            if (preset.getType().is(type)) {
                presets.add(preset);
            }
        });
        return presets;
    }

    default public void applyJson(ResourceLocation key, JsonObject json) {
        T data = this.getFromJson(key, json);
        if (data == null) {
            this.getLogger().error("ERROR: failed to parse preset {}", (Object)key.toString());
            return;
        }
        if (!this.getPresetMap().containsKey(((JsonPresetStats)data).getId())) {
            this.getPresetMap().put(((JsonPresetStats)data).getId(), data);
        } else {
            JsonPresetStats otherData = (JsonPresetStats)this.getPresetMap().get(((JsonPresetStats)data).getId());
            if (((JsonPresetStats)data).getPriority() >= otherData.getPriority()) {
                this.getPresetMap().put(((JsonPresetStats)data).getId(), data);
                this.getLogger().debug("Preset {} is overriding {}!", (Object)key.toString(), (Object)otherData.getKey().toString());
            } else {
                this.getLogger().debug("Preset {} was overriden by {}.", (Object)key.toString(), (Object)otherData.getKey().toString());
            }
        }
    }

    default public void sort(List<T> presets) {
        presets.sort(JsonPresetStats::compare);
    }

    default public void sort(T[] presets) {
        Arrays.sort(presets, JsonPresetStats::compare);
    }
}

