/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.util.UtilMCText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class JsonPresetType {
    private static int DEFAULT_SORT_FACTOR_COUNT = 0;
    private final String id;
    private final String displayName;
    private final JsonPresetStatsFactory<? extends JsonPresetStats> statsFactory;
    private final int sortFactor;

    public JsonPresetType(String id, JsonPresetStatsFactory<? extends JsonPresetStats> statsFactory, String displayName) {
        this.id = id;
        this.displayName = displayName;
        this.statsFactory = statsFactory;
        this.sortFactor = DEFAULT_SORT_FACTOR_COUNT++;
    }

    public JsonPresetType(String id, JsonPresetStatsFactory<? extends JsonPresetStats> statsFactory) {
        this(id, statsFactory, "preset.type." + id);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MutableComponent getDisplayNameComponent() {
        String dn = this.getDisplayName();
        if (dn.startsWith("preset.")) {
            return UtilMCText.translatable(dn);
        }
        return UtilMCText.literal(dn);
    }

    public boolean equals(Object o) {
        if (o instanceof JsonPresetType) {
            JsonPresetType jpt = (JsonPresetType)o;
            return this.getId().equals(jpt.getId());
        }
        return false;
    }

    public boolean is(JsonPresetType type) {
        return this.getId().equals(type.getId());
    }

    public int getSortFactor() {
        return this.sortFactor;
    }

    public String toString() {
        return "Preset Type: " + this.getId();
    }

    public <T extends JsonPresetStats> T createStats(ResourceLocation key, JsonObject data) {
        return (T)this.statsFactory.create(key, data);
    }

    public static interface JsonPresetStatsFactory<T extends JsonPresetStats> {
        public T create(ResourceLocation var1, JsonObject var2);
    }
}

