/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.shadow.de.javagl.obj;

import com.onewhohears.onewholibs.shadow.de.javagl.obj.FloatTuple;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.FloatTuples;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.Mtl;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.TextureOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

public class MtlWriter {
    public static void write(Iterable<? extends Mtl> mtls, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        MtlWriter.write(mtls, (Writer)outputStreamWriter);
    }

    public static void write(Iterable<? extends Mtl> mtls, Writer writer) throws IOException {
        for (Mtl mtl : mtls) {
            MtlWriter.write(mtl, writer);
        }
    }

    private static void write(Mtl mtl, Writer writer) throws IOException {
        writer.write(MtlWriter.createString(mtl));
        writer.flush();
    }

    private static String createString(Mtl mtl) {
        StringBuilder sb = new StringBuilder("newmtl ");
        sb.append(mtl.getName()).append("\n");
        MtlWriter.append(sb, "illum", mtl.getIllum(), "\n");
        MtlWriter.append(sb, "Ns", mtl.getNs(), "\n");
        MtlWriter.append(sb, "Ni", mtl.getNi(), "\n");
        Float opacity = mtl.getD();
        if (opacity != null) {
            sb.append("d").append(" ");
            if (Boolean.TRUE.equals(mtl.isHalo())) {
                sb.append("-halo").append(" ");
            }
            sb.append(opacity);
            sb.append("\n");
        }
        MtlWriter.appendTuple(sb, "Ka", mtl.getKa(), "\n");
        MtlWriter.appendTuple(sb, "Kd", mtl.getKd(), "\n");
        MtlWriter.appendTuple(sb, "Ks", mtl.getKs(), "\n");
        MtlWriter.appendTuple(sb, "Tf", mtl.getTf(), "\n");
        MtlWriter.append(sb, "sharpness", mtl.getSharpness(), "\n");
        MtlWriter.appendTextureOptions(sb, "map_Ka", mtl.getMapKaOptions());
        MtlWriter.appendTextureOptions(sb, "map_Kd", mtl.getMapKdOptions());
        MtlWriter.appendTextureOptions(sb, "map_Ks", mtl.getMapKsOptions());
        MtlWriter.appendTextureOptions(sb, "map_Ns", mtl.getMapNsOptions());
        MtlWriter.appendTextureOptions(sb, "map_d", mtl.getMapDOptions());
        MtlWriter.appendTextureOptions(sb, "bump", mtl.getBumpOptions());
        MtlWriter.appendTextureOptions(sb, "disp", mtl.getDispOptions());
        MtlWriter.appendTextureOptions(sb, "decal", mtl.getDecalOptions());
        List<TextureOptions> refls = mtl.getReflOptions();
        for (TextureOptions refl : refls) {
            MtlWriter.appendTextureOptions(sb, "refl", refl);
        }
        MtlWriter.append(sb, "Pr", mtl.getPr(), "\n");
        MtlWriter.appendTextureOptions(sb, "map_Pr", mtl.getMapPrOptions());
        MtlWriter.append(sb, "Pm", mtl.getPm(), "\n");
        MtlWriter.appendTextureOptions(sb, "map_Pm", mtl.getMapPmOptions());
        MtlWriter.append(sb, "Ps", mtl.getPs(), "\n");
        MtlWriter.appendTextureOptions(sb, "map_Ps", mtl.getMapPsOptions());
        MtlWriter.append(sb, "Pc", mtl.getPc(), "\n");
        MtlWriter.append(sb, "Pcr", mtl.getPcr(), "\n");
        MtlWriter.appendTuple(sb, "Ke", mtl.getKe(), "\n");
        MtlWriter.appendTextureOptions(sb, "map_Ke", mtl.getMapKeOptions());
        MtlWriter.append(sb, "aniso", mtl.getAniso(), "\n");
        MtlWriter.append(sb, "anisor", mtl.getAnisor(), "\n");
        MtlWriter.appendTextureOptions(sb, "norm", mtl.getNormOptions());
        return sb.toString();
    }

    private static void appendTextureOptions(StringBuilder sb, String key, TextureOptions options) {
        if (options != null) {
            sb.append(key).append(" ");
            sb.append(MtlWriter.createString(options)).append("\n");
        }
    }

    static String createString(TextureOptions options) {
        StringBuilder sb = new StringBuilder();
        MtlWriter.append(sb, "-blendu", options.isBlendu(), " ");
        MtlWriter.append(sb, "-blendv", options.isBlendv(), " ");
        MtlWriter.append(sb, "-boost", options.getBoost(), " ");
        MtlWriter.appendTuple(sb, "-mm", options.getMm(), " ");
        MtlWriter.appendTuple(sb, "-o", options.getO(), " ");
        MtlWriter.appendTuple(sb, "-s", options.getS(), " ");
        MtlWriter.appendTuple(sb, "-t", options.getT(), " ");
        MtlWriter.append(sb, "-texres", options.getTexres(), " ");
        MtlWriter.append(sb, "-clamp", options.isClamp(), " ");
        MtlWriter.append(sb, "-bm", options.getBm(), " ");
        MtlWriter.append(sb, "-imfchan", options.getImfchan(), " ");
        MtlWriter.append(sb, "-type", options.getType(), " ");
        sb.append(options.getFileName());
        return sb.toString();
    }

    private static void append(StringBuilder sb, String key, Object value, String separator) {
        if (value != null) {
            sb.append(key).append(" ");
            sb.append(value);
            sb.append(separator);
        }
    }

    private static void append(StringBuilder sb, String key, Boolean value, String separator) {
        if (value != null) {
            sb.append(key).append(" ");
            if (value.booleanValue()) {
                sb.append("on");
            } else {
                sb.append("off");
            }
            sb.append(separator);
        }
    }

    private static void appendTuple(StringBuilder sb, String key, FloatTuple value, String separator) {
        if (value != null) {
            sb.append(key).append(" ");
            sb.append(FloatTuples.createString(value));
            sb.append(separator);
        }
    }

    private MtlWriter() {
    }
}

