/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.shadow.de.javagl.obj;

import com.onewhohears.onewholibs.shadow.de.javagl.obj.FloatTuple;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.FloatTuples;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjFace;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjFaces;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ReadableObj;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ObjWriter {
    public static void write(ReadableObj input, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        ObjWriter.write(input, outputStreamWriter);
    }

    public static void write(ReadableObj input, Writer writer) throws IOException {
        int i;
        List<String> mtlFileNames = input.getMtlFileNames();
        if (!mtlFileNames.isEmpty()) {
            writer.write("mtllib ");
            for (i = 0; i < mtlFileNames.size(); ++i) {
                if (i > 0) {
                    writer.write(" ");
                }
                writer.write(mtlFileNames.get(i));
            }
            writer.write("\n");
        }
        for (i = 0; i < input.getNumVertices(); ++i) {
            FloatTuple vertex = input.getVertex(i);
            writer.write("v " + FloatTuples.createString(vertex) + "\n");
        }
        for (i = 0; i < input.getNumTexCoords(); ++i) {
            FloatTuple texCoord = input.getTexCoord(i);
            writer.write("vt " + FloatTuples.createString(texCoord) + "\n");
        }
        for (i = 0; i < input.getNumNormals(); ++i) {
            FloatTuple normal = input.getNormal(i);
            writer.write("vn " + FloatTuples.createString(normal) + "\n");
        }
        boolean skipWritingDefaultGroup = true;
        for (int i2 = 0; i2 < input.getNumFaces(); ++i2) {
            String activatedMaterialGroupName;
            ObjFace face = input.getFace(i2);
            Set<String> activatedGroupNames = input.getActivatedGroupNames(face);
            if (activatedGroupNames != null) {
                boolean isDefaultGroup = activatedGroupNames.equals(Collections.singleton("default"));
                if (!skipWritingDefaultGroup || !isDefaultGroup) {
                    writer.write("g ");
                    for (String activatedGroupName : activatedGroupNames) {
                        writer.write(activatedGroupName);
                        writer.write(" ");
                    }
                    writer.write("\n");
                }
                skipWritingDefaultGroup = false;
            }
            if ((activatedMaterialGroupName = input.getActivatedMaterialGroupName(face)) != null) {
                writer.write("usemtl " + activatedMaterialGroupName + "\n");
            }
            String faceString = ObjFaces.createString(face);
            writer.write(faceString + "\n");
        }
        writer.flush();
    }

    private ObjWriter() {
    }
}

