/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.input;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.ActionInput;
import com.onewhohears.dscombat.client.input.ActionInputHolder;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.input.forge.ClientInputManagerImpl;
import com.onewhohears.dscombat.client.screen.VehicleMainScreen;
import com.onewhohears.dscombat.client.screen.VehicleScreen;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.common.network.toserver.ToServerSeatPos;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityGimbal;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilPrint;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ClientInputManager {
    public static final float THROTTLE_CHANGE_RATE = 0.075f;
    private static final Map<String, ActionInputHolder.Button> buttons = new HashMap<String, ActionInputHolder.Button>();
    private static final Map<String, ActionInputHolder.Axis> axes = new HashMap<String, ActionInputHolder.Axis>();
    public static final ActionInputHolder.Axis THROTTLE = ClientInputManager.registerAxis("throttle", "throttle_down_key", "throttle_up_key");
    public static final ActionInputHolder.Axis PITCH = ClientInputManager.registerAxis("pitch", "pitch_down_key", "pitch_up_key");
    public static final ActionInputHolder.Axis ROLL = ClientInputManager.registerAxis("roll", "roll_left_key", "roll_right_key");
    public static final ActionInputHolder.Axis YAW = ClientInputManager.registerAxis("yaw", "yaw_left_key", "yaw_right_key");
    public static final ActionInputHolder.Button MOUSE_MODE = ClientInputManager.registerButton("mouse_mode", "mouse_mode_key");
    public static final ActionInputHolder.Button FLIP_CONTROLS = ClientInputManager.registerButton("flip_controls", "flip_controls_key");
    public static final ActionInputHolder.Button RESET_MOUSE = ClientInputManager.registerButton("reset_mouse", "reset_mouse_key");
    public static final ActionInputHolder.Button LEAN_LEFT = ClientInputManager.registerButton("lean_left", "lean_left_key");
    public static final ActionInputHolder.Button LEAN_RIGHT = ClientInputManager.registerButton("lean_right", "lean_right_key");
    public static final ActionInputHolder.Button TURN_ASSIST = ClientInputManager.registerButton("turn_assist", "turn_assist_key");
    public static final ActionInputHolder.Button CAMERA_TRACK_TARGET = ClientInputManager.registerButton("camera_track_target", "camera_track_target_key");
    public static final ActionInputHolder.Button VEHICLE_MENU = ClientInputManager.registerButton("vehicle_menu", "plane_menu_key");
    public static final ActionInputHolder.Button DISMOUNT = ClientInputManager.registerButton("dismount", "dismount_key");
    public static final ActionInputHolder.Button CHANGE_SEAT = ClientInputManager.registerButton("change_seat", "change_seat_key");
    public static final ActionInputHolder.Button LANDING_GEAR = ClientInputManager.registerButton("landing_gear", "landing_gear_key");
    public static final ActionInputHolder.Button GIMBAL = ClientInputManager.registerButton("gimbal", "gimbal_key");
    public static final ActionInputHolder.Button SPECIAL1 = ClientInputManager.registerButton("special1", "special_key");
    public static final ActionInputHolder.Button SPECIAL2 = ClientInputManager.registerButton("special2", "special_2_key");
    public static final ActionInputHolder.Button EJECT = ClientInputManager.registerButton("eject", "eject_key");
    public static final ActionInputHolder.Button SHOOT = ClientInputManager.registerButton("shoot", "shoot_key");
    public static final ActionInputHolder.Button WEAPON_CYCLE = ClientInputManager.registerButton("weapon_cycle", "weapon_select_key");
    public static final ActionInputHolder.Button WEAPON_CYCLE_INVERSE = ClientInputManager.registerButton("weapon_cycle_inverse", "weapon_select_up_key");
    public static final ActionInputHolder.Button FLARE = ClientInputManager.registerButton("flare", "flare_key");
    public static final ActionInputHolder.Button CHAFF = ClientInputManager.registerButton("chaff", "chaff_key");
    public static final ActionInputHolder.Button RADAR_MODE = ClientInputManager.registerButton("radar_mode", "radar_mode_key");
    public static final ActionInputHolder.Button PING_CYCLE = ClientInputManager.registerButton("ping_cycle", "ping_cycle_key");
    public static final ActionInputHolder.Button AFTERBURNER = ClientInputManager.registerButton("afterburner", "afterburner_toggle_key");
    private static int leftTicks = 0;
    private static long radarModeUpdateTime = 0L;
    private static float currentThrottle = 0.0f;
    private static boolean wasPilot = false;
    private static float smPitch = 0.0f;
    private static float smRoll = 0.0f;
    private static float smYaw = 0.0f;

    private static void pilotTick(@NotNull Minecraft mc, @NotNull Player player, @NotNull EntityVehicle vehicle) {
        boolean flipPitchThrottle;
        int invertPitch;
        if (MOUSE_MODE.isInitPressed()) {
            DSCClientInputs.cycleMouseMode();
        }
        if (RESET_MOUSE.isPressed()) {
            DSCClientInputs.centerMousePos();
            if (vehicle.isTestMode()) {
                player.m_146926_(0.0f);
                player.m_146922_(0.0f);
                vehicle.setClientQ(QuaternionF.ONE);
            }
        } else if (mc.f_91080_ != null) {
            DSCClientInputs.centerMousePos();
        }
        boolean flare = FLARE.isPressed();
        boolean chaff = CHAFF.isPressed();
        if (AFTERBURNER.isInitPressed()) {
            DSCClientInputs.toggleAfterBurner();
        }
        if (TURN_ASSIST.isInitPressed()) {
            DSCClientInputs.toggleTurnAssist();
        }
        if (CAMERA_TRACK_TARGET.isInitPressed()) {
            DSCClientInputs.toggleCameraTrackTarget();
        }
        boolean flip = FLIP_CONTROLS.isPressed();
        boolean special = SPECIAL1.isPressed();
        boolean special2 = SPECIAL2.isPressed();
        int n = invertPitch = (Boolean)Config.CLIENT.invertY.get() != false ? 1 : -1;
        if (((VehicleStats)vehicle.getStats()).ignoreInvertY()) {
            invertPitch = -1;
        }
        float throttle = THROTTLE.getValue();
        float pitch = PITCH.getValue();
        float roll = ROLL.getValue();
        float yaw = YAW.getValue();
        boolean isBothRoll = ROLL.isNegAndPos();
        if (flip) {
            float temp = yaw;
            yaw = roll;
            roll = temp;
        }
        boolean type_flip = ((VehicleStats)vehicle.getStats()).flipPitchThrottle();
        boolean mode = DSCClientInputs.isCameraLockedForward();
        boolean bl = flipPitchThrottle = !type_flip && flip ^ mode || type_flip && !flip;
        if (flipPitchThrottle) {
            float temp = throttle;
            throttle = pitch;
            pitch = temp;
        }
        double mouseX = mc.f_91067_.m_91589_() - DSCClientInputs.getMouseCenterX();
        double mouseY = -(mc.f_91067_.m_91594_() - DSCClientInputs.getMouseCenterY());
        if (DSCClientInputs.isCameraLockedForward()) {
            int step;
            double ya = Math.abs(mouseY);
            double xa = Math.abs(mouseX);
            float ys = (float)Math.signum(mouseY) * (float)(-invertPitch);
            float xs = (float)Math.signum(mouseX);
            double max = (Double)Config.CLIENT.mouseModeMaxRadius.get();
            float stickStepsY = ((Integer)Config.CLIENT.mouseYSteps.get()).intValue();
            float stickStepsX = ((Integer)Config.CLIENT.mouseXSteps.get()).intValue();
            if (ya >= max) {
                pitch = ys;
            } else {
                step = (int)(ya / max * (double)stickStepsY * (double)ys);
                pitch = (float)step / stickStepsY;
            }
            if (xa >= max) {
                roll = xs;
            } else {
                step = (int)(xa / max * (double)stickStepsX * (double)xs);
                roll = (float)step / stickStepsX;
            }
            if (ClientInputManager.getMouseYVelocity(mc) == 0.0) {
                DSCClientInputs.setMouseCenterY((int)Mth.m_14121_((float)((float)DSCClientInputs.getMouseCenterY()), (float)((float)mc.f_91067_.m_91594_()), (float)((Double)Config.CLIENT.mouseYReturnRate.get()).floatValue()));
            }
            if (ClientInputManager.getMouseXVelocity(mc) == 0.0) {
                DSCClientInputs.setMouseCenterX((int)Mth.m_14121_((float)((float)DSCClientInputs.getMouseCenterX()), (float)((float)mc.f_91067_.m_91589_()), (float)((Double)Config.CLIENT.mouseXReturnRate.get()).floatValue()));
            }
        } else {
            pitch *= (float)invertPitch;
        }
        float zeroThrottle = ((VehicleStats)vehicle.getStats()).negativeThrottle ? 0.0f : -1.0f;
        if (!wasPilot && vehicle.cutThrottleOnNoPilot()) {
            currentThrottle = zeroThrottle;
        }
        if (ActionInput.isWindowActive()) {
            float incRate = vehicle.getThrottleIncreaseRate();
            float decRate = vehicle.getThrottleDecreaseRate();
            if (vehicle.inputs.isThrottleOverride(vehicle)) {
                float goal = vehicle.inputs.getGoalThrottle(vehicle);
                if (!((VehicleStats)vehicle.getStats()).negativeThrottle) {
                    goal = goal * 2.0f - 1.0f;
                }
                float step = goal >= currentThrottle ? incRate : decRate;
                currentThrottle = Mth.m_14121_((float)currentThrottle, (float)goal, (float)step);
            } else if (flipPitchThrottle && type_flip && THROTTLE.isJoystickController()) {
                currentThrottle = THROTTLE.getValue();
            } else if (!flipPitchThrottle && THROTTLE.isNegAndPos() || flipPitchThrottle && PITCH.isNegAndPos()) {
                currentThrottle = Mth.m_14121_((float)currentThrottle, (float)zeroThrottle, (float)decRate);
            } else if (!flipPitchThrottle && THROTTLE.isJoystickController() || flipPitchThrottle && PITCH.isJoystickController()) {
                currentThrottle = throttle;
            } else if (throttle > 0.0f) {
                currentThrottle = Mth.m_14121_((float)currentThrottle, (float)1.0f, (float)incRate);
            } else if (throttle < 0.0f) {
                currentThrottle = Mth.m_14121_((float)currentThrottle, (float)-1.0f, (float)incRate);
            }
        }
        if (((VehicleStats)vehicle.getStats()).isHeli() && ((Boolean)Config.CLIENT.enableHeliInputSmoothing.get()).booleanValue()) {
            float stepPitch = ((Double)Config.CLIENT.heliPitchSmoothingStep.get()).floatValue();
            float stepRoll = ((Double)Config.CLIENT.heliRollSmoothingStep.get()).floatValue();
            float stepYaw = ((Double)Config.CLIENT.heliYawSmoothingStep.get()).floatValue();
            smPitch = Mth.m_14121_((float)smPitch, (float)pitch, (float)stepPitch);
            smRoll = Mth.m_14121_((float)smRoll, (float)roll, (float)stepRoll);
            smYaw = Mth.m_14121_((float)smYaw, (float)yaw, (float)stepYaw);
            pitch = smPitch;
            roll = smRoll;
            yaw = smYaw;
        } else {
            smPitch = pitch;
            smRoll = roll;
            smYaw = yaw;
        }
        float t = ((VehicleStats)vehicle.getStats()).negativeThrottle ? currentThrottle : (currentThrottle + 1.0f) / 2.0f;
        vehicle.inputs.clientPilotControlsToServer(vehicle, t, pitch, roll, yaw, flare, chaff, DSCClientInputs.isAfterBurner(), special, special2, isBothRoll, DSCClientInputs.isCameraLockedForward(), DSCClientInputs.isTurnAssist());
        if (!DSCClientInputs.isCameraLockedForward()) {
            DSCClientInputs.centerMousePos();
        }
        if (LANDING_GEAR.isInitPressed()) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.LandingGearAction(vehicle.toggleLandingGear()));
        }
    }

    private static void passengerTick(@NotNull Minecraft mc, @NotNull Player player, @NotNull EntityVehicle vehicle, @NotNull EntityRidablePart seat) {
        boolean cycleRadarMode;
        boolean isRadarController = player.equals((Object)vehicle.getControllingPlayerOrBot());
        if (DSCClientInputs.disable3rdPersonVehicle) {
            mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
        if (player.f_19797_ % (Integer)Config.CLIENT.syncSeatPosRate.get() == 0) {
            new ToServerSeatPos(seat.m_20182_()).sendToServer();
        }
        if (CHANGE_SEAT.isInitPressed()) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.SwitchSeatAction());
        }
        int selectNextWeapon = 0;
        if (WEAPON_CYCLE_INVERSE.isInitPressed()) {
            selectNextWeapon = -1;
        } else if (WEAPON_CYCLE.isInitPressed()) {
            selectNextWeapon = 1;
        }
        vehicle.weaponSystem.selectNextWeapon(selectNextWeapon);
        RadarSystem radar = vehicle.radarSystem;
        if (DSCClientInputs.isRadarHovering() && leftTicks == 1) {
            List<RadarStats.RadarPing> pings = radar.getClientRadarPings();
            if (DSCClientInputs.getRadarHoverIndex() < pings.size()) {
                radar.clientSelectTarget(pings.get(DSCClientInputs.getRadarHoverIndex()));
            }
        }
        if (PING_CYCLE.isInitPressed()) {
            radar.clientSelectNextTarget();
        }
        if (SHOOT.isPressed() && ClientInputManager.playerCanShoot(player)) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.ShootAction(vehicle.weaponSystem.getSelectedIndex(), radar.getClientSelectedPing(), ClientInputManager.getShootPos(player, vehicle)));
        }
        if (((Boolean)Config.CLIENT.customDismount.get()).booleanValue() && DISMOUNT.isPressed()) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.DismountAction());
        }
        if (EJECT.isInitPressed()) {
            if (seat.canEject()) {
                seat.useEject();
                ClientInputManager.sendSyncAction(new VehicleSyncAction.DismountAction(true));
                UtilEntity.getLevel((Entity)player).m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.EJECT_WIND, SoundSource.PLAYERS, 0.5f, 1.0f, false);
            } else {
                ClientInputManager.sendSyncAction(new VehicleSyncAction.DismountAction(false));
            }
        }
        if (cycleRadarMode = RADAR_MODE.isInitPressed()) {
            DSCClientInputs.cyclePreferredRadarMode();
            if (!isRadarController) {
                player.m_5661_((Component)UtilMCText.translatable((String)"info.dscombat.not_radar_controller"), true);
            }
        }
        if (isRadarController && DSCClientInputs.getPreferredRadarMode() != vehicle.getRadarMode() && Util.m_137550_() - radarModeUpdateTime > 500L) {
            ClientInputManager.sendSyncAction(new VehicleSyncAction.SetRadarModeAction(DSCClientInputs.getPreferredRadarMode()));
            radarModeUpdateTime = Util.m_137550_();
        }
        if (GIMBAL.isInitPressed()) {
            DSCClientInputs.toggleGimbalMode();
        }
        if (VEHICLE_MENU.isInitPressed() && !(mc.f_91080_ instanceof VehicleScreen)) {
            mc.m_91152_((Screen)new VehicleMainScreen());
        }
        boolean leanLeft = LEAN_LEFT.isInitPressed();
        boolean leanRight = LEAN_RIGHT.isInitPressed();
        if (leanLeft && leanRight) {
            DSCClientInputs.leanNot();
        } else if (leanLeft) {
            DSCClientInputs.leanLeft();
        } else if (leanRight) {
            DSCClientInputs.leanRight();
        }
    }

    private static void tickActions() {
        buttons.forEach((id, action) -> action.tick());
        axes.forEach((id, action) -> action.tick());
    }

    public static void clientTickFirst() {
        Entity entity;
        ClientInputManager.tickActions();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            if (wasPilot) {
                smYaw = 0.0f;
                smRoll = 0.0f;
                smPitch = 0.0f;
            }
            wasPilot = false;
            return;
        }
        if (!player.m_20159_() || !((entity = player.m_20201_()) instanceof EntityVehicle)) {
            if (wasPilot) {
                smYaw = 0.0f;
                smRoll = 0.0f;
                smPitch = 0.0f;
            }
            wasPilot = false;
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        LivingEntity controller = vehicle.m_6688_();
        if (controller == null || !controller.equals((Object)player)) {
            if (wasPilot) {
                smYaw = 0.0f;
                smRoll = 0.0f;
                smPitch = 0.0f;
            }
            wasPilot = false;
            return;
        }
        ClientInputManager.pilotTick(mc, (Player)player, vehicle);
        wasPilot = true;
    }

    public static void clientTickSecond() {
        Minecraft mc = Minecraft.m_91087_();
        leftTicks = mc.f_91067_.m_91560_() ? ++leftTicks : 0;
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_20159_()) {
            return;
        }
        Entity entity = player.m_20202_();
        if (!(entity instanceof EntityRidablePart)) {
            return;
        }
        EntityRidablePart seat = (EntityRidablePart)entity;
        EntityVehicle vehicle = seat.getParentVehicle();
        if (vehicle == null) {
            return;
        }
        ClientInputManager.passengerTick(mc, (Player)player, vehicle, seat);
    }

    public static void sendSyncAction(VehicleSyncAction action) {
        VehicleSyncAction.sendSyncAction(action);
    }

    public static Vec3 getShootPos(Player player, EntityVehicle vehicle) {
        switch (DSCClientInputs.getTargetMode()) {
            case LOOK: {
                return ClientInputManager.getLookPos(player, vehicle);
            }
            case COORDS: {
                return Config.CLIENT.getTargetPos();
            }
            case INDICATOR: {
                return Vec3.f_82478_;
            }
        }
        return Vec3.f_82478_;
    }

    public static Vec3 getLookPos(Player player, EntityVehicle vehicle) {
        EntityGimbal gimbal;
        Object looker = player;
        if (DSCClientInputs.isGimbalMode() && (gimbal = vehicle.getGimbalForPilotCamera()) != null) {
            looker = gimbal;
            looker.m_146926_(player.m_146909_());
            looker.m_146922_(player.m_146908_());
        }
        return UtilEntity.getLookingAtBlockPos((Entity)looker, (int)300);
    }

    private static boolean playerCanShoot(Player player) {
        return System.currentTimeMillis() - DSCClientInputs.getClientMountTime() > 500L && (!player.m_6117_() || player.m_21120_(player.m_7655_()).m_150930_(Items.f_42740_));
    }

    public static ActionInputHolder.Button registerButton(String id, String defaultKey) {
        ActionInputHolder.Button holder = new ActionInputHolder.Button(id, new ActionInput.DSCKeyButton(defaultKey));
        buttons.put(id, holder);
        return holder;
    }

    public static ActionInputHolder.Axis registerAxis(String id, String defaultNegKey, String defaultPosKey) {
        ActionInputHolder.Axis holder = new ActionInputHolder.Axis(id, new ActionInput.DSCKeyAxis(defaultNegKey, defaultPosKey));
        axes.put(id, holder);
        return holder;
    }

    public static int getNumButtons() {
        return buttons.size();
    }

    public static int getNumAxes() {
        return axes.size();
    }

    public static int getNumActions() {
        return ClientInputManager.getNumButtons() + ClientInputManager.getNumAxes();
    }

    public static Collection<ActionInputHolder.Button> getButtons() {
        return buttons.values();
    }

    public static Collection<ActionInputHolder.Axis> getAxes() {
        return axes.values();
    }

    public static void saveKeyBinds() {
        JsonObject json = new JsonObject();
        buttons.forEach((id, action) -> json.add(id, (JsonElement)action.write()));
        axes.forEach((id, action) -> json.add(id, (JsonElement)action.write()));
        UtilPrint.printJsonClientDirectory("dscombat/config/action_key_binds.json", json);
    }

    public static void loadKeyBinds() {
        JsonObject json = UtilPrint.readJsonClientDirectory("dscombat/config/action_key_binds.json");
        buttons.forEach((id, action) -> {
            JsonObject data = UtilParse.getJsonSafe((JsonObject)json, (String)id);
            String type = UtilParse.getStringSafe((JsonObject)data, (String)"type", (String)"");
            if (!type.equals("button")) {
                return;
            }
            action.read(data);
        });
        axes.forEach((id, action) -> {
            JsonObject data = UtilParse.getJsonSafe((JsonObject)json, (String)id);
            String type = UtilParse.getStringSafe((JsonObject)data, (String)"type", (String)"");
            if (!type.equals("axis")) {
                return;
            }
            action.read(data);
        });
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static double getMouseYVelocity(Minecraft mc) {
        return ClientInputManagerImpl.getMouseYVelocity(mc);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static double getMouseXVelocity(Minecraft mc) {
        return ClientInputManagerImpl.getMouseXVelocity(mc);
    }
}

