/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.client.model.obj.ObjTurretModel;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class MLRSModel
extends ObjTurretModel<EntityTurret> {
    public static final ResourceLocation DESERT_TEXTURE = new ResourceLocation("dscombat:textures/entity/turret/mlrs1.png");
    public static final ResourceLocation WOODLAND_TEXTURE = new ResourceLocation("dscombat:textures/entity/turret/mlrs2.png");

    public MLRSModel() {
        super("mlrs", true, new String[0]);
    }

    protected void addComponentTransforms(Map<String, Mat4f> transforms, EntityTurret entity, float partialTicks) {
        float xrothead = entity.m_5686_(partialTicks);
        Mat4f xrothead_mat = UtilAngles.pivotPixelsRotX((float)0.0f, (float)8.0f, (float)22.0f, (float)(-xrothead));
        transforms.put("RocketLauncher", xrothead_mat);
        super.addComponentTransforms(transforms, (Entity)entity, partialTicks);
    }

    public boolean globalRotateX() {
        return false;
    }

    protected Function<ResourceLocation, RenderType> getTextureRenderTypeLookup(EntityTurret entity) {
        return texture -> {
            EntityVehicle vehicle = entity.getParentVehicle();
            if (vehicle == null) {
                return RenderType.m_110473_((ResourceLocation)texture);
            }
            if (((VehicleStats)vehicle.getStats()).getId().equals("eric_truck")) {
                if (vehicle.textureManager.getBaseTextureIndex() == 1) {
                    return RenderType.m_110473_((ResourceLocation)DESERT_TEXTURE);
                }
                if (vehicle.textureManager.getBaseTextureIndex() == 2) {
                    return RenderType.m_110473_((ResourceLocation)WOODLAND_TEXTURE);
                }
            }
            return RenderType.m_110473_((ResourceLocation)texture);
        };
    }

    @Override
    protected void rotate(EntityTurret entity, float partialTicks, PoseStack poseStack) {
        super.rotate(entity, partialTicks, poseStack);
        poseStack.m_252781_(Vec3f.YP.rotationDegrees(180.0f).convert());
    }
}

