/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.client.overlay.components.VehicleControlOverlay;
import com.onewhohears.dscombat.entity.vehicle.EntityPlane;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class PlaneDataOverlay
extends VehicleOverlayComponent {
    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (PlaneDataOverlay.defaultRenderConditions()) {
            return false;
        }
        if (!(PlaneDataOverlay.getPlayerRootVehicle() instanceof EntityPlane)) {
            return false;
        }
        return !DSCClientInputs.isCameraLockedForward();
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityPlane plane = (EntityPlane)PlaneDataOverlay.getPlayerRootVehicle();
        assert (plane != null);
        int color = 65280;
        if (plane.isStalling()) {
            color = 0xFF0000;
        } else if (plane.isAboutToStall()) {
            color = 0xFFFF00;
        }
        graphics.m_280488_(FONT, String.format("AOA: %3.1f", Float.valueOf(plane.getAOA())), screenWidth - 60 - 1, screenHeight - 60 - VehicleControlOverlay.PEDAL_HEIGHT - 40 - 3 - 50, color);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_data";
    }
}

