/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PosRangeOverlay
extends VehicleOverlayComponent {
    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (DSCClientInputs.getTargetMode() == DSCClientInputs.TargetMode.LOOK) {
            return false;
        }
        if (PosRangeOverlay.defaultRenderConditions()) {
            return false;
        }
        Entity entity = PosRangeOverlay.getPlayerRootVehicle();
        if (!(entity instanceof EntityVehicle)) {
            return false;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        if (data == null) {
            return false;
        }
        return ((WeaponStats)data.getStats()).isPosGuided();
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        int color;
        Entity entity = PosRangeOverlay.getPlayerRootVehicle();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        assert (data != null);
        double range = ((WeaponStats)data.getStats()).getMobTurretRange();
        Vec3 pos = Config.CLIENT.getTargetPos();
        int dist = (int)pos.m_82554_(vehicle.m_20182_());
        int alt = UtilEntity.getDistFromSeaLevel((double)pos.f_82480_, (Level)vehicle.getWorld());
        String text = dist + " | " + alt;
        if ((double)dist <= range) {
            color = 65280;
            text = text + " | O";
        } else {
            color = 0xFF0000;
            text = text + " | X";
        }
        graphics.m_280137_(FONT, text, screenWidth / 2, screenHeight / 2 - 20, color);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_pos_range";
    }
}

