/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class VehicleWeaponsOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation WEAPON_TABS = new ResourceLocation("dscombat", "textures/ui/weapon_icons/weapon_tab.png");
    public static final ResourceLocation SELECTOR = new ResourceLocation("dscombat", "textures/ui/weapon_icons/selection_box.png");
    public static final byte TAB_WIDTH = 93;
    public static final byte TAB_HEIGHT = 24;
    public static final float[] FRAMES = new float[]{0.0f, 5.0f, 10.0f, 13.0f, 16.0f, 18.0f, 20.0f, 22.0f, 23.0f};
    public static final int[] SPACINGS = new int[]{24, 21, 18, 12, 0};
    public static final Component SAFETY = UtilMCText.translatable((String)"ui.dscombat.no_weapon");
    protected boolean weaponChangeState;
    protected boolean weaponChangeQueued;
    protected int weaponChangeCountdown;
    protected int selectedWeapon;
    protected float frame;
    protected int superFrame;

    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleWeaponsOverlay.defaultRenderConditions()) {
            return false;
        }
        return VehicleWeaponsOverlay.getPlayerVehicle() instanceof EntityRidablePart;
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityRidablePart seat = (EntityRidablePart)VehicleWeaponsOverlay.getPlayerVehicle();
        assert (seat != null);
        double yPlacement = screenHeight - 24 - 13;
        int blitPosition = 1;
        if (seat.isTurret()) {
            VehicleWeaponsOverlay.drawFinishedTab(graphics, ((EntityTurret)seat).getWeaponData(), yPlacement, blitPosition);
            return;
        }
        if (!seat.canPassengerShootParentWeapon()) {
            return;
        }
        EntityVehicle vehicle = seat.getParentVehicle();
        if (vehicle == null) {
            return;
        }
        List<WeaponInstance<?>> weapons = vehicle.weaponSystem.getWeapons();
        WeaponInstance<?> selectedWeapon = vehicle.weaponSystem.getSelected();
        int selectedIndex = vehicle.weaponSystem.getSelectedIndex();
        if (weapons == null || weapons.isEmpty()) {
            return;
        }
        if (selectedWeapon == null) {
            return;
        }
        if (selectedIndex != this.selectedWeapon) {
            this.enableWeaponChangeState();
        }
        this.selectedWeapon = selectedIndex;
        if (this.weaponChangeCountdown <= 0) {
            this.weaponChangeState = false;
        }
        if (!this.weaponChangeState) {
            VehicleWeaponsOverlay.drawFinishedTab(graphics, selectedWeapon, yPlacement, blitPosition);
        } else {
            int weaponTabsToRender = Math.min(weapons.size(), 5);
            for (int i = 0; i < weaponTabsToRender; ++i) {
                int shiftedIndex = selectedIndex - i;
                if (shiftedIndex < 0) {
                    shiftedIndex = (shiftedIndex % weapons.size() + weapons.size()) % weapons.size();
                }
                int newYPos = (int)(yPlacement - (double)(24 * i));
                WeaponInstance<?> weaponAt = weapons.get(shiftedIndex);
                VehicleWeaponsOverlay.drawTab(graphics, 13.0, newYPos, blitPosition, 0, false);
                VehicleWeaponsOverlay.drawWeapon(graphics, weaponAt, 13.0, newYPos, blitPosition + 1, 0, false, false, false);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, (float)(blitPosition + 3));
                if (!((WeaponStats)weaponAt.getStats()).isNoWeapon()) {
                    graphics.m_280488_(FONT, weaponAt.getCurrentAmmo() + "/" + weaponAt.getMaxAmmo(), 16, newYPos + 14, 0xE6E600);
                } else {
                    graphics.m_280430_(FONT, SAFETY, 16, newYPos + 14, 0xFF5555);
                }
                graphics.m_280430_(FONT, (Component)((WeaponStats)weaponAt.getStats()).getDisplayNameComponent(), 16, newYPos + 4, 0xFFFFFF);
                graphics.m_280168_().m_85849_();
            }
            VehicleWeaponsOverlay.renderSelectionBox(graphics, 13.0, yPlacement, blitPosition + 2);
            --this.weaponChangeCountdown;
        }
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_weapons";
    }

    public void queueWeaponChange() {
        this.weaponChangeQueued = true;
    }

    public void enableWeaponChangeState() {
        this.weaponChangeCountdown = 200;
        this.weaponChangeState = true;
        VehicleWeaponsOverlay.getPlayer().m_216990_((SoundEvent)SoundEvents.f_12490_.m_203334_());
    }

    protected static void drawFinishedTab(GuiGraphics graphics, WeaponInstance<?> selectedWeapon, double yPlacement, int blitPosition) {
        if (selectedWeapon == null) {
            return;
        }
        VehicleWeaponsOverlay.drawWeaponName(graphics, (Component)((WeaponStats)selectedWeapon.getStats()).getDisplayNameComponent(), 13.0, yPlacement, blitPosition - 2);
        VehicleWeaponsOverlay.drawTab(graphics, 13.0, yPlacement, blitPosition, 0, false);
        VehicleWeaponsOverlay.drawWeapon(graphics, selectedWeapon, 13.0, yPlacement, blitPosition + 1, 0, false, false, false);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, (float)(blitPosition + 2));
        if (!((WeaponStats)selectedWeapon.getStats()).isNoWeapon()) {
            graphics.m_280488_(FONT, selectedWeapon.getCurrentAmmo() + "/" + selectedWeapon.getMaxAmmo(), 16, (int)(yPlacement + 14.0), 0xE6E600);
        }
        graphics.m_280488_(FONT, ((WeaponStats)selectedWeapon.getStats()).getWeaponTypeCode(), 16, (int)yPlacement + 4, 0xE6E600);
        graphics.m_280168_().m_85849_();
    }

    protected static void drawTab(GuiGraphics graphics, double x, double y, int blitOffset, int frame, boolean scrollsUpward) {
        if (frame < 0 || frame > VehicleWeaponsOverlay.getMaxFrames() - 1) {
            throw new IllegalArgumentException("There are only " + VehicleWeaponsOverlay.getMaxFrames() + " frames!");
        }
        float sign = scrollsUpward ? -1.0f : 1.0f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(x, y, (double)blitOffset);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WEAPON_TABS);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.m_280163_(WEAPON_TABS, 0, 0, 0.0f, sign * FRAMES[frame], 93, 24, 93, 24);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_85849_();
    }

    protected static void drawWeapon(GuiGraphics graphics, WeaponInstance<?> weapon, double x, double y, int blitOffset, int frame, boolean scrollsUpward, boolean scrollsToBlank, boolean scrollsFromBlank) {
        if (frame < 0 || frame > VehicleWeaponsOverlay.getMaxFrames() - 1) {
            throw new IllegalArgumentException("There are only " + VehicleWeaponsOverlay.getMaxFrames() + " frames!");
        }
        if (scrollsToBlank && scrollsFromBlank) {
            throw new IllegalArgumentException("Tabs may not scroll to and from blank!");
        }
        if (weapon == null) {
            throw new NullPointerException("Passed weapon is null!");
        }
        int frameValue = (int)FRAMES[frame];
        ResourceLocation rl = ((WeaponStats)weapon.getStats()).getWeaponIcon();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)rl);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.m_280168_().m_85836_();
        if (scrollsUpward) {
            graphics.m_280168_().m_85837_(x, y + (double)frameValue, (double)blitOffset);
            if (scrollsFromBlank) {
                VehicleWeaponsOverlay.blitWithoutTop(graphics, 24 - frameValue, rl);
            }
            if (scrollsToBlank) {
                VehicleWeaponsOverlay.blitWithoutBottom(graphics, frameValue, rl);
            }
        } else {
            graphics.m_280168_().m_85837_(x, y - (double)frameValue, (double)blitOffset);
            if (scrollsFromBlank) {
                VehicleWeaponsOverlay.blitWithoutBottom(graphics, 24 - frameValue, rl);
            }
            if (scrollsToBlank) {
                VehicleWeaponsOverlay.blitWithoutTop(graphics, frameValue, rl);
            }
        }
        if (!scrollsFromBlank && !scrollsToBlank) {
            VehicleWeaponsOverlay.blitNormal(graphics, rl);
        }
        graphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    protected static void drawWeaponName(GuiGraphics graphics, Component name, double x, double y, int blitOffset) {
        graphics.m_280168_().m_85836_();
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        int nameWidth = FONT.m_92852_((FormattedText)name);
        Objects.requireNonNull(FONT);
        int nameHeight = 9;
        int blitOffsetUnder = blitOffset - 1;
        int xPosInitial = (int)x + 1;
        int xPosFinal = xPosInitial + nameWidth + 6;
        int yPosInitial = (int)y - 12;
        int yPosFinal = yPosInitial + nameHeight + 5;
        RenderType renderType = RenderType.m_286086_();
        graphics.m_285978_(renderType, xPosInitial - 1, yPosInitial, xPosInitial, yPosFinal + 1, blitOffsetUnder, -267386864, -267386864);
        graphics.m_285978_(renderType, xPosInitial, yPosInitial, xPosFinal, yPosFinal, blitOffsetUnder, -267386864, -267386864);
        graphics.m_285978_(renderType, xPosInitial, yPosInitial - 1, xPosFinal, yPosInitial, blitOffsetUnder, -267386864, -267386864);
        graphics.m_285978_(renderType, xPosInitial, yPosFinal, xPosFinal, yPosFinal + 1, blitOffsetUnder, -267386864, -267386864);
        graphics.m_285978_(renderType, xPosFinal, yPosInitial, xPosFinal + 1, yPosFinal, blitOffsetUnder, -267386864, -267386864);
        graphics.m_285978_(renderType, xPosInitial, yPosInitial + 1, xPosInitial + 1, yPosFinal - 1, blitOffsetUnder, 0x505000FF, 1344798847);
        graphics.m_285978_(renderType, xPosFinal - 1, yPosInitial + 1, xPosFinal, yPosFinal - 1, blitOffsetUnder, 0x505000FF, 1344798847);
        graphics.m_285978_(renderType, xPosInitial, yPosInitial, xPosFinal, yPosInitial + 1, blitOffsetUnder, 0x505000FF, 0x505000FF);
        graphics.m_285978_(renderType, xPosInitial, yPosFinal - 1, xPosFinal, yPosFinal, blitOffsetUnder, 1344798847, 1344798847);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        graphics.m_280168_().m_85837_(x, y - 11.0, (double)blitOffset);
        FONT.m_272077_(name, 4.0f, 2.0f, -1, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
        graphics.m_280168_().m_85849_();
    }

    protected static void renderSelectionBox(GuiGraphics graphics, double x, double y, int blitOffset) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SELECTOR);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(x, y, (double)blitOffset);
        graphics.m_280163_(SELECTOR, 0, 0, 0.0f, 0.0f, 93, 24, 93, 24);
        graphics.m_280168_().m_85849_();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    protected static void blitNormal(GuiGraphics graphics, ResourceLocation rl) {
        graphics.m_280163_(rl, 0, 0, 0.0f, 0.0f, 93, 24, 93, 24);
    }

    protected static void blitWithoutTop(GuiGraphics graphics, int trimPixels, ResourceLocation rl) {
        graphics.m_280163_(rl, 0, trimPixels, 0.0f, (float)trimPixels, 93, 24 - trimPixels, 93, 24);
    }

    protected static void blitWithoutBottom(GuiGraphics graphics, int trimPixels, ResourceLocation rl) {
        graphics.m_280163_(rl, 0, 0, 0.0f, 0.0f, 93, 24 - trimPixels, 93, 24);
    }

    protected static int getMaxFrames() {
        return FRAMES.length;
    }
}

