/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.onewhohears.dscombat.client.model.obj.ObjVehicleModel;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentData;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.util.UtilRender;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.util.math.Mat3f;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RendererWindTunnel
extends EntityRenderer<EntityWindTunnel> {
    public static final ResourceLocation ARROW_TXT = new ResourceLocation("dscombat", "textures/misc/arrow.png");
    private static final RenderType ARROW = RenderType.m_110497_((ResourceLocation)ARROW_TXT);
    private static final float ARROW_LENGTH_SCALE = 10.0f;

    public RendererWindTunnel(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(@NotNull EntityWindTunnel entity, float yaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        if (entity.getSimulatedVehicle().getClientStatsHolder() == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 4.0f, 0.0f);
        this.drawGlobalAxis(partialTicks, poseStack, buffer, packedLight);
        if (!entity.getHideModel()) {
            ObjVehicleModel model = (ObjVehicleModel)((VehicleClientStats)entity.getSimulatedVehicle().getClientStatsHolder().get()).getModel();
            model.render((Entity)entity.getSimulatedVehicle(), poseStack, buffer, packedLight, partialTicks);
            ObjEntityModels.ModelOverrides overrides = model.getModelOverride();
            poseStack.m_252880_(-overrides.translate.x(), -overrides.translate.y(), -overrides.translate.z());
        } else {
            poseStack.m_252781_(entity.getQ().convert());
        }
        this.drawAccs(entity, partialTicks, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    private void drawAccs(@NotNull EntityWindTunnel entity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        EntityVehicle vehicle = entity.getSimulatedVehicle();
        QuaternionF q = vehicle.getQBySide();
        QuaternionF qi = vehicle.getQBySide();
        qi.conj();
        poseStack.m_252781_(qi.convert());
        float maxForceMag = (float)entity.weightAcc.m_82553_();
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.WHITE, maxForceMag, Vec3.f_82478_, entity.totalAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.BLACK, maxForceMag, Vec3.f_82478_, entity.weightAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.BLUE, maxForceMag, Vec3.f_82478_, entity.thrustAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.RED, maxForceMag, Vec3.f_82478_, entity.dragAcc);
        this.drawAcc(poseStack, buffer, packedLight, UtilRender.GREEN, maxForceMag, Vec3.f_82478_, entity.liftAcc);
        for (PhysicsComponentInstance<?> phy : vehicle.getPhysicsInstances()) {
            Vec3 pos = UtilAngles.rotateVector((Vec3)((PhysicsComponentData)phy.getData()).getPos(), (QuaternionF)q);
            this.drawAcc(poseStack, buffer, packedLight, UtilRender.YELLOW, maxForceMag, pos, vehicle.getAccFromForce(phy.getDragForce()));
            this.drawAcc(poseStack, buffer, packedLight, UtilRender.CYAN, maxForceMag, pos, vehicle.getAccFromForce(phy.getLiftForce()));
        }
        poseStack.m_85849_();
    }

    private void drawAcc(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int[] color, float maxForceMag, Vec3 pos, Vec3 force) {
        float mag = (float)force.m_82553_();
        Vec3 dir = mag < 0.001f ? force.m_82490_(1000.0).m_82541_() : force.m_82541_();
        this.drawAcc(poseStack, buffer, packedLight, color, pos, dir, mag / maxForceMag * 10.0f);
    }

    private void drawAcc(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int[] color, Vec3 pos, Vec3 dir, float mag) {
        poseStack.m_85836_();
        poseStack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        float y = UtilAngles.getYaw((Vec3)dir);
        float x = UtilAngles.getPitch((Vec3)dir);
        QuaternionF q1 = Vec3f.YN.rotationDegrees(y + 180.0f);
        q1.mul(Vec3f.XN.rotationDegrees(x - 90.0f));
        poseStack.m_252781_(q1.convert());
        poseStack.m_85837_(0.0, (double)(-mag) * 0.5, 0.0);
        poseStack.m_85841_(1.0f, mag, 1.0f);
        for (int i = 0; i < 4; ++i) {
            poseStack.m_252781_(Vec3f.YN.rotationDegrees((float)(90 * i)).convert());
            UtilRender.drawTextureCentered(ARROW, Mat4f.from((Matrix4f)poseStack.m_85850_().m_252922_()), buffer, packedLight, 0.0f, color);
        }
        poseStack.m_85849_();
    }

    private void drawGlobalAxis(float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        VertexConsumer buff = buffer.m_6299_(RenderType.m_110504_());
        Vec3f O = new Vec3f();
        Vec3f X = new Vec3f(8.0f, 0.0f, 0.0f);
        Vec3f Y = new Vec3f(0.0f, 8.0f, 0.0f);
        Vec3f Z = new Vec3f(0.0f, 0.0f, 8.0f);
        Mat4f m4 = Mat4f.from((Matrix4f)poseStack.m_85850_().m_252922_());
        Mat3f m3 = Mat3f.from((Matrix3f)poseStack.m_85850_().m_252943_());
        UtilRender.drawLine(O, X, buff, m4, m3, UtilRender.RED);
        UtilRender.drawLine(O, Y, buff, m4, m3, UtilRender.GREEN);
        UtilRender.drawLine(O, Z, buff, m4, m3, UtilRender.BLUE);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityWindTunnel entity) {
        return null;
    }
}

