/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VehicleJetesinScreen
extends VehicleSubScreen {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("dscombat", "textures/ui/background/vehicle_jetesin_screen.png");
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    private static final Style style = Style.f_131099_.m_178520_(34816);
    private List<PartSlot> slots = new ArrayList<PartSlot>();

    protected VehicleJetesinScreen() {
        super("screen.dscombat.vehicle_jetesin_screen", BG_TEXTURE, 240, 180, 256, 256);
    }

    @Override
    protected void m_7856_() {
        int xStart;
        this.vertical_widget_shift = 10;
        super.m_7856_();
        this.vertical_widget_shift = 34;
        float scale = 0.6666667f;
        int textHeight = (int)(10.0f * scale);
        int x = xStart = this.guiX + this.left_padding;
        int y = this.guiY + this.top_padding + this.vertical_widget_shift;
        int width = (this.image_width - this.left_padding - this.right_padding) / 3;
        this.slots = this.getVehicle().partsManager.getExternalParts();
        for (int i = 0; i < this.slots.size(); ++i) {
            PartSlot slot = this.slots.get(i);
            PartInstance<?> part = slot.getPartData();
            if (part == null) continue;
            Button jetesin = new Button(0, 0, width, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.drop"), button -> this.onJetesinButton(button, slot.getSlotId()), Supplier::get);
            jetesin.m_252865_(x);
            jetesin.m_253211_(y + textHeight);
            this.m_142416_((GuiEventListener)jetesin);
            if (i % 3 == 2) {
                y += textHeight + 20;
                x = xStart;
                continue;
            }
            x += width;
        }
    }

    @Override
    public void m_280273_(@NotNull GuiGraphics graphics) {
        int xStart;
        super.m_280273_(graphics);
        graphics.m_280168_().m_85836_();
        float scale = 0.6666667f;
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        int x = xStart = (int)((float)(this.guiX + this.left_padding) / scale) + 1;
        int y = (int)((float)(this.guiY + this.top_padding + this.vertical_widget_shift) / scale);
        int width = (int)((float)(this.image_width - this.left_padding - this.right_padding) / 3.0f / scale);
        for (int i = 0; i < this.slots.size(); ++i) {
            PartSlot slot = this.slots.get(i);
            PartInstance<?> part = slot.getPartData();
            if (part != null) {
                graphics.m_280430_(this.f_96547_, (Component)part.getItemName().m_6270_(style), x, y, 0xFFFFFF);
            }
            if (i % 3 == 2) {
                y += 40;
                x = xStart;
                continue;
            }
            x += width;
        }
        graphics.m_280168_().m_85849_();
    }

    private void onJetesinButton(Button button, String slotId) {
        VehicleJetesinScreen.sendSyncAction(new VehicleSyncAction.JetesinAction(slotId));
        button.f_93624_ = false;
    }
}

