/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.client.screen.widget.WeaponButton;
import com.onewhohears.dscombat.data.weapon.WeaponSystem;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VehicleWeaponScreen
extends VehicleSubScreen {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("dscombat", "textures/ui/background/vehicle_weapons_screen.png");
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    EditBox xPosBox;
    EditBox yPosBox;
    EditBox zPosBox;

    protected VehicleWeaponScreen() {
        super("screen.dscombat.vehicle_weapon_screen", BG_TEXTURE, 240, 180, 256, 256);
    }

    @Override
    protected void m_7856_() {
        this.vertical_widget_shift = 10;
        this.COLUMNS = 7;
        this.padding = 0;
        super.m_7856_();
        this.positionWidgetGrid((AbstractWidget)CycleButton.m_168894_(value -> UtilMCText.translatable((String)value.getTranslatable())).m_168961_((Object[])DSCClientInputs.TargetMode.values()).m_168948_((Object)DSCClientInputs.getTargetMode()).m_168936_(0, 0, 20, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.target_mode"), this.onTargetModeCycle()), this.ROWS, this.COLUMNS, 1, this.padding, 4);
        this.positionWidgetGrid((AbstractWidget)CycleButton.m_168916_((boolean)DSCClientInputs.isGimbalMode()).m_168936_(0, 0, 20, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.gimbal_mode"), this.onGimbalToggle()), this.ROWS, this.COLUMNS, 5, this.padding, 2);
        this.vertical_widget_shift = 48;
        this.xPosBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
        this.positionWidgetGrid((AbstractWidget)this.xPosBox, 9, 3, 0, 2);
        this.xPosBox.m_94144_("" + (int)Config.CLIENT.getTargetPos().m_7096_());
        this.xPosBox.m_94202_(0xFFFFFF);
        this.xPosBox.m_94151_(this.onTargetPosCoordChange(0));
        this.yPosBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
        this.positionWidgetGrid((AbstractWidget)this.yPosBox, 9, 3, 1, 2);
        this.yPosBox.m_94144_("" + (int)Config.CLIENT.getTargetPos().m_7098_());
        this.yPosBox.m_94202_(0xFFFFFF);
        this.yPosBox.m_94151_(this.onTargetPosCoordChange(1));
        this.zPosBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
        this.positionWidgetGrid((AbstractWidget)this.zPosBox, 9, 3, 2, 2);
        this.zPosBox.m_94144_("" + (int)Config.CLIENT.getTargetPos().m_7094_());
        this.zPosBox.m_94202_(0xFFFFFF);
        this.zPosBox.m_94151_(this.onTargetPosCoordChange(2));
        this.vertical_widget_shift = 72;
        WeaponSystem system = this.getVehicle().weaponSystem;
        List<WeaponInstance<?>> weapons = system.getWeapons();
        for (int i = 0; i < weapons.size(); ++i) {
            WeaponStats stats = (WeaponStats)weapons.get(i).getStats();
            this.positionWidgetGrid((AbstractWidget)new WeaponButton(0, 0, 20, 20, stats.getWeaponIcon(), this.onSelectWeapon(i), stats.getDisplayNameComponent(), system, i), 9, 3, i, 0, 1);
        }
    }

    private Button.OnPress onSelectWeapon(int weaponIndex) {
        return button -> this.getVehicle().weaponSystem.setSelected(weaponIndex);
    }

    private CycleButton.OnValueChange<DSCClientInputs.TargetMode> onTargetModeCycle() {
        return (button, value) -> DSCClientInputs.setTargetMode(value);
    }

    private Consumer<String> onTargetPosCoordChange(int axis) {
        return coord -> {
            try {
                double number = Double.parseDouble(coord);
                this.setTargetPos(axis, number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        };
    }

    private void setTargetPos(int axis, double number) {
        if (axis == 0) {
            Config.CLIENT.targetPosX.set((Object)number);
        } else if (axis == 1) {
            Config.CLIENT.targetPosY.set((Object)number);
        } else if (axis == 2) {
            Config.CLIENT.targetPosZ.set((Object)number);
        }
    }

    private CycleButton.OnValueChange<Boolean> onGimbalToggle() {
        return (button, value) -> DSCClientInputs.setGimbalMode(value);
    }

    @Override
    public void m_280273_(@NotNull GuiGraphics graphics) {
        super.m_280273_(graphics);
        if (DSCClientInputs.getTargetMode() == DSCClientInputs.TargetMode.COORDS) {
            graphics.m_280430_(this.f_96547_, (Component)UtilMCText.translatable((String)"info.dscombat.target_mode_pos"), this.guiX + this.left_padding, this.guiY + this.top_padding + 38, this.infoColor);
            if (this.xPosBox != null) {
                this.xPosBox.m_94194_(true);
            }
            if (this.yPosBox != null) {
                this.yPosBox.m_94194_(true);
            }
            if (this.zPosBox != null) {
                this.zPosBox.m_94194_(true);
            }
        } else {
            if (this.xPosBox != null) {
                this.xPosBox.m_94194_(false);
            }
            if (this.yPosBox != null) {
                this.yPosBox.m_94194_(false);
            }
            if (this.zPosBox != null) {
                this.zPosBox.m_94194_(false);
            }
        }
    }
}

