/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen.key_bind;

import com.onewhohears.dscombat.client.input.ActionInput;
import com.onewhohears.dscombat.client.input.ActionInputHolder;
import com.onewhohears.dscombat.client.input.ClientInputManager;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.client.screen.key_bind.VehicleEditAxisBindScreen;
import com.onewhohears.dscombat.client.screen.key_bind.VehicleEditButtonBindScreen;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public abstract class SelectBindScreen<H extends ActionInputHolder<A>, A extends ActionInput>
extends VehicleSubScreen {
    private static final String[] filteredNames = new String[]{"keyboard", "ducky one"};
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("dscombat", "textures/ui/background/vehicle_other_screen.png");
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    protected final int page;
    protected final H action;
    protected final boolean primary;

    public static boolean filterJoystick(String name) {
        String n = name.toLowerCase();
        for (String f : filteredNames) {
            if (!n.contains(f)) continue;
            return true;
        }
        return false;
    }

    public SelectBindScreen(int page, H action, boolean primary) {
        super(((ActionInputHolder)action).getNameString(), BG_TEXTURE, 240, 180, 256, 256);
        this.page = page;
        this.action = action;
        this.primary = primary;
    }

    @Override
    protected void m_7856_() {
        this.vertical_widget_shift = 10;
        super.m_7856_();
        this.positionWidgetGrid((AbstractWidget)new Button(0, 0, 20, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.save"), onPress -> {
            this.applyChanges();
            ClientInputManager.saveKeyBinds();
            Minecraft.m_91087_().m_91152_(this.getBackScreen());
        }, Supplier::get), this.ROWS, this.COLUMNS, 1, this.padding);
    }

    protected abstract A createNewInput();

    protected void applyChanges() {
        A input = this.createNewInput();
        if (this.primary) {
            ((ActionInputHolder)this.action).setPrimaryAction(input);
        } else {
            ((ActionInputHolder)this.action).setSecondaryAction(input);
        }
    }

    protected A getActionInput() {
        if (this.primary) {
            return ((ActionInputHolder)this.action).getPrimaryAction();
        }
        return ((ActionInputHolder)this.action).getSecondaryAction();
    }

    @Override
    public void m_280273_(@NotNull GuiGraphics graphics) {
        super.m_280273_(graphics);
        MutableComponent alt = this.primary ? UtilMCText.translatable((String)"ui.dscombat.primary") : UtilMCText.translatable((String)"ui.dscombat.secondary");
        graphics.m_280430_(this.f_96547_, (Component)alt, this.guiX + this.image_width - 60, this.guiY + this.top_padding, this.infoColor);
    }

    public static abstract class ButtonScreen
    extends SelectBindScreen<ActionInputHolder.Button, ActionInput.Button> {
        public ButtonScreen(int page, ActionInputHolder.Button action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected Screen getBackScreen() {
            return new VehicleEditButtonBindScreen(this.page, (ActionInputHolder.Button)this.action);
        }
    }

    public static abstract class AxisScreen
    extends SelectBindScreen<ActionInputHolder.Axis, ActionInput.Axis> {
        public AxisScreen(int page, ActionInputHolder.Axis action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected Screen getBackScreen() {
            return new VehicleEditAxisBindScreen(this.page, (ActionInputHolder.Axis)this.action);
        }
    }

    public static class DSCKeyAxis
    extends AxisScreen {
        private final boolean positive;
        private String key_mapping_id_negative = "unbound";
        private String key_mapping_id_positive = "unbound";

        public DSCKeyAxis(int page, ActionInputHolder.Axis action, boolean primary, boolean positive) {
            super(page, action, primary);
            this.positive = positive;
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            ActionInput.Axis input = (ActionInput.Axis)this.getActionInput();
            if (input instanceof ActionInput.DSCKeyAxis) {
                ActionInput.DSCKeyAxis data = (ActionInput.DSCKeyAxis)input;
                this.key_mapping_id_negative = data.key_mapping_id_negative;
                this.key_mapping_id_positive = data.key_mapping_id_positive;
            }
            EditBox keyIDBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)keyIDBox, this.ROWS, this.COLUMNS, 2, 2);
            if (this.positive) {
                keyIDBox.m_94144_(this.key_mapping_id_positive);
            } else {
                keyIDBox.m_94144_(this.key_mapping_id_negative);
            }
            keyIDBox.m_94202_(0xFFFFFF);
            keyIDBox.m_94151_(string -> {
                if (DSCKeys.hasKey(string)) {
                    if (this.positive) {
                        this.key_mapping_id_positive = string;
                    } else {
                        this.key_mapping_id_negative = string;
                    }
                    keyIDBox.m_94202_(65280);
                } else {
                    keyIDBox.m_94202_(0xFF0000);
                }
            });
        }

        @Override
        public void m_280273_(@NotNull GuiGraphics graphics) {
            super.m_280273_(graphics);
            float scale = 0.7f;
            float startY = (float)(this.guiY + this.top_padding + 60) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            float width2 = (float)this.image_width / 2.0f / scale;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(scale, scale, scale);
            String test = this.positive ? this.key_mapping_id_positive : this.key_mapping_id_negative;
            int i = 0;
            Set<String> keys = DSCKeys.getKeyIds();
            for (String key : keys) {
                int color = this.infoColor;
                if (key.equals(test)) {
                    color = 65280;
                }
                graphics.m_280488_(this.f_96547_, key, (int)(startX + width2 * (float)(i % 2)), (int)(startY + (float)(Mth.m_14143_((float)((float)i / 2.0f)) * 10)), color);
                ++i;
            }
            graphics.m_280168_().m_85849_();
        }

        @Override
        protected ActionInput.Axis createNewInput() {
            return new ActionInput.DSCKeyAxis(this.key_mapping_id_negative, this.key_mapping_id_positive);
        }
    }

    public static class ControllerJoystickAxis
    extends AxisScreen {
        private int joystick_id;
        private int axis_id;
        private float dead_zone = 0.1f;
        private boolean invert;

        public ControllerJoystickAxis(int page, ActionInputHolder.Axis action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.vertical_widget_shift = 18;
            ActionInput.Axis input = (ActionInput.Axis)this.getActionInput();
            if (input instanceof ActionInput.ControllerAxis) {
                ActionInput.ControllerAxis data = (ActionInput.ControllerAxis)input;
                this.joystick_id = data.joystick_id;
                this.axis_id = data.axis_id;
                this.dead_zone = data.dead_zone;
                this.invert = data.invert;
            }
            EditBox joystickIDBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)joystickIDBox, this.ROWS, 4, 4, 2);
            joystickIDBox.m_94144_("" + this.joystick_id);
            joystickIDBox.m_94202_(0xFFFFFF);
            joystickIDBox.m_94151_(string -> {
                try {
                    this.joystick_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            EditBox axisIDBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)axisIDBox, this.ROWS, 4, 5, 2);
            axisIDBox.m_94144_("" + this.axis_id);
            axisIDBox.m_94202_(0xFFFFFF);
            axisIDBox.m_94151_(string -> {
                try {
                    this.axis_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            EditBox deadZoneBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)deadZoneBox, this.ROWS, 4, 6, 2);
            deadZoneBox.m_94144_("" + this.dead_zone);
            deadZoneBox.m_94202_(0xFFFFFF);
            deadZoneBox.m_94151_(string -> {
                try {
                    this.dead_zone = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.positionWidgetGrid((AbstractWidget)new Checkbox(0, 0, 20, 20, (Component)UtilMCText.literal((String)""), this.invert){

                public void m_5691_() {
                    super.m_5691_();
                    invert = !invert;
                }
            }, this.ROWS, 4, 7, 2);
        }

        @Override
        public void m_280273_(@NotNull GuiGraphics graphics) {
            super.m_280273_(graphics);
            int ix = this.guiX + this.left_padding;
            int iy = this.guiY + this.top_padding + 36;
            int w4 = 60;
            graphics.m_280488_(this.f_96547_, "Joystick ID", ix, iy, this.infoColor);
            graphics.m_280488_(this.f_96547_, "Axis ID", ix + w4 - 1, iy, this.infoColor);
            graphics.m_280488_(this.f_96547_, "Dead Zone", ix + w4 * 2 - 2, iy, this.infoColor);
            graphics.m_280488_(this.f_96547_, "Invert", ix + w4 * 3 - 3, iy, this.infoColor);
            float scale = 0.8f;
            float startY = (float)(this.guiY + this.top_padding + 70) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(scale, scale, scale);
            int k = 0;
            for (int j = 0; j < 16; ++j) {
                FloatBuffer axes;
                if (!GLFW.glfwJoystickPresent((int)j)) continue;
                String name = GLFW.glfwGetJoystickName((int)j);
                if (name == null) {
                    name = "N/A";
                }
                if (ControllerJoystickAxis.filterJoystick(name) || (axes = GLFW.glfwGetJoystickAxes((int)j)) == null) continue;
                for (int a = 0; a < axes.limit(); ++a) {
                    float value = axes.get(a);
                    if (Mth.m_14154_((float)value) < 0.1f) continue;
                    String text = name + " | ID:" + j + " | Axis:" + a + " | " + value;
                    graphics.m_280488_(this.f_96547_, text, (int)startX, (int)startY + k * 10, this.infoColor);
                    ++k;
                }
            }
            graphics.m_280168_().m_85849_();
        }

        @Override
        protected ActionInput.Axis createNewInput() {
            return new ActionInput.ControllerAxis(this.joystick_id, this.axis_id, this.dead_zone, this.invert);
        }
    }

    public static class ControllerButtonAxis
    extends AxisScreen {
        private int joystick_id;
        private int positive_button_id;
        private int negative_button_id;

        public ControllerButtonAxis(int page, ActionInputHolder.Axis action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.vertical_widget_shift = 18;
            ActionInput.Axis input = (ActionInput.Axis)this.getActionInput();
            if (input instanceof ActionInput.ControllerButtonAxis) {
                ActionInput.ControllerButtonAxis data = (ActionInput.ControllerButtonAxis)input;
                this.joystick_id = data.joystick_id;
                this.positive_button_id = data.positive_button_id;
                this.negative_button_id = data.negative_button_id;
            }
            EditBox joystickIDBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)joystickIDBox, this.ROWS, 3, 3, 2);
            joystickIDBox.m_94144_("" + this.joystick_id);
            joystickIDBox.m_94202_(0xFFFFFF);
            joystickIDBox.m_94151_(string -> {
                try {
                    this.joystick_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            EditBox positiveButtonBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)positiveButtonBox, this.ROWS, 3, 4, 2);
            positiveButtonBox.m_94144_("" + this.positive_button_id);
            positiveButtonBox.m_94202_(0xFFFFFF);
            positiveButtonBox.m_94151_(string -> {
                try {
                    this.positive_button_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            EditBox negativeButtonBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)negativeButtonBox, this.ROWS, 3, 5, 2);
            negativeButtonBox.m_94144_("" + this.negative_button_id);
            negativeButtonBox.m_94202_(0xFFFFFF);
            negativeButtonBox.m_94151_(string -> {
                try {
                    this.negative_button_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }

        @Override
        public void m_280273_(@NotNull GuiGraphics graphics) {
            super.m_280273_(graphics);
            int ix = this.guiX + this.left_padding;
            int iy = this.guiY + this.top_padding + 36;
            int w3 = 80;
            graphics.m_280488_(this.f_96547_, "Joystick ID", ix, iy, this.infoColor);
            graphics.m_280488_(this.f_96547_, "Button +", ix + w3 - 1, iy, this.infoColor);
            graphics.m_280488_(this.f_96547_, "Button -", ix + w3 * 2 - 2, iy, this.infoColor);
            float scale = 0.8f;
            float startY = (float)(this.guiY + this.top_padding + 70) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(scale, scale, scale);
            int k = 0;
            for (int j = 0; j < 16; ++j) {
                ByteBuffer buttons;
                if (!GLFW.glfwJoystickPresent((int)j)) continue;
                String name = GLFW.glfwGetJoystickName((int)j);
                if (name == null) {
                    name = "N/A";
                }
                if (ControllerButtonAxis.filterJoystick(name) || (buttons = GLFW.glfwGetJoystickButtons((int)j)) == null) continue;
                for (int b = 0; b < buttons.limit(); ++b) {
                    byte value = buttons.get(b);
                    if (value == 0) continue;
                    String text = name + " | ID:" + j + " | Button:" + b + " | ON";
                    graphics.m_280488_(this.f_96547_, text, (int)startX, (int)startY + k * 10, this.infoColor);
                    ++k;
                }
            }
            graphics.m_280168_().m_85849_();
        }

        @Override
        protected ActionInput.Axis createNewInput() {
            return new ActionInput.ControllerButtonAxis(this.joystick_id, this.positive_button_id, this.negative_button_id);
        }
    }

    public static class DSCKeyButton
    extends ButtonScreen {
        private String key_mapping_id = "unbound";

        public DSCKeyButton(int page, ActionInputHolder.Button action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            ActionInput.Button input = (ActionInput.Button)this.getActionInput();
            if (input instanceof ActionInput.DSCKeyButton) {
                ActionInput.DSCKeyButton data = (ActionInput.DSCKeyButton)input;
                this.key_mapping_id = data.key_mapping_id;
            }
            EditBox keyIDBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)keyIDBox, this.ROWS, this.COLUMNS, 2, 2);
            keyIDBox.m_94144_(this.key_mapping_id);
            keyIDBox.m_94202_(0xFFFFFF);
            keyIDBox.m_94151_(string -> {
                if (DSCKeys.hasKey(string)) {
                    this.key_mapping_id = string;
                    keyIDBox.m_94202_(65280);
                } else {
                    keyIDBox.m_94202_(0xFF0000);
                }
            });
        }

        @Override
        public void m_280273_(@NotNull GuiGraphics graphics) {
            super.m_280273_(graphics);
            float scale = 0.7f;
            float startY = (float)(this.guiY + this.top_padding + 60) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            float width2 = (float)this.image_width / 2.0f / scale;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(scale, scale, scale);
            int i = 0;
            Set<String> keys = DSCKeys.getKeyIds();
            for (String key : keys) {
                int color = this.infoColor;
                if (key.equals(this.key_mapping_id)) {
                    color = 65280;
                }
                graphics.m_280488_(this.f_96547_, key, (int)(startX + width2 * (float)(i % 2)), (int)(startY + (float)(Mth.m_14143_((float)((float)i / 2.0f)) * 10)), color);
                ++i;
            }
            graphics.m_280168_().m_85849_();
        }

        @Override
        protected ActionInput.Button createNewInput() {
            return new ActionInput.DSCKeyButton(this.key_mapping_id);
        }
    }

    public static class ControllerButton
    extends ButtonScreen {
        private int joystick_id;
        private int button_id;

        public ControllerButton(int page, ActionInputHolder.Button action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.vertical_widget_shift = 18;
            ActionInput.Button input = (ActionInput.Button)this.getActionInput();
            if (input instanceof ActionInput.ControllerButton) {
                ActionInput.ControllerButton data = (ActionInput.ControllerButton)input;
                this.joystick_id = data.joystick_id;
                this.button_id = data.button_id;
            }
            EditBox joystickIDBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)joystickIDBox, this.ROWS, 2, 2, 2);
            joystickIDBox.m_94144_("" + this.joystick_id);
            joystickIDBox.m_94202_(0xFFFFFF);
            joystickIDBox.m_94151_(string -> {
                try {
                    this.joystick_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            EditBox buttonBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)buttonBox, this.ROWS, 2, 3, 2);
            buttonBox.m_94144_("" + this.button_id);
            buttonBox.m_94202_(0xFFFFFF);
            buttonBox.m_94151_(string -> {
                try {
                    this.button_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }

        @Override
        public void m_280273_(@NotNull GuiGraphics graphics) {
            super.m_280273_(graphics);
            int ix = this.guiX + this.left_padding;
            int iy = this.guiY + this.top_padding + 36;
            int w2 = 120;
            graphics.m_280488_(this.f_96547_, "Joystick ID", ix, iy, this.infoColor);
            graphics.m_280488_(this.f_96547_, "Button ID", ix + w2 - 1, iy, this.infoColor);
            float scale = 0.8f;
            float startY = (float)(this.guiY + this.top_padding + 70) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(scale, scale, scale);
            int k = 0;
            for (int j = 0; j < 16; ++j) {
                ByteBuffer buttons;
                if (!GLFW.glfwJoystickPresent((int)j)) continue;
                String name = GLFW.glfwGetJoystickName((int)j);
                if (name == null) {
                    name = "N/A";
                }
                if (ControllerButton.filterJoystick(name) || (buttons = GLFW.glfwGetJoystickButtons((int)j)) == null) continue;
                for (int b = 0; b < buttons.limit(); ++b) {
                    byte value = buttons.get(b);
                    if (value == 0) continue;
                    String text = name + " | ID:" + j + " | Button:" + b + " | ON";
                    graphics.m_280488_(this.f_96547_, text, (int)startX, (int)startY + k * 10, this.infoColor);
                    ++k;
                }
            }
            graphics.m_280168_().m_85849_();
        }

        @Override
        protected ActionInput.Button createNewInput() {
            return new ActionInput.ControllerButton(this.joystick_id, this.button_id);
        }
    }

    public static class ControllerAxisButton
    extends ButtonScreen {
        private int joystick_id;
        private int axis_id;
        private float dead_zone = 0.1f;
        private boolean positive = true;

        public ControllerAxisButton(int page, ActionInputHolder.Button action, boolean primary) {
            super(page, action, primary);
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.vertical_widget_shift = 18;
            ActionInput.Button input = (ActionInput.Button)this.getActionInput();
            if (input instanceof ActionInput.ControllerAxisButton) {
                ActionInput.ControllerAxisButton data = (ActionInput.ControllerAxisButton)input;
                this.joystick_id = data.joystick_id;
                this.axis_id = data.axis_id;
                this.dead_zone = data.dead_zone;
                this.positive = data.positive;
            }
            EditBox joystickIDBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)joystickIDBox, this.ROWS, 4, 4, 2);
            joystickIDBox.m_94144_("" + this.joystick_id);
            joystickIDBox.m_94202_(0xFFFFFF);
            joystickIDBox.m_94151_(string -> {
                try {
                    this.joystick_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            EditBox axisIDBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)axisIDBox, this.ROWS, 4, 5, 2);
            axisIDBox.m_94144_("" + this.axis_id);
            axisIDBox.m_94202_(0xFFFFFF);
            axisIDBox.m_94151_(string -> {
                try {
                    this.axis_id = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            EditBox deadZoneBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
            this.positionWidgetGrid((AbstractWidget)deadZoneBox, this.ROWS, 4, 6, 2);
            deadZoneBox.m_94144_("" + this.dead_zone);
            deadZoneBox.m_94202_(0xFFFFFF);
            deadZoneBox.m_94151_(string -> {
                try {
                    this.dead_zone = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.positionWidgetGrid((AbstractWidget)new Checkbox(0, 0, 20, 20, (Component)UtilMCText.literal((String)""), this.positive){

                public void m_5691_() {
                    super.m_5691_();
                    positive = !positive;
                }
            }, this.ROWS, 4, 7, 2);
        }

        @Override
        public void m_280273_(@NotNull GuiGraphics graphics) {
            super.m_280273_(graphics);
            int ix = this.guiX + this.left_padding;
            int iy = this.guiY + this.top_padding + 36;
            int w4 = 60;
            graphics.m_280488_(this.f_96547_, "Joystick ID", ix, iy, this.infoColor);
            graphics.m_280488_(this.f_96547_, "Axis ID", ix + w4 - 1, iy, this.infoColor);
            graphics.m_280488_(this.f_96547_, "Dead Zone", ix + w4 * 2 - 2, iy, this.infoColor);
            graphics.m_280488_(this.f_96547_, "Positive", ix + w4 * 3 - 3, iy, this.infoColor);
            float scale = 0.8f;
            float startY = (float)(this.guiY + this.top_padding + 70) / scale;
            float startX = (float)(this.guiX + this.left_padding) / scale;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(scale, scale, scale);
            int k = 0;
            for (int j = 0; j < 16; ++j) {
                FloatBuffer axes;
                if (!GLFW.glfwJoystickPresent((int)j)) continue;
                String name = GLFW.glfwGetJoystickName((int)j);
                if (name == null) {
                    name = "N/A";
                }
                if (ControllerAxisButton.filterJoystick(name) || (axes = GLFW.glfwGetJoystickAxes((int)j)) == null) continue;
                for (int a = 0; a < axes.limit(); ++a) {
                    float value = axes.get(a);
                    if (Mth.m_14154_((float)value) < 0.1f) continue;
                    String text = name + " | ID:" + j + " | Axis:" + a + " | " + value;
                    graphics.m_280488_(this.f_96547_, text, (int)startX, (int)startY + k * 10, this.infoColor);
                    ++k;
                }
            }
            graphics.m_280168_().m_85849_();
        }

        @Override
        protected ActionInput.Button createNewInput() {
            return new ActionInput.ControllerAxisButton(this.joystick_id, this.axis_id, this.dead_zone, this.positive);
        }
    }
}

