/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.data.vehicle.VehicleTextureManager;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.slf4j.Logger;

public class VehicleDynamicTextures {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ResourceLocation createVehicleDynamicTexture(EntityVehicle vehicle) {
        NativeImage baseImage;
        ResourceLocation baseTexLoc = vehicle.textureManager.getBaseTexture();
        if (vehicle.textureManager.isAllLayersDisabled()) {
            return baseTexLoc;
        }
        Minecraft m = Minecraft.m_91087_();
        try {
            InputStream stream = ((Resource)m.m_91098_().m_213713_(baseTexLoc).get()).m_215507_();
            baseImage = NativeImage.m_85058_((InputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return baseTexLoc;
        }
        DynamicTexture dynText = new DynamicTexture(baseImage);
        VehicleTextureManager.TextureLayer[] layers = vehicle.textureManager.getTextureLayers();
        for (int i = 0; i < layers.length; ++i) {
            NativeImage layerImage;
            if (!layers[i].canRender()) continue;
            try {
                InputStream stream = ((Resource)m.m_91098_().m_213713_(layers[i].getTexture()).get()).m_215507_();
                layerImage = NativeImage.m_85058_((InputStream)stream);
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            if (dynText.m_117991_().m_84982_() != layerImage.m_84982_() || dynText.m_117991_().m_85084_() != layerImage.m_85084_()) {
                LOGGER.error(String.valueOf(baseTexLoc) + " and " + String.valueOf(layers[i].getTexture()) + " do not have the same dimensions! This layer will not render!");
                continue;
            }
            float blend = VehicleDynamicTextures.calcBlend(layers[i]);
            for (int x = 0; x < layerImage.m_84982_(); ++x) {
                for (int y = 0; y < layerImage.m_85084_(); ++y) {
                    int textureColor = layerImage.m_84985_(x, y);
                    if (VehicleDynamicTextures.getA(textureColor) == 0) continue;
                    dynText.m_117991_().m_84988_(x, y, VehicleDynamicTextures.blendColors(textureColor, layers[i], blend));
                }
            }
        }
        dynText.m_117985_();
        ResourceLocation textLoc = new ResourceLocation("dscombat", "vehicle_layers_" + vehicle.m_19879_());
        m.m_91097_().m_118495_(textLoc, (AbstractTexture)dynText);
        return textLoc;
    }

    private static int blendColors(int textureColor, VehicleTextureManager.TextureLayer layer, float blend) {
        int red = VehicleDynamicTextures.getR(textureColor);
        int green = VehicleDynamicTextures.getG(textureColor);
        int blue = VehicleDynamicTextures.getB(textureColor);
        if (blend == 0.0f || layer.getBlendMode() == VehicleTextureManager.BlendMode.ON_WHITE && red == 255 && green == 255 && blue == 255) {
            return VehicleDynamicTextures.combine(255, layer.getColor().getBlue(), layer.getColor().getGreen(), layer.getColor().getRed());
        }
        if (blend == 1.0f) {
            return textureColor;
        }
        return VehicleDynamicTextures.combine(255, VehicleDynamicTextures.blendColorChannel(blue, layer.getColor().getBlue(), blend), VehicleDynamicTextures.blendColorChannel(green, layer.getColor().getGreen(), blend), VehicleDynamicTextures.blendColorChannel(red, layer.getColor().getRed(), blend));
    }

    private static int blendColorChannel(int c1, int c2, float blend) {
        return Math.round((float)c1 * blend + (1.0f - blend) * (float)c2);
    }

    private static float calcBlend(VehicleTextureManager.TextureLayer layer) {
        switch (layer.getBlendMode()) {
            case EVEN: {
                return 0.5f;
            }
            case NONE: {
                return 1.0f;
            }
            case ON_ALL: {
                return 0.0f;
            }
            case ON_WHITE: {
                return 1.0f;
            }
            case SCALED: {
                Color color = layer.getColor();
                float f = 0.0013071896f;
                return (float)color.getRed() * f + (float)color.getGreen() * f + (float)color.getBlue() * f;
            }
        }
        return 0.0f;
    }

    public static int getA(int i) {
        return i >> 24 & 0xFF;
    }

    public static int getR(int i) {
        return i & 0xFF;
    }

    public static int getG(int i) {
        return i >> 8 & 0xFF;
    }

    public static int getB(int i) {
        return i >> 16 & 0xFF;
    }

    public static int combine(int a, int b, int g, int r) {
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
    }
}

