/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toserver;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientVehicleTexture;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ToServerVehicleTexture
extends BaseC2SMessage {
    public final int id;
    private EntityVehicle vehicle;
    private ByteBuf buffer;

    public ToServerVehicleTexture(EntityVehicle vehicle) {
        this.id = vehicle.m_19879_();
        this.vehicle = vehicle;
    }

    public ToServerVehicleTexture(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.buffer = buffer.copy().asReadOnly();
    }

    public MessageType getType() {
        return PacketHandler.C2S_VEHICLE_TEXTURE;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        this.vehicle.textureManager.write(buffer);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player player = context.getPlayer();
            Level level = UtilEntity.getLevel((Entity)player);
            Entity patt0$temp = level.m_6815_(this.id);
            if (patt0$temp instanceof EntityVehicle) {
                EntityVehicle vehicle = (EntityVehicle)patt0$temp;
                vehicle.textureManager.read(this.buffer);
                PacketHandler.sendToTrackers(new ToClientVehicleTexture(player, vehicle), (Entity)vehicle);
            }
        });
    }
}

