/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.util.UtilItem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PartItemLoadRecipe<I extends ReloadablePartInstance>
extends CustomRecipe {
    protected PartItemLoadRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer container, Level level) {
        if (this.hasOutlier(container)) {
            return false;
        }
        ItemStack part = this.getPartItem(container);
        if (part == null) {
            return false;
        }
        if (part.m_41613_() > 1) {
            return false;
        }
        List<ItemStack> ammo = this.getAmmoItems(container);
        I lpd = this.getLoadablePartDataFromItem(part);
        return this.canItemsCombine((ReloadablePartInstance)lpd, ammo);
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container, RegistryAccess registry) {
        ItemStack part = this.getPartItem(container);
        I lpd = this.getLoadablePartDataFromItem(part);
        if (this.fillPart((Container)container, (ReloadablePartInstance)lpd)) {
            return lpd.getNewItemStack();
        }
        return ItemStack.f_41583_;
    }

    public boolean fillPart(Container container, ReloadablePartInstance lpd) {
        List<ItemStack> ammo = this.getAmmoItemsContainer(container, null);
        if (!this.canItemsCombine(lpd, ammo)) {
            return false;
        }
        if (this.checkAmmoContinuity()) {
            String ammoCont = this.getItemAmmoContinuity(ammo.get(0));
            if (!this.isContinuityValid(ammoCont)) {
                return false;
            }
            this.emptyContinuityCheck(lpd, ammoCont);
        }
        float newAmmo = lpd.getCurrentAmmo();
        for (int i = 0; i < ammo.size(); ++i) {
            newAmmo += this.getAmmoNumFromItem(ammo.get(i));
        }
        if (newAmmo > lpd.getMaxAmmo()) {
            newAmmo = lpd.getMaxAmmo();
        }
        lpd.setCurrentAmmo(newAmmo);
        return true;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer container) {
        ItemStack part = this.getPartItem(container);
        I lpd = this.getLoadablePartDataFromItem(part);
        return this.getRemainingItems((Container)container, lpd);
    }

    public NonNullList<ItemStack> getRemainingItems(Container container, I lpd) {
        if (!this.consumeAmmoItems(container, (ReloadablePartInstance)lpd)) {
            return this.getRemainingItemsDefault(container);
        }
        NonNullList list = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = container.m_8020_(i);
            list.set(i, (Object)UtilItem.getCraftingRemainingItem((ItemStack)stack));
        }
        return list;
    }

    public boolean consumeAmmoItems(Container container, ReloadablePartInstance lpd) {
        List<ItemStack> ammo = this.getAmmoItemsContainer(container, null);
        if (!this.canItemsCombine(lpd, ammo)) {
            return false;
        }
        if (this.checkAmmoContinuity()) {
            String ammoCont = this.getItemAmmoContinuity(ammo.get(0));
            if (!this.isContinuityValid(ammoCont)) {
                return false;
            }
            this.emptyContinuityCheck(lpd, ammoCont);
        }
        float ca = lpd.getCurrentAmmo();
        float ma = lpd.getMaxAmmo();
        for (int i = 0; i < ammo.size(); ++i) {
            float c = this.getAmmoNumFromItem(ammo.get(i));
            float t = ca + c;
            if (t <= ma) {
                this.setAmmoNumForItem(ammo.get(i), 0.0f);
                ca += c;
                continue;
            }
            if (t > ma && ca != ma) {
                this.setAmmoNumForItem(ammo.get(i), t - ma);
                ca = ma;
                continue;
            }
            this.setAmmoNumForItem(ammo.get(i), c);
        }
        return true;
    }

    public void reloadFromInventory(Inventory inventory, ReloadablePartInstance lpd) {
        float newAmmo;
        String continuity = lpd.getContinuity();
        if (lpd.updateContinuityIfEmpty() && lpd.isContinuityEmpty()) {
            continuity = null;
        }
        if ((newAmmo = lpd.getCurrentAmmo()) >= lpd.getMaxAmmo()) {
            return;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            float ammo;
            float remain;
            ItemStack stack = inventory.m_8020_(i).m_41777_();
            if (stack.m_41619_() || !this.isItemAmmo(stack)) continue;
            if (this.checkAmmoContinuity()) {
                String stackCont = this.getItemAmmoContinuity(stack);
                if (continuity == null && this.isContinuityValid(stackCont) && lpd.isCompatibleWithAmmoContinuity(stackCont)) {
                    continuity = stackCont;
                } else if (!stackCont.equals(continuity)) continue;
            }
            if ((remain = (newAmmo += (ammo = this.getAmmoNumFromItem(stack))) - lpd.getMaxAmmo()) <= 0.0f) {
                inventory.m_6836_(i, ItemStack.f_41583_);
            } else {
                this.setAmmoNumForItem(stack, remain, false);
                inventory.m_6836_(i, stack);
            }
            if (!(newAmmo >= lpd.getMaxAmmo())) continue;
            newAmmo = lpd.getMaxAmmo();
            break;
        }
        if (continuity != null && !continuity.equals(lpd.getContinuity())) {
            lpd.setContinuity(continuity);
        }
        lpd.setCurrentAmmo(newAmmo);
    }

    public float getAmmoNumFromItem(ItemStack ammo) {
        switch (this.getAmmoLoadType().ordinal()) {
            case 0: {
                return ammo.m_41613_();
            }
            case 1: {
                return ammo.m_41776_() - ammo.m_41773_();
            }
        }
        return 0.0f;
    }

    public void setAmmoNumForItem(ItemStack ammo, float num) {
        this.setAmmoNumForItem(ammo, num, true);
    }

    public void setAmmoNumForItem(ItemStack ammo, float num, boolean add1) {
        switch (this.getAmmoLoadType().ordinal()) {
            case 0: {
                ammo.m_41764_((int)num + (add1 ? 1 : 0));
                break;
            }
            case 1: {
                ammo.m_41721_(ammo.m_41776_() - (int)num);
                if (!add1) break;
                ammo.m_41764_(2);
            }
        }
    }

    private void emptyContinuityCheck(ReloadablePartInstance lpd, String ammoCont) {
        if (lpd.updateContinuityIfEmpty() && lpd.isContinuityEmpty()) {
            lpd.setContinuity(ammoCont);
            lpd.setCurrentAmmo(0.0f);
            lpd.setMaxAmmo(this.getContinuityMaxAmmo(lpd, ammoCont));
        }
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean hasOutlier(CraftingContainer container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !this.isOutlier(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutlier(ItemStack stack) {
        return !this.isLoadablePartItem(stack) && !this.isItemAmmo(stack);
    }

    @Nullable
    public ItemStack getPartItem(CraftingContainer container, AtomicInteger index) {
        ItemStack part = null;
        index.set(-1);
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !this.isLoadablePartItem(stack)) continue;
            if (part != null) {
                return null;
            }
            part = stack;
            index.set(i);
        }
        return part;
    }

    @Nullable
    public ItemStack getPartItem(CraftingContainer container) {
        return this.getPartItem(container, new AtomicInteger());
    }

    @Nullable
    protected I getLoadablePartDataFromItem(ItemStack part) {
        if (part == null) {
            return null;
        }
        PartInstance<?> pd = UtilPresetParse.parsePartFromItem(part);
        if (pd == null) {
            return null;
        }
        return (I)((ReloadablePartInstance)((Object)pd));
    }

    @Nullable
    public List<ItemStack> getAmmoItems(CraftingContainer container) {
        return this.getAmmoItemsContainer((Container)container, null);
    }

    @Nullable
    public List<ItemStack> getAmmoItemsContainer(Container container, String continuity) {
        ArrayList<ItemStack> ammo = new ArrayList<ItemStack>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !this.isItemAmmo(stack)) continue;
            if (this.checkAmmoContinuity()) {
                String stackCont = this.getItemAmmoContinuity(stack);
                if (continuity == null) {
                    continuity = stackCont;
                } else if (!stackCont.equals(continuity)) continue;
            }
            ammo.add(stack);
        }
        return ammo;
    }

    public float getAmmoNum(Container container, String continuity) {
        float num = 0.0f;
        List<ItemStack> ammos = this.getAmmoItemsContainer(container, continuity);
        if (ammos == null) {
            return 0.0f;
        }
        for (ItemStack ammo : ammos) {
            num += this.getAmmoNumFromItem(ammo);
        }
        return num;
    }

    public abstract boolean isLoadablePartItem(ItemStack var1);

    public abstract boolean isItemAmmo(ItemStack var1);

    public abstract boolean checkAmmoContinuity();

    public abstract String getItemAmmoContinuity(ItemStack var1);

    public abstract boolean isContinuityValid(String var1);

    public abstract int getContinuityMaxAmmo(I var1, String var2);

    public boolean canItemsCombine(ReloadablePartInstance lpd, List<ItemStack> ammo) {
        if (lpd == null || ammo == null || ammo.isEmpty()) {
            return false;
        }
        if (this.checkAmmoContinuity()) {
            String ammoCont = this.getItemAmmoContinuity(ammo.get(0));
            if (!this.isContinuityValid(ammoCont)) {
                return false;
            }
            if (!lpd.isCompatibleWithAmmoContinuity(ammoCont)) {
                return false;
            }
            if (lpd.updateContinuityIfEmpty() && lpd.isContinuityEmpty()) {
                return true;
            }
            return lpd.getContinuity().equals(ammoCont);
        }
        System.out.println("can combine");
        return true;
    }

    public AmmoLoadType getAmmoLoadType() {
        return AmmoLoadType.ITEM_COUNT;
    }

    protected NonNullList<ItemStack> getRemainingItemsDefault(Container pContainer) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = pContainer.m_8020_(i);
            if (!UtilItem.hasCraftingRemainingItem((ItemStack)item)) continue;
            nonnulllist.set(i, (Object)UtilItem.getCraftingRemainingItem((ItemStack)item));
        }
        return nonnulllist;
    }

    public static enum AmmoLoadType {
        ITEM_COUNT,
        ITEM_DURABILITY;

    }
}

