/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.onewhohears.dscombat.crafting.PartItemLoadRecipe;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.onewholibs.util.UtilItem;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class PartItemUnloadRecipe<I extends ReloadablePartInstance>
extends PartItemLoadRecipe<I> {
    protected PartItemUnloadRecipe(ResourceLocation id) {
        super(id);
    }

    @Override
    public boolean matches(CraftingContainer container, Level level) {
        if (this.hasOutlier(container)) {
            return false;
        }
        ItemStack part = this.getPartItem(container);
        if (part == null) {
            return false;
        }
        return part.m_41613_() == 1;
    }

    @Override
    @NotNull
    public ItemStack assemble(CraftingContainer container, RegistryAccess registry) {
        ItemStack part = this.getPartItem(container);
        Object lpd = this.getLoadablePartDataFromItem(part);
        if (lpd == null) {
            return ItemStack.f_41583_;
        }
        String continuity = lpd.getContinuity();
        if (this.checkAmmoContinuity() && !lpd.isContinuityEmpty() && !this.isContinuityValid(continuity)) {
            return ItemStack.f_41583_;
        }
        ItemStack ammo = this.getNewAmmoItem(continuity);
        if (ammo.m_41619_()) {
            return ammo;
        }
        ammo.m_41764_((int)lpd.getCurrentAmmo());
        return ammo;
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer container) {
        AtomicInteger index = new AtomicInteger();
        ItemStack part = this.getPartItem(container, index);
        Object lpd = this.getLoadablePartDataFromItem(part);
        if (lpd == null) {
            return super.getRemainingItems(container);
        }
        lpd.setCurrentAmmo(0.0f);
        ItemStack newPart = lpd.getNewItemStack();
        NonNullList list = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            if (index.get() == i) {
                list.set(i, (Object)newPart);
                continue;
            }
            ItemStack stack = container.m_8020_(i);
            list.set(i, (Object)UtilItem.getCraftingRemainingItem((ItemStack)stack));
        }
        return list;
    }

    @Override
    public boolean isOutlier(ItemStack stack) {
        return !this.isLoadablePartItem(stack);
    }

    @NotNull
    public abstract ItemStack getNewAmmoItem(String var1);
}

