/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.dscombat.data.parts.instance.TurretInstance;
import com.onewhohears.dscombat.data.parts.stats.TurretStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.init.ModRecipes;
import com.onewhohears.dscombat.item.ItemAmmo;
import com.onewhohears.dscombat.item.ItemTurret;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class TurretUnloadRecipe
extends PartItemUnloadRecipe<TurretInstance<?>> {
    public TurretUnloadRecipe(ResourceLocation id) {
        super(id);
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.TURRET_UNLOAD.get();
    }

    @Override
    public boolean isLoadablePartItem(ItemStack stack) {
        return stack.m_41720_() instanceof ItemTurret;
    }

    @Override
    public boolean isItemAmmo(ItemStack stack) {
        return stack.m_41720_() instanceof ItemAmmo;
    }

    @Override
    public boolean checkAmmoContinuity() {
        return true;
    }

    @Override
    public String getItemAmmoContinuity(ItemStack stack) {
        return ItemAmmo.getWeaponId(stack);
    }

    @Override
    public boolean isContinuityValid(String continuity) {
        return WeaponPresets.get().has(continuity);
    }

    @Override
    public int getContinuityMaxAmmo(TurretInstance<?> lpd, String continuity) {
        if (!this.isContinuityValid(continuity)) {
            return 0;
        }
        return ((TurretStats)lpd.getStats()).getMaxAmmo();
    }

    @Override
    @NotNull
    public ItemStack getNewAmmoItem(String continuity) {
        WeaponStats wd = WeaponPresets.get().get(continuity);
        if (wd == null) {
            return ItemStack.f_41583_;
        }
        return wd.getNewItem();
    }
}

