/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.init.ModBlocks;
import com.onewhohears.onewholibs.data.crafting.IngredientStack;
import com.onewhohears.onewholibs.util.UtilItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleRecipe
implements Recipe<Inventory> {
    private final ResourceLocation id;
    private final String presetId;
    @Nullable
    private NonNullList<Ingredient> ingredients;

    public VehicleRecipe(ResourceLocation id, String presetId, @Nullable NonNullList<Ingredient> ingredients) {
        this.id = id;
        this.presetId = presetId;
        this.ingredients = ingredients;
    }

    public boolean matches(Inventory inventory, Level level) {
        return UtilItem.testRecipe(this.m_7527_(), (Container)inventory);
    }

    @NotNull
    public ItemStack assemble(Inventory container, RegistryAccess registry) {
        return this.getOutput();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(Inventory inventory) {
        return UtilItem.getRemainingItemsStackIngredients((Container)inventory, this.m_7527_());
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registry) {
        return this.getOutput().m_41777_();
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.AIRCRAFT_BLOCK.get());
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public String getVehiclePresetId() {
        return this.presetId;
    }

    public VehicleStats getVehicleStats() {
        return (VehicleStats)VehiclePresets.get().get(this.getVehiclePresetId());
    }

    public int getSortFactor() {
        VehicleStats preset = this.getVehicleStats();
        if (preset == null) {
            return 0;
        }
        return preset.getSortFactor();
    }

    public int compare(VehicleRecipe other) {
        if (this.getSortFactor() != other.getSortFactor()) {
            return this.getSortFactor() - other.getSortFactor();
        }
        return this.presetId.compareToIgnoreCase(other.presetId);
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        if (this.ingredients == null) {
            VehicleStats preset = this.getVehicleStats();
            this.ingredients = preset == null ? NonNullList.m_122779_() : preset.getIngredients();
        }
        return this.ingredients;
    }

    public ItemStack getOutput() {
        VehicleStats preset = this.getVehicleStats();
        if (preset == null) {
            return ItemStack.f_41583_;
        }
        return preset.getItem();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<VehicleRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("dscombat", "aircraft_workbench");

        @NotNull
        public VehicleRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            String presetId = serializedRecipe.get("presetId").getAsString();
            return new VehicleRecipe(recipeId, presetId, null);
        }

        @NotNull
        public VehicleRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String presetId = buffer.m_130277_();
            int size = buffer.readInt();
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < size; ++i) {
                ingredients.add((Object)IngredientStack.fromNetwork((FriendlyByteBuf)buffer));
            }
            return new VehicleRecipe(recipeId, presetId, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, VehicleRecipe recipe) {
            buffer.m_130070_(recipe.presetId);
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient i : recipe.m_7527_()) {
                IngredientStack.toNetwork((FriendlyByteBuf)buffer, (Ingredient)i);
            }
        }
    }

    public static class Type
    implements RecipeType<VehicleRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "aircraft_workbench";

        private Type() {
        }

        public String toString() {
            return ID;
        }
    }
}

