/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.crafting.PartItemLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.onewholibs.util.UtilMCText;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface ReloadablePartInstance {
    public float getCurrentAmmo();

    public float getMaxAmmo();

    public void setCurrentAmmo(float var1);

    public void setMaxAmmo(float var1);

    public boolean isCompatibleWithAmmoContinuity(String var1);

    public boolean updateContinuityIfEmpty();

    public void setContinuity(String var1);

    public String getContinuity();

    default public boolean isContinuityEmpty() {
        return this.getContinuity() == null || this.getContinuity().isEmpty();
    }

    public ItemStack getNewItemStack();

    public PartItemLoadRecipe<?> getLoadRecipe();

    @Nullable
    public PartItemUnloadRecipe<?> getUnloadRecipe();

    default public boolean canUnload() {
        return this.getUnloadRecipe() != null;
    }

    default public void loadPartFromInventory(ServerPlayer player) {
        PartItemLoadRecipe<?> recipe = this.getLoadRecipe();
        recipe.reloadFromInventory(player.m_150109_(), this);
    }

    default public void unloadPartToInventory(ServerPlayer player) {
        PartItemUnloadRecipe<?> recipe = this.getUnloadRecipe();
        if (recipe == null) {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.cant_unload"), true);
            return;
        }
        String continuity = this.getContinuity();
        if (recipe.checkAmmoContinuity() && !this.isContinuityEmpty() && !recipe.isContinuityValid(continuity)) {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.cant_unload"), true);
            return;
        }
        ItemStack ammo = recipe.getNewAmmoItem(continuity);
        if (ammo.m_41619_()) {
            return;
        }
        ammo.m_41764_((int)this.getCurrentAmmo());
        player.m_36356_(ammo);
        this.setCurrentAmmo(0.0f);
    }

    public MutableComponent getItemName();
}

