/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.world.phys.Vec3;

public class RotableHitboxData {
    private final String name;
    private final Vec3 size;
    private final Vec3 rel_pos;
    private final float max_health;
    private final float max_armor;
    private final boolean remove_on_destroy;
    private final boolean damage_parts;
    private final boolean damage_root;
    private final int index;

    public static JsonObject createHitboxJson(String name, double sizeX, double sizeY, double sizeZ, double posX, double posY, double posZ, float max_health, float max_armor, boolean remove_on_destroy, boolean damage_parts, boolean damage_root) {
        JsonObject hitbox = new JsonObject();
        hitbox.addProperty("name", name);
        UtilParse.writeVec3((JsonObject)hitbox, (String)"size", (Vec3)new Vec3(sizeX, sizeY, sizeZ));
        UtilParse.writeVec3((JsonObject)hitbox, (String)"rel_pos", (Vec3)new Vec3(posX, posY, posZ));
        hitbox.addProperty("max_health", (Number)Float.valueOf(max_health));
        hitbox.addProperty("max_armor", (Number)Float.valueOf(max_armor));
        hitbox.addProperty("remove_on_destroy", Boolean.valueOf(remove_on_destroy));
        hitbox.addProperty("damage_parts", Boolean.valueOf(damage_parts));
        hitbox.addProperty("damage_root", Boolean.valueOf(damage_root));
        return hitbox;
    }

    public RotableHitboxData(JsonObject json, int index) {
        this.name = json.get("name").getAsString();
        this.size = UtilParse.readVec3((JsonObject)json, (String)"size");
        this.rel_pos = UtilParse.readVec3((JsonObject)json, (String)"rel_pos");
        this.max_health = UtilParse.getFloatSafe((JsonObject)json, (String)"max_health", (float)0.0f);
        this.max_armor = UtilParse.getFloatSafe((JsonObject)json, (String)"max_armor", (float)0.0f);
        this.remove_on_destroy = UtilParse.getBooleanSafe((JsonObject)json, (String)"remove_on_destroy", (boolean)false);
        this.damage_parts = UtilParse.getBooleanSafe((JsonObject)json, (String)"damage_parts", (boolean)false);
        this.damage_root = UtilParse.getBooleanSafe((JsonObject)json, (String)"damage_root", (boolean)false);
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public Vec3 getSize() {
        return this.size;
    }

    public Vec3 getRelPos() {
        return this.rel_pos;
    }

    public float getMaxHealth() {
        return this.max_health;
    }

    public float getMaxArmor() {
        return this.max_armor;
    }

    public boolean isRemoveOnDestroy() {
        return this.remove_on_destroy;
    }

    public boolean isDamageParts() {
        return this.damage_parts;
    }

    public boolean isDamageRoot() {
        return this.damage_root;
    }

    public int getIndex() {
        return this.index;
    }
}

