/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.sound.PassengerSoundPack;
import com.onewhohears.dscombat.data.sound.VehiclePassengerSoundPacks;
import com.onewhohears.dscombat.data.vehicle.VehicleLoopingSounds;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilClientSafeSounds;
import com.onewhohears.dscombat.util.UtilSound;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import org.jetbrains.annotations.Nullable;

public class VehicleSoundManager {
    private static final RandomSource RANDOM_SRC = RandomSource.m_216327_();
    public final EntityVehicle parent;
    private VehicleLoopingSounds loopManager;
    private int prevSonicBoomTime = -1;
    private boolean didSonicBoom;

    public VehicleSoundManager(EntityVehicle parent) {
        this.parent = parent;
    }

    public void loadSounds(VehicleStats acp) {
        CompoundTag sounds = acp.getDataAsNBT().m_128469_("sounds");
        String loopSoundType = sounds.m_128461_("loopSoundType");
        this.loopManager = VehicleLoopingSounds.getByType(loopSoundType, this.parent);
        this.loopManager.loadPreset(sounds);
    }

    public void read(CompoundTag nbt) {
        if (!nbt.m_128441_("sounds")) {
            return;
        }
        CompoundTag sounds = nbt.m_128469_("sounds");
    }

    public void write(CompoundTag nbt) {
        CompoundTag sounds = new CompoundTag();
        nbt.m_128365_("sounds", (Tag)sounds);
    }

    public void read(FriendlyByteBuf buffer) {
    }

    public void write(FriendlyByteBuf buffer) {
    }

    public void onTick() {
        if (this.parent.isClientSide()) {
            this.onClientTick();
        } else {
            this.onServerTick();
        }
    }

    protected void onClientTick() {
        if (UtilClientSafeSounds.isClientRidingVehicle(this.parent)) {
            PassengerSoundPack pack = this.getPassengerSoundPack();
            if (pack != null) {
                pack.clientTickPassengerSounds(this.parent);
            }
        } else if (!this.didSonicBoom) {
            this.didSonicBoom = UtilClientSafeSounds.vehicleSonicBoom(this.parent);
        }
        this.tickLoopingSounds();
    }

    protected void tickLoopingSounds() {
        if (this.loopManager != null) {
            this.loopManager.baseTick();
        }
    }

    protected void onServerTick() {
    }

    public void onClientInit() {
    }

    @Nullable
    public PassengerSoundPack getPassengerSoundPack() {
        String selectedPack = (String)Config.CLIENT.passengerSoundPack.get();
        return (PassengerSoundPack)VehiclePassengerSoundPacks.get().get(selectedPack);
    }

    public void playPassengerRadarLockSound() {
        if (!this.parent.getWorld().m_5776_()) {
            return;
        }
        PassengerSoundPack pack = this.getPassengerSoundPack();
        if (pack != null) {
            pack.playRadarLockSound();
        }
    }

    public void playPassengerRadarFoundSound() {
        if (!this.parent.getWorld().m_5776_()) {
            return;
        }
        PassengerSoundPack pack = this.getPassengerSoundPack();
        if (pack != null) {
            pack.playRadarFoundSound();
        }
    }

    public void playPassengerFlareSound() {
        if (!this.parent.getWorld().m_5776_()) {
            return;
        }
        PassengerSoundPack pack = this.getPassengerSoundPack();
        if (pack != null) {
            pack.playFlareSound();
        }
    }

    public void playPassengerChaffSound() {
        if (!this.parent.getWorld().m_5776_()) {
            return;
        }
        PassengerSoundPack pack = this.getPassengerSoundPack();
        if (pack != null) {
            pack.playChaffSound();
        }
    }

    public void onHurt(DamageSource source, float amount) {
        if (this.parent.isClientSide() || !this.parent.isOperational()) {
            return;
        }
        float volume = Mth.m_14036_((float)(amount * 0.5f), (float)0.12f, (float)1.88f);
        float pitch = Mth.m_14036_((float)(1.0f + (RANDOM_SRC.m_188501_() - 0.5f) / 2.94f), (float)0.83f, (float)1.17f);
        SoundEvent forBroadcast = VehicleSoundManager.soundForHurt(source);
        UtilSound.sendDelayedSound((ServerLevel)this.parent.getWorld(), forBroadcast, this.parent.m_20182_(), 160.0f, volume, pitch);
    }

    public void onRadioSongUpdate(String song) {
        if (!this.parent.isClientSide()) {
            return;
        }
        if (song.isEmpty()) {
            return;
        }
        UtilClientSafeSounds.aircraftRadio(this.parent, song);
    }

    public static SoundEvent soundForHurt(DamageSource source) {
        SoundEvent toReturn = UtilVehicleEntity.isProjectile(source) ? ModSounds.VEHICLE_HURT_PROJECTILE_METAL : ModSounds.VEHICLE_HURT_COLLISION_METAL;
        return toReturn;
    }
}

