/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle.stats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.client.model.obj.ObjRadarModel;
import com.onewhohears.dscombat.data.parts.SlotType;
import com.onewhohears.dscombat.data.vehicle.EntityScreenData;
import com.onewhohears.dscombat.data.vehicle.RotableHitboxData;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentData;
import com.onewhohears.dscombat.data.vehicle.stats.BoatStats;
import com.onewhohears.dscombat.data.vehicle.stats.CarStats;
import com.onewhohears.dscombat.data.vehicle.stats.HeliStats;
import com.onewhohears.dscombat.data.vehicle.stats.PlaneStats;
import com.onewhohears.dscombat.data.vehicle.stats.SubmarineStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitbox;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.onewholibs.data.crafting.IngredientStackBuilder;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilGsonMerge;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class VehicleStats
extends JsonPresetStats {
    public final float max_health;
    public final float max_speed;
    public final float mass;
    public final float max_ground_speed;
    public final float stealth;
    public final float cross_sec_area;
    public final float idleheat;
    public final float drag_area;
    public final float base_armor;
    public final float armor_damage_threshold;
    public final float armor_damage_absorbtion;
    public final float turn_radius;
    public final float maxroll;
    public final float maxpitch;
    public final float maxyaw;
    public final float torqueroll;
    public final float torquepitch;
    public final float torqueyaw;
    public final float Ix;
    public final float Iy;
    public final float Iz;
    public final float groundXTilt;
    public final boolean is_hard_coded_rot_acc;
    public final Vec3 hard_coded_rot_acc;
    public final float hard_coded_rot_decel;
    public final float throttleup;
    public final float throttledown;
    public final boolean negativeThrottle;
    public final boolean has_turn_assist;
    public final double cameraDistance;
    public final double max_altitude;
    public final float crashExplosionRadius;
    public final float max_push_thrust_per_engine;
    public final float max_spin_thrust_per_engine;
    public final float max_afterburner_push_thrust_per_engine;
    public final float heat_per_engine;
    public final float fuel_consume_per_engine;
    public final boolean use_horizontal_speed_scale;
    public final boolean use_vertical_speed_scale;
    private final boolean has_afterburner;
    public final float cruise_speed;
    public final float break_deacc_ground;
    public final float break_deacc_air;
    public final float min_drive_acc;
    private final PhysicsComponentData[] physics_components;
    public final int baseTextureVariants;
    public final int textureLayers;
    public final Vec3[] afterBurnerSmokePos;
    public final ObjRadarModel.MastType mastType;
    public final EntityDimensions dimensions;
    public final boolean rootHitboxNoCollide;
    public final String[] controllPitchHitboxNames;
    public final String[] controllYawHitboxNames;
    public final String[] controllRollHitboxNames;
    private final boolean isCraftable;
    private final int defaultPaintJob;
    private final String assetId;
    private final String display_name_base;
    private CompoundTag dataNBT;
    private NonNullList<Ingredient> ingredients;
    private ItemStack item;
    private EntityScreenData[] screens;
    private RotableHitboxData[] hitboxes;

    public VehicleStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        JsonObject jo;
        int i;
        JsonArray ja;
        this.dataNBT = UtilParse.getCompoundFromJson((JsonObject)json);
        JsonObject stats = UtilParse.getJsonSafe((JsonObject)json, (String)"stats");
        this.max_health = UtilParse.getFloatSafe((JsonObject)stats, (String)"max_health", (float)10.0f);
        this.max_speed = UtilParse.getFloatSafe((JsonObject)stats, (String)"max_speed", (float)0.1f);
        this.max_ground_speed = UtilParse.getFloatSafe((JsonObject)stats, (String)"max_ground_speed", (float)this.max_speed);
        this.break_deacc_ground = UtilParse.getFloatSafe((JsonObject)stats, (String)"break_deacc_ground", (float)0.005f);
        this.break_deacc_air = UtilParse.getFloatSafe((JsonObject)stats, (String)"break_deacc_air", (float)0.001f);
        this.min_drive_acc = UtilParse.getFloatSafe((JsonObject)stats, (String)"min_drive_acc", (float)0.0f);
        this.mass = UtilParse.getFloatSafe((JsonObject)stats, (String)"mass", (float)1000.0f);
        this.stealth = UtilParse.getFloatSafe((JsonObject)stats, (String)"stealth", (float)1.0f);
        this.cross_sec_area = UtilParse.getFloatSafe((JsonObject)stats, (String)"cross_sec_area", (float)10.0f);
        this.drag_area = UtilParse.getFloatSafe((JsonObject)stats, (String)"drag_area", (float)this.cross_sec_area);
        this.idleheat = UtilParse.getFloatSafe((JsonObject)stats, (String)"idleheat", (float)10.0f);
        this.base_armor = UtilParse.getFloatSafe((JsonObject)stats, (String)"base_armor", (float)0.0f);
        this.armor_damage_threshold = UtilParse.getFloatSafe((JsonObject)stats, (String)"armor_damage_threshold", (float)0.0f);
        this.armor_damage_absorbtion = UtilParse.getFloatSafe((JsonObject)stats, (String)"armor_damage_absorbtion", (float)0.0f);
        this.throttleup = UtilParse.getFloatSafe((JsonObject)stats, (String)"throttleup", (float)0.01f);
        this.throttledown = UtilParse.getFloatSafe((JsonObject)stats, (String)"throttledown", (float)0.01f);
        this.negativeThrottle = UtilParse.getBooleanSafe((JsonObject)stats, (String)"negativeThrottle", (boolean)false);
        this.has_turn_assist = UtilParse.getBooleanSafe((JsonObject)stats, (String)"has_turn_assist", (boolean)false);
        this.turn_radius = UtilParse.getFloatSafe((JsonObject)stats, (String)"turn_radius", (float)100.0f);
        this.maxroll = UtilParse.getFloatSafe((JsonObject)stats, (String)"maxroll", (float)0.0f);
        this.maxpitch = UtilParse.getFloatSafe((JsonObject)stats, (String)"maxpitch", (float)0.0f);
        this.maxyaw = UtilParse.getFloatSafe((JsonObject)stats, (String)"maxyaw", (float)0.0f);
        this.Iz = UtilParse.getFloatSafe((JsonObject)stats, (String)"inertiaroll", (float)1000.0f);
        this.Ix = UtilParse.getFloatSafe((JsonObject)stats, (String)"inertiapitch", (float)1000.0f);
        this.Iy = UtilParse.getFloatSafe((JsonObject)stats, (String)"inertiayaw", (float)1000.0f);
        this.torqueroll = UtilParse.getFloatSafe((JsonObject)stats, (String)"torqueroll", (float)(this.Iz * 100.0f));
        this.torquepitch = UtilParse.getFloatSafe((JsonObject)stats, (String)"torquepitch", (float)(this.Ix * 10.0f));
        this.torqueyaw = UtilParse.getFloatSafe((JsonObject)stats, (String)"torqueyaw", (float)(this.Iy * 10.0f));
        this.hard_coded_rot_acc = UtilParse.readVec3((JsonObject)stats, (String)"hard_coded_rot_acc");
        this.hard_coded_rot_decel = UtilParse.getFloatSafe((JsonObject)stats, (String)"hard_coded_rot_decel", (float)0.0f);
        this.is_hard_coded_rot_acc = !UtilGeometry.isZero((Vec3)this.hard_coded_rot_acc);
        this.crashExplosionRadius = UtilParse.getFloatSafe((JsonObject)stats, (String)"crashExplosionRadius", (float)0.0f);
        this.cameraDistance = UtilParse.getFloatSafe((JsonObject)stats, (String)"cameraDistance", (float)4.0f);
        this.rootHitboxNoCollide = UtilParse.getBooleanSafe((JsonObject)stats, (String)"rootHitboxNoCollide", (boolean)false);
        this.mastType = stats.has("mastType") ? ObjRadarModel.MastType.valueOf(stats.get("mastType").getAsString()) : ObjRadarModel.MastType.NONE;
        float entity_size_xz = UtilParse.getFloatSafe((JsonObject)stats, (String)"entity_size_xz", (float)4.0f);
        float entity_size_y = UtilParse.getFloatSafe((JsonObject)stats, (String)"entity_size_y", (float)4.0f);
        this.max_altitude = UtilParse.getFloatSafe((JsonObject)stats, (String)"max_altitude", (float)330.0f);
        this.assetId = UtilParse.getStringSafe((JsonObject)stats, (String)"assetId", (String)key.m_135815_());
        this.dimensions = EntityDimensions.m_20398_((float)entity_size_xz, (float)entity_size_y);
        this.groundXTilt = UtilParse.getIntSafe((JsonObject)stats, (String)"groundXTilt", (int)0);
        this.max_push_thrust_per_engine = UtilParse.getFloatSafe((JsonObject)stats, (String)"max_push_thrust_per_engine", (float)-1.0f);
        this.max_spin_thrust_per_engine = UtilParse.getFloatSafe((JsonObject)stats, (String)"max_spin_thrust_per_engine", (float)-1.0f);
        this.max_afterburner_push_thrust_per_engine = UtilParse.getFloatSafe((JsonObject)stats, (String)"max_afterburner_push_thrust_per_engine", (float)this.max_push_thrust_per_engine);
        this.has_afterburner = this.max_afterburner_push_thrust_per_engine > this.max_push_thrust_per_engine;
        this.heat_per_engine = UtilParse.getFloatSafe((JsonObject)stats, (String)"heat_per_engine", (float)-1.0f);
        this.fuel_consume_per_engine = UtilParse.getFloatSafe((JsonObject)stats, (String)"fuel_consume_per_engine", (float)-1.0f);
        this.use_horizontal_speed_scale = UtilParse.getBooleanSafe((JsonObject)stats, (String)"use_horizontal_speed_scale", (boolean)false);
        this.use_vertical_speed_scale = UtilParse.getBooleanSafe((JsonObject)stats, (String)"use_vertical_speed_scale", (boolean)false);
        this.cruise_speed = UtilParse.getFloatSafe((JsonObject)stats, (String)"cruise_speed", (float)this.max_speed);
        if (json.has("textures")) {
            JsonObject textures = json.get("textures").getAsJsonObject();
            this.baseTextureVariants = UtilParse.getIntSafe((JsonObject)textures, (String)"baseTextureVariants", (int)1);
            this.textureLayers = UtilParse.getIntSafe((JsonObject)textures, (String)"textureLayers", (int)0);
        } else {
            this.baseTextureVariants = 1;
            this.textureLayers = 0;
        }
        if (json.has("after_burner_smoke")) {
            ja = json.get("after_burner_smoke").getAsJsonArray();
            this.afterBurnerSmokePos = new Vec3[ja.size()];
            for (i = 0; i < this.afterBurnerSmokePos.length; ++i) {
                jo = ja.get(i).getAsJsonObject();
                this.afterBurnerSmokePos[i] = UtilParse.readVec3((JsonObject)jo, (String)"pos");
            }
        } else {
            this.afterBurnerSmokePos = new Vec3[0];
        }
        this.isCraftable = UtilParse.getBooleanSafe((JsonObject)json, (String)"is_craftable", (boolean)false);
        this.defaultPaintJob = UtilParse.getIntSafe((JsonObject)json, (String)"paintjob_color", (int)0);
        this.controllPitchHitboxNames = UtilParse.getStringArraySafe((JsonObject)stats, (String)"hitboxes_control_pitch");
        this.controllYawHitboxNames = UtilParse.getStringArraySafe((JsonObject)stats, (String)"hitboxes_control_yaw");
        this.controllRollHitboxNames = UtilParse.getStringArraySafe((JsonObject)stats, (String)"hitboxes_control_roll");
        this.display_name_base = UtilParse.getStringSafe((JsonObject)json, (String)"display_name_base", (String)("item.dscombat." + this.getAssetId()));
        if (json.has("physics_components")) {
            ja = json.get("physics_components").getAsJsonArray();
            this.physics_components = new PhysicsComponentData[ja.size()];
            for (i = 0; i < this.physics_components.length; ++i) {
                jo = ja.get(i).getAsJsonObject();
                PhysicsComponentData data = PhysicsComponentData.getData(jo);
                if (data == null) continue;
                this.physics_components[i] = data;
            }
        } else {
            this.physics_components = new PhysicsComponentData[0];
        }
    }

    public CompoundTag getDataAsNBT() {
        return this.dataNBT;
    }

    public boolean isCraftable() {
        return this.isCraftable;
    }

    public EntityType<? extends EntityVehicle> getEntityType() {
        return this.getVehicleType().getEntityType();
    }

    public VehicleType getVehicleType() {
        return (VehicleType)this.getType();
    }

    public NonNullList<Ingredient> getIngredients() {
        if (this.ingredients == null) {
            this.ingredients = IngredientStackBuilder.getIngredients((JsonObject)this.getJsonData());
        }
        return this.ingredients;
    }

    public ItemStack getItem() {
        if (this.item == null) {
            this.item = new ItemStack((ItemLike)UtilItem.getItem((String)this.getJsonData().get("item").getAsString()));
            this.item.m_41784_().m_128359_("preset", this.getId());
        }
        return this.item.m_41777_();
    }

    public int getDefaultPaintJob() {
        return this.defaultPaintJob;
    }

    public RotableHitboxData[] getHitboxData() {
        if (this.hitboxes == null) {
            if (!this.getJsonData().has("hitboxes")) {
                this.hitboxes = new RotableHitboxData[0];
                return this.hitboxes;
            }
            JsonArray hba = this.getJsonData().get("hitboxes").getAsJsonArray();
            this.hitboxes = new RotableHitboxData[hba.size()];
            for (int i = 0; i < hba.size(); ++i) {
                JsonObject json = hba.get(i).getAsJsonObject();
                this.hitboxes[i] = new RotableHitboxData(json, i);
            }
        }
        return this.hitboxes;
    }

    public int getHitboxNum() {
        return this.getHitboxData().length;
    }

    @Nullable
    public RotableHitboxData getHitboxDataByName(String name) {
        for (int i = 0; i < this.getHitboxData().length; ++i) {
            if (!this.getHitboxData()[i].getName().equals(name)) continue;
            return this.getHitboxData()[i];
        }
        return null;
    }

    public List<RotableHitbox> createRotableHitboxes(EntityVehicle parent) {
        ArrayList<RotableHitbox> entities = new ArrayList<RotableHitbox>();
        for (int i = 0; i < this.getHitboxData().length; ++i) {
            entities.add(new RotableHitbox(parent, this.getHitboxData()[i]));
        }
        return entities;
    }

    public EntityScreenData[] getEntityScreens() {
        if (this.screens == null) {
            if (!this.getJsonData().has("screens")) {
                this.screens = new EntityScreenData[0];
            } else {
                JsonArray s = this.getJsonData().get("screens").getAsJsonArray();
                this.screens = new EntityScreenData[s.size()];
                for (int i = 0; i < this.screens.length; ++i) {
                    JsonObject json = s.get(i).getAsJsonObject();
                    this.screens[i] = EntityScreenData.getScreenFromJson(json);
                }
            }
        }
        return this.screens;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String toString() {
        return this.getKey().toString() + " " + this.getJsonData().toString();
    }

    public boolean mergeWithParent(JsonPresetStats parent) {
        if (!super.mergeWithParent(parent)) {
            return false;
        }
        this.mergeSlots();
        this.dataNBT = UtilParse.getCompoundFromJson((JsonObject)this.getJsonData());
        return true;
    }

    protected void mergeSlots() {
        if (!this.getJsonData().has("slots")) {
            return;
        }
        JsonArray slots = this.getJsonData().get("slots").getAsJsonArray();
        block0: for (int i = 0; i < slots.size(); ++i) {
            JsonObject slot = slots.get(i).getAsJsonObject();
            String name = slot.get("name").getAsString();
            for (int j = i + 1; j < slots.size(); ++j) {
                JsonObject slot2 = slots.get(j).getAsJsonObject();
                String name2 = slot2.get("name").getAsString();
                if (!name.equals(name2)) continue;
                UtilGsonMerge.extendJsonObject((UtilGsonMerge.ConflictStrategy)UtilGsonMerge.ConflictStrategy.PREFER_FIRST_OBJ, (JsonObject)slot, (JsonObject[])new JsonObject[]{slot2});
                slots.remove(j);
                --i;
                continue block0;
            }
        }
    }

    public MutableComponent getBaseDisplayName() {
        return UtilMCText.translatable((String)this.display_name_base);
    }

    public PhysicsComponentData[] getPhysicsComponents() {
        return this.physics_components;
    }

    public JsonPresetInstance<?> createPresetInstance() {
        return null;
    }

    @Nullable
    public PlaneStats asPlane() {
        return (PlaneStats)this.as(VehicleType.PLANE);
    }

    @Nullable
    public HeliStats asHeli() {
        return (HeliStats)this.as(VehicleType.HELICOPTER);
    }

    @Nullable
    public CarStats asCar() {
        return (CarStats)this.as(VehicleType.CAR);
    }

    @Nullable
    public BoatStats asBoat() {
        return (BoatStats)this.as(VehicleType.BOAT);
    }

    @Nullable
    public SubmarineStats asSubmarine() {
        return (SubmarineStats)this.as(VehicleType.SUBMARINE);
    }

    public boolean isAircraft() {
        return false;
    }

    public boolean flipPitchThrottle() {
        return true;
    }

    public boolean ignoreInvertY() {
        return true;
    }

    public boolean isTank() {
        return false;
    }

    public boolean isHeli() {
        return false;
    }

    public boolean isPlane() {
        return false;
    }

    public boolean isBoat() {
        return false;
    }

    public boolean isSub() {
        return false;
    }

    public boolean isStationaryRadar() {
        return false;
    }

    public boolean canUseAfterBurner() {
        return this.has_afterburner;
    }

    public static class Builder
    extends IngredientStackBuilder<Builder> {
        private boolean is_craftable = false;

        protected Builder(String namespace, String name, VehicleType type) {
            super(namespace, name, (JsonPresetType)type);
        }

        protected Builder(String namespace, String name, VehicleType type, VehicleStats copy) {
            super(namespace, name, (JsonPresetType)type, copy.getJsonData().deepCopy());
        }

        public static Builder createPlane(String namespace, String name) {
            return new Builder(namespace, name, VehicleType.PLANE);
        }

        public static Builder createHelicopter(String namespace, String name) {
            return new Builder(namespace, name, VehicleType.HELICOPTER);
        }

        public static Builder createCar(String namespace, String name) {
            return new Builder(namespace, name, VehicleType.CAR);
        }

        public static Builder createBoat(String namespace, String name) {
            return new Builder(namespace, name, VehicleType.BOAT);
        }

        public static Builder createSubmarine(String namespace, String name) {
            return new Builder(namespace, name, VehicleType.SUBMARINE);
        }

        public static Builder createStationary(String namespace, String name) {
            return new Builder(namespace, name, VehicleType.STATIONARY);
        }

        public static Builder createFromCopy(String namespace, String name, VehicleStats copy) {
            return new Builder(namespace, name, (VehicleType)copy.getType(), copy);
        }

        public <T extends JsonPresetStats> T build() {
            this.setBoolean("landing_gear", true);
            this.setBoolean("is_craftable", this.is_craftable);
            return (T)super.build();
        }

        public Builder setCraftable() {
            this.is_craftable = true;
            return this;
        }

        public Builder addItemSlot(String name, SlotType type, double x, double y, double z, float zRot, @Nullable ResourceLocation item, @Nullable String param, boolean filled, @Nullable String linkedHitbox) {
            JsonObject slot = this.getSlot(name, true);
            slot.addProperty("name", name);
            slot.addProperty("slot_type", type.getSlotTypeName());
            slot.addProperty("slot_posx", (Number)x);
            slot.addProperty("slot_posy", (Number)y);
            slot.addProperty("slot_posz", (Number)z);
            slot.addProperty("zRot", (Number)Float.valueOf(zRot));
            if (linkedHitbox != null) {
                slot.addProperty("linkedHitbox", linkedHitbox);
            }
            if (item != null) {
                JsonObject d = new JsonObject();
                d.addProperty("itemid", item.toString());
                if (param != null) {
                    d.addProperty("param", param);
                }
                if (filled) {
                    d.addProperty("filled", Boolean.valueOf(filled));
                }
                slot.add("data", (JsonElement)d);
            }
            return this;
        }

        public Builder addItemSlot(String name, SlotType type, double x, double y, double z, float zRot, @Nullable ResourceLocation item, @Nullable String param, boolean filled) {
            return this.addItemSlot(name, type, x, y, z, zRot, item, param, filled, null);
        }

        public Builder setSlotEmpty(String name) {
            JsonObject slot = this.getSlot(name, true);
            if (slot != null) {
                slot.add("data", (JsonElement)new JsonObject());
            }
            return this;
        }

        public Builder setSlotItem(String name, @Nullable String part, @Nullable String param, boolean filled) {
            if (part == null) {
                return this.setSlotEmpty(name);
            }
            JsonObject slot = this.getSlot(name, true);
            if (slot == null) {
                return this;
            }
            JsonObject d = new JsonObject();
            d.addProperty("part", part);
            if (param != null) {
                d.addProperty("param", param);
            }
            if (filled) {
                d.addProperty("filled", Boolean.valueOf(filled));
            }
            slot.add("data", (JsonElement)d);
            return this;
        }

        public Builder setSlotItem(String name, @Nullable String part) {
            return this.setSlotItem(name, part, null, false);
        }

        public Builder setSlotItem(String name, @Nullable ResourceLocation item, @Nullable String param, boolean filled) {
            if (item == null) {
                return this.setSlotEmpty(name);
            }
            return this.setSlotItem(name, item.m_135815_(), param, filled);
        }

        public Builder setSlotItem(String name, @Nullable ResourceLocation item) {
            return this.setSlotItem(name, item, null, false);
        }

        public Builder setSlotItem(String name, @Nullable ResourceLocation item, boolean filled) {
            return this.setSlotItem(name, item, null, filled);
        }

        public Builder lockSlot(String name) {
            JsonObject slot = this.getSlot(name, false);
            if (slot == null) {
                return this;
            }
            slot.addProperty("locked", Boolean.valueOf(true));
            return this;
        }

        public Builder setSlotOnlyCompatible(String slotName, String partId) {
            JsonObject slot = this.getSlot(slotName, false);
            if (slot == null) {
                return this;
            }
            slot.addProperty("onlyCompatPart", partId);
            return this;
        }

        protected JsonArray getSlots() {
            if (!this.getData().has("slots")) {
                this.getData().add("slots", (JsonElement)new JsonArray());
            }
            return this.getData().get("slots").getAsJsonArray();
        }

        @Nullable
        protected JsonObject getSlot(String name, boolean createNew) {
            JsonArray slots = this.getSlots();
            for (int i = 0; i < slots.size(); ++i) {
                JsonObject slot = slots.get(i).getAsJsonObject();
                if (!slot.get("name").getAsString().equals(name)) continue;
                return slot;
            }
            if (!createNew && this.getSlotFromCopy(name) == null) {
                return null;
            }
            JsonObject slot = new JsonObject();
            slot.addProperty("name", name);
            slots.add((JsonElement)slot);
            return slot;
        }

        @Nullable
        protected JsonObject getSlotFromCopy(String name) {
            if (!this.isCopy()) {
                return null;
            }
            JsonObject copy = this.getCopyData();
            if (!copy.has("slots")) {
                return null;
            }
            JsonArray slots = copy.get("slots").getAsJsonArray();
            for (int i = 0; i < slots.size(); ++i) {
                JsonObject slot = slots.get(i).getAsJsonObject();
                if (!slot.get("name").getAsString().equals(name)) continue;
                return slot;
            }
            return null;
        }

        public Builder addItemSlot(String name, SlotType type, double x, double y, double z, float zRot, @Nullable ResourceLocation item) {
            return this.addItemSlot(name, type, x, y, z, zRot, item, null, false);
        }

        public Builder addItemSlot(String name, SlotType type, @Nullable ResourceLocation item, @Nullable String param, boolean filled) {
            return this.addItemSlot(name, type, 0.0, 0.0, 0.0, 0.0f, item, param, filled);
        }

        public Builder addItemSlot(String name, SlotType type, @Nullable ResourceLocation item, boolean filled) {
            return this.addItemSlot(name, type, 0.0, 0.0, 0.0, 0.0f, item, null, filled);
        }

        public Builder addItemSlot(String name, SlotType type, @Nullable ResourceLocation item) {
            return this.addItemSlot(name, type, 0.0, 0.0, 0.0, 0.0f, item, null, false);
        }

        public Builder addEmptySlot(String name, SlotType type, double x, double y, double z, float zRot) {
            return this.addItemSlot(name, type, x, y, z, zRot, null, null, false);
        }

        public Builder addEmptySlot(String name, SlotType type, double x, double y, double z) {
            return this.addItemSlot(name, type, x, y, z, 0.0f, null, null, false);
        }

        public Builder addEmptySlot(String name, SlotType type, double x, double y, double z, float zRot, String linkedHitbox) {
            return this.addItemSlot(name, type, x, y, z, zRot, null, null, false, linkedHitbox);
        }

        public Builder addEmptySlot(String name, SlotType type) {
            return this.addItemSlot(name, type, 0.0, 0.0, 0.0, 0.0f, null, null, false);
        }

        public Builder addEmptySlot(String name, SlotType type, String linkedHitbox) {
            return this.addItemSlot(name, type, 0.0, 0.0, 0.0, 0.0f, null, null, false, linkedHitbox);
        }

        public Builder addSeatSlot(String name, double x, double y, double z) {
            return this.addItemSlot(name, SlotType.SEAT, x, y, z, 0.0f, ModItems.SEAT.getId(), null, false);
        }

        public Builder addSeatSlot(String name, double x, double y, double z, boolean eject) {
            return this.addItemSlot(name, SlotType.SEAT, x, y, z, 0.0f, ModItems.SEAT.getId(), eject ? "eject" : null, false);
        }

        public Builder addPilotSeatSlot(double x, double y, double z) {
            return this.addItemSlot("pilot_seat", SlotType.SEAT, x, y, z, 0.0f, ModItems.SEAT.getId(), null, false);
        }

        public Builder addPilotSeatSlot(double x, double y, double z, boolean eject) {
            return this.addItemSlot("pilot_seat", SlotType.SEAT, x, y, z, 0.0f, ModItems.SEAT.getId(), eject ? "eject" : null, false);
        }

        public Builder addSeatSlot(String name, SlotType type, double x, double y, double z) {
            return this.addItemSlot(name, type, x, y, z, 0.0f, ModItems.SEAT.getId(), null, false);
        }

        public Builder addSeatSlot(String name, SlotType type, double x, double y, double z, boolean eject) {
            return this.addItemSlot(name, type, x, y, z, 0.0f, ModItems.SEAT.getId(), eject ? "eject" : null, false);
        }

        public Builder setItem(ResourceLocation item) {
            return this.setString("item", item.toString());
        }

        protected JsonArray getHitboxes() {
            if (!this.getData().has("hitboxes")) {
                this.getData().add("hitboxes", (JsonElement)new JsonArray());
            }
            return this.getData().get("hitboxes").getAsJsonArray();
        }

        public Builder addRotableHitbox(String name, double sizeX, double sizeY, double sizeZ, double posX, double posY, double posZ) {
            return this.addRotableHitbox(name, sizeX, sizeY, sizeZ, posX, posY, posZ, 0.0f, 0.0f, false, false, false);
        }

        public Builder addRotableHitbox(String name, double sizeX, double sizeY, double sizeZ, double posX, double posY, double posZ, float max_health, float max_armor, boolean remove_on_destroy, boolean damage_parts, boolean damage_root) {
            this.getHitboxes().add((JsonElement)RotableHitboxData.createHitboxJson(name, sizeX, sizeY, sizeZ, posX, posY, posZ, max_health, max_armor, remove_on_destroy, damage_parts, damage_root));
            return this;
        }

        protected JsonArray getScreens() {
            if (!this.getData().has("screens")) {
                this.getData().add("screens", (JsonElement)new JsonArray());
            }
            return this.getData().get("screens").getAsJsonArray();
        }

        public Builder addEntityScreen(int id, double posX, double posY, double posZ, double width, double height, double rotX, double rotY, double rotZ) {
            JsonObject screen = new JsonObject();
            screen.addProperty("id", (Number)id);
            UtilParse.writeVec3((JsonObject)screen, (String)"pos", (Vec3)new Vec3(posX, posY, posZ));
            screen.addProperty("width", (Number)width);
            screen.addProperty("height", (Number)height);
            UtilParse.writeVec3((JsonObject)screen, (String)"rot", (Vec3)new Vec3(rotX, rotY, rotZ));
            this.getScreens().add((JsonElement)screen);
            return this;
        }

        public Builder addEntityScreen(int id, double posX, double posY, double posZ, double width, double height) {
            return this.addEntityScreen(id, posX, posY, posZ, width, height, 0.0, 0.0, 0.0);
        }

        public Builder addEntityScreen(int id, double posX, double posY, double posZ, double width, double height, double rotX) {
            return this.addEntityScreen(id, posX, posY, posZ, width, height, rotX, 0.0, 0.0);
        }

        public Builder addHUDScreen(double seatX, double seatY, double seatZ) {
            return this.addEntityScreen(2, seatX, seatY + 1.27, seatZ + 0.13, 0.1, 0.1, 0.0, 0.0, 0.0);
        }

        protected JsonArray getAfterBurnerSmokes() {
            if (!this.getData().has("after_burner_smoke")) {
                this.getData().add("after_burner_smoke", (JsonElement)new JsonArray());
            }
            return this.getData().get("after_burner_smoke").getAsJsonArray();
        }

        public Builder addAfterBurnerSmokePos(double posX, double posY, double posZ) {
            JsonObject smoke = new JsonObject();
            UtilParse.writeVec3((JsonObject)smoke, (String)"pos", (Vec3)new Vec3(posX, posY, posZ));
            this.getAfterBurnerSmokes().add((JsonElement)smoke);
            return this;
        }

        public JsonObject getStats() {
            if (!this.getData().has("stats")) {
                this.getData().add("stats", (JsonElement)new JsonObject());
            }
            return this.getData().get("stats").getAsJsonObject();
        }

        public JsonObject getStatsByType(String vehicleType) {
            if (!this.getStats().has(vehicleType)) {
                this.getStats().add(vehicleType, (JsonElement)new JsonObject());
            }
            return this.getStats().get(vehicleType).getAsJsonObject();
        }

        public Builder setStatFloat(String key, float value) {
            this.getStats().addProperty(key, (Number)Float.valueOf(value));
            return this;
        }

        public Builder setStatInt(String key, int value) {
            this.getStats().addProperty(key, (Number)value);
            return this;
        }

        public Builder setStatBoolean(String key, boolean value) {
            this.getStats().addProperty(key, Boolean.valueOf(value));
            return this;
        }

        public Builder setStatString(String key, String value) {
            this.getStats().addProperty(key, value);
            return this;
        }

        public Builder setTypedStatFloat(String key, float value, String vehicleType) {
            this.getStatsByType(vehicleType).addProperty(key, (Number)Float.valueOf(value));
            return this;
        }

        public Builder setTypedStatString(String key, String value, String vehicleType) {
            this.getStatsByType(vehicleType).addProperty(key, value);
            return this;
        }

        public Builder setTypedStatBoolean(String key, boolean value, String vehicleType) {
            this.getStatsByType(vehicleType).addProperty(key, Boolean.valueOf(value));
            return this;
        }

        public Builder setAssetId(String assetId) {
            return this.setStatString("assetId", assetId);
        }

        public Builder setMaxSpeed(float max_speed) {
            return this.setStatFloat("max_speed", max_speed);
        }

        public Builder setMaxHealth(float max_health) {
            this.setFloat("health", max_health);
            return this.setStatFloat("max_health", max_health);
        }

        public Builder setMass(float mass) {
            return this.setStatFloat("mass", mass);
        }

        public Builder setBaseArmor(float armor) {
            this.setFloat("armor", armor);
            return this.setStatFloat("base_armor", armor);
        }

        public Builder setArmorDamageThreshold(float armor_damage_threshold) {
            return this.setStatFloat("armor_damage_threshold", armor_damage_threshold);
        }

        public Builder setArmorAbsorbtionPercent(float armor_damage_absorbtion) {
            return this.setStatFloat("armor_damage_absorbtion", armor_damage_absorbtion);
        }

        public Builder setCrossSecArea(float area) {
            return this.setStatFloat("cross_sec_area", area);
        }

        public Builder setStealth(float stealth) {
            return this.setStatFloat("stealth", stealth);
        }

        public Builder setIdleHeat(float idleheat) {
            return this.setStatFloat("idleheat", idleheat);
        }

        public Builder setTurnRadius(float turn_radius) {
            return this.setStatFloat("turn_radius", turn_radius);
        }

        public Builder setMaxTurnRates(float maxroll, float maxpitch, float maxyaw) {
            this.setStatFloat("maxroll", maxroll);
            this.setStatFloat("maxpitch", maxpitch);
            return this.setStatFloat("maxyaw", maxyaw);
        }

        public Builder setTurnTorques(float torqueroll, float torquepitch, float torqueyaw) {
            this.setStatFloat("torqueroll", torqueroll);
            this.setStatFloat("torquepitch", torquepitch);
            return this.setStatFloat("torqueyaw", torqueyaw);
        }

        public Builder setRotationalInertia(float inertiaroll, float inertiapitch, float inertiayaw) {
            this.setStatFloat("inertiaroll", inertiaroll);
            this.setStatFloat("inertiapitch", inertiapitch);
            return this.setStatFloat("inertiayaw", inertiayaw);
        }

        public Builder setThrottleRate(float throttleup, float throttledown) {
            this.setStatFloat("throttledown", throttledown);
            return this.setStatFloat("throttleup", throttleup);
        }

        public Builder setCanNegativeThrottle(boolean negativeThrottle) {
            return this.setStatBoolean("negativeThrottle", negativeThrottle);
        }

        public Builder setHasTurnAssist(boolean has_turn_assist) {
            return this.setStatBoolean("has_turn_assist", has_turn_assist);
        }

        public Builder setCrashExplosionRadius(float crashExplosionRadius) {
            return this.setStatFloat("crashExplosionRadius", crashExplosionRadius);
        }

        public Builder setMaxAltitude(float max_altitude) {
            return this.setStatFloat("max_altitude", max_altitude);
        }

        public Builder set3rdPersonCamDist(float cameraDistance) {
            return this.setStatFloat("cameraDistance", cameraDistance);
        }

        public Builder setMastType(ObjRadarModel.MastType mastType) {
            return this.setStatString("mastType", mastType.toString());
        }

        public Builder setHitboxesControlPitch(String ... hitboxes_control_pitch) {
            this.getStats().add("hitboxes_control_pitch", (JsonElement)UtilParse.stringArrayToJsonArray((String[])hitboxes_control_pitch));
            return this;
        }

        public Builder setHitboxesControlYaw(String ... hitboxes_control_yaw) {
            this.getStats().add("hitboxes_control_yaw", (JsonElement)UtilParse.stringArrayToJsonArray((String[])hitboxes_control_yaw));
            return this;
        }

        public Builder setHitboxesControlRoll(String ... hitboxes_control_roll) {
            this.getStats().add("hitboxes_control_roll", (JsonElement)UtilParse.stringArrayToJsonArray((String[])hitboxes_control_roll));
            return this;
        }

        public Builder setPushEngineOverrideStats(float max_push_thrust_per_engine, float heat_per_engine, float fuel_consume_per_engine) {
            this.setStatFloat("max_push_thrust_per_engine", max_push_thrust_per_engine);
            this.setStatFloat("heat_per_engine", heat_per_engine);
            return this.setStatFloat("fuel_consume_per_engine", fuel_consume_per_engine);
        }

        public Builder setPushEngineOverrideAfterburnerStats(float max_push_thrust_per_engine, float max_afterburner_push_thrust_per_engine, float heat_per_engine, float fuel_consume_per_engine) {
            this.setStatFloat("max_push_thrust_per_engine", max_push_thrust_per_engine);
            this.setStatFloat("max_afterburner_push_thrust_per_engine", max_afterburner_push_thrust_per_engine);
            this.setStatFloat("heat_per_engine", heat_per_engine);
            return this.setStatFloat("fuel_consume_per_engine", fuel_consume_per_engine);
        }

        public Builder setSpinEngineOverrideStats(float max_spin_thrust_per_engine, float heat_per_engine, float fuel_consume_per_engine) {
            this.setStatFloat("max_spin_thrust_per_engine", max_spin_thrust_per_engine);
            this.setStatFloat("heat_per_engine", heat_per_engine);
            return this.setStatFloat("fuel_consume_per_engine", fuel_consume_per_engine);
        }

        public JsonObject getTextures() {
            if (!this.getData().has("textures")) {
                this.getData().add("textures", (JsonElement)new JsonObject());
            }
            return this.getData().get("textures").getAsJsonObject();
        }

        public Builder setDefaultBaseTexture(int index) {
            this.getTextures().addProperty("baseTexture", (Number)index);
            return this;
        }

        public Builder setBaseTextureNum(int baseTextureVariants) {
            this.getTextures().addProperty("baseTextureVariants", (Number)baseTextureVariants);
            return this;
        }

        public Builder setLayerTextureNum(int textureLayers) {
            this.getTextures().addProperty("textureLayers", (Number)textureLayers);
            return this;
        }

        public JsonObject getSounds() {
            if (!this.getData().has("sounds")) {
                this.getData().add("sounds", (JsonElement)new JsonObject());
            }
            return this.getData().get("sounds").getAsJsonObject();
        }

        public Builder setBasicEngineSounds(ResourceLocation nonPassengerEngine, ResourceLocation passengerEngine) {
            this.getSounds().addProperty("loopSoundType", "basic");
            this.getSounds().addProperty("nonPassengerEngine", nonPassengerEngine.toString());
            this.getSounds().addProperty("passengerEngine", passengerEngine.toString());
            return this;
        }

        public Builder setBasicEngineSounds(ResourceLocation engine) {
            return this.setBasicEngineSounds(engine, engine);
        }

        public Builder setBasicEngineSounds(SoundEvent engine) {
            return this.setBasicEngineSounds(engine.m_11660_());
        }

        public Builder setBasicEngineSounds(SoundEvent nonPassengerEngine, SoundEvent passengerEngine) {
            return this.setBasicEngineSounds(nonPassengerEngine.m_11660_(), passengerEngine.m_11660_());
        }

        public Builder setFighterJetSounds(SoundEvent externalAfterBurnerClose, SoundEvent externalAfterBurnerFar, SoundEvent externalRPM, SoundEvent externalWindClose, SoundEvent externalWindFar, SoundEvent cockpitRPM, SoundEvent cockpitAfterBurner, SoundEvent cockpitWindSlow, SoundEvent cockpitWindFast) {
            this.getSounds().addProperty("loopSoundType", "fighter_jet");
            this.getSounds().addProperty("externalAfterBurnerClose", externalAfterBurnerClose.m_11660_().toString());
            this.getSounds().addProperty("externalAfterBurnerFar", externalAfterBurnerFar.m_11660_().toString());
            this.getSounds().addProperty("externalRPM", externalRPM.m_11660_().toString());
            this.getSounds().addProperty("externalWindClose", externalWindClose.m_11660_().toString());
            this.getSounds().addProperty("externalWindFar", externalWindFar.m_11660_().toString());
            this.getSounds().addProperty("cockpitRPM", cockpitRPM.m_11660_().toString());
            this.getSounds().addProperty("cockpitAfterBurner", cockpitAfterBurner.m_11660_().toString());
            this.getSounds().addProperty("cockpitWindSlow", cockpitWindSlow.m_11660_().toString());
            this.getSounds().addProperty("cockpitWindFast", cockpitWindFast.m_11660_().toString());
            return this;
        }

        public Builder setEntityMainHitboxSize(float width, float height) {
            this.setStatFloat("entity_size_xz", width);
            this.setStatFloat("entity_size_y", height);
            return this;
        }

        public Builder setGroundXTilt(float groundXTilt) {
            return this.setStatFloat("groundXTilt", groundXTilt);
        }

        public Builder setRootHitboxNoCollide(boolean rootHitboxNoCollide) {
            return this.setStatBoolean("rootHitboxNoCollide", rootHitboxNoCollide);
        }

        public Builder setHardCodedRotAcc(float roll, float pitch, float yaw, float decel) {
            JsonObject stats = this.getStats();
            UtilParse.writeVec3((JsonObject)stats, (String)"hard_coded_rot_acc", (Vec3)new Vec3((double)pitch, (double)yaw, (double)roll));
            return this.setStatFloat("hard_coded_rot_decel", decel);
        }

        public Builder setPlaneWingArea(float wing_area) {
            return this.setTypedStatFloat("wing_area", wing_area, "plane");
        }

        public Builder setFuselageLiftArea(float fuselage_lift_area) {
            return this.setTypedStatFloat("fuselage_lift_area", fuselage_lift_area, "plane");
        }

        public Builder setPlaneFlapDownAOABias(float flapsAOABias) {
            return this.setTypedStatFloat("flapsAOABias", flapsAOABias, "plane");
        }

        public Builder setAOADragFactor(float aoa_drag_factor) {
            return this.setTypedStatFloat("aoa_drag_factor", aoa_drag_factor, "plane");
        }

        public Builder setCentripetalScale(float centripetal_scale) {
            return this.setTypedStatFloat("centripetal_scale", centripetal_scale, "plane");
        }

        public Builder setPlaneNoseCanAimDown(boolean canAimDown) {
            return this.setTypedStatBoolean("canAimDown", canAimDown, "plane");
        }

        public Builder setPlaneLiftAOAGraph(String wing_lift_k_graph, String fuselage_lift_k_graph) {
            this.setTypedStatString("fuselage_lift_k_graph", fuselage_lift_k_graph, "plane");
            return this.setTypedStatString("wing_lift_k_graph", wing_lift_k_graph, "plane");
        }

        public Builder setPlaneLiftAOAGraph(String wing_lift_k_graph) {
            return this.setPlaneLiftAOAGraph(wing_lift_k_graph, "fuselage");
        }

        public Builder setTurnRateGraph(String turn_rates_graph) {
            return this.setTypedStatString("turn_rates_graph", turn_rates_graph, "plane");
        }

        public Builder setDragAOAGraph(String drag_aoa_graph_key) {
            return this.setTypedStatString("drag_aoa_graph_key", drag_aoa_graph_key, "plane");
        }

        public Builder setWingLiftHitboxNames(String ... wing_lift_hitbox_names) {
            this.getStatsByType("plane").add("wing_lift_hitbox_names", (JsonElement)UtilParse.stringArrayToJsonArray((String[])wing_lift_hitbox_names));
            return this;
        }

        public Builder setHeliHoverMovement(float accForward, float accSide) {
            this.setTypedStatFloat("accForward", accForward, "heli");
            return this.setTypedStatFloat("accSide", accSide, "heli");
        }

        public Builder setHeliLiftFactor(float heliLiftFactor) {
            return this.setTypedStatFloat("heliLiftFactor", heliLiftFactor, "heli");
        }

        public Builder setHeliAlwaysLandingGear(boolean alwaysLandingGear) {
            return this.setTypedStatBoolean("alwaysLandingGear", alwaysLandingGear, "heli");
        }

        public Builder setCarIsTank(boolean isTank) {
            return this.setTypedStatBoolean("isTank", isTank, "car");
        }

        public Builder setIsStationaryRadar(boolean radar) {
            return this.setTypedStatBoolean("isStationaryRadar", radar, "stationary");
        }

        public Builder setUseSpeedScales(boolean horizontal, boolean vertical) {
            this.setStatBoolean("use_vertical_speed_scale", vertical);
            return this.setStatBoolean("use_horizontal_speed_scale", horizontal);
        }

        public Builder setMaxGroundSpeed(float speed) {
            return this.setStatFloat("max_ground_speed", speed);
        }

        public Builder setCruiseSpeed(float speed) {
            return this.setStatFloat("cruise_speed", speed);
        }

        public Builder setPlaneSpeeds(float max_speed, float cruise_speed, float max_takeoff_speed) {
            this.setCruiseSpeed(cruise_speed);
            this.setMaxGroundSpeed(max_takeoff_speed);
            return this.setMaxSpeed(max_speed);
        }

        protected JsonArray getPhysicsComponents() {
            if (!this.getData().has("physics_components")) {
                this.getData().add("physics_components", (JsonElement)new JsonArray());
            }
            return this.getData().get("physics_components").getAsJsonArray();
        }

        public Builder addPhysicsComponent(JsonObject data) {
            this.getPhysicsComponents().add((JsonElement)data);
            return this;
        }

        public Builder setDragArea(float drag_area) {
            return this.setStatFloat("drag_area", drag_area);
        }

        public Builder setBreakDeAcc(float break_deacc_ground, float break_deacc_air) {
            this.setStatFloat("break_deacc_ground", break_deacc_ground);
            return this.setStatFloat("break_deacc_air", break_deacc_air);
        }

        public Builder setMinDriveAcc(float min_drive_acc) {
            return this.setStatFloat("min_drive_acc", min_drive_acc);
        }

        public Builder setBoolean(String key, boolean value) {
            this.getData().addProperty(key, Boolean.valueOf(value));
            return this;
        }

        public Builder setInt(String key, int value) {
            this.getData().addProperty(key, (Number)value);
            return this;
        }

        public Builder setFloat(String key, float value) {
            this.getData().addProperty(key, (Number)Float.valueOf(value));
            return this;
        }

        public Builder setString(String key, String value) {
            this.getData().addProperty(key, value);
            return this;
        }
    }
}

