/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.instance.IRMissileInstance;
import com.onewhohears.dscombat.data.weapon.stats.MissileStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class IRMissileStats
extends MissileStats {
    private final float flareResistance;

    public IRMissileStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        this.flareResistance = UtilParse.getFloatSafe((JsonObject)json, (String)"flareResistance", (float)1.0f);
    }

    @Override
    public JsonPresetType getType() {
        return WeaponType.IR_MISSILE;
    }

    @Override
    public JsonPresetInstance<?> createPresetInstance() {
        return new IRMissileInstance<IRMissileStats>(this);
    }

    public float getFlareResistance() {
        return this.flareResistance;
    }

    @Override
    public void addToolTips(List<Component> tips, boolean advanced) {
        super.addToolTips(tips, advanced);
        tips.add((Component)UtilMCText.translatable((String)"info.dscombat.targets_flying").m_6270_(Style.f_131099_.m_178520_(8388564)));
        if (advanced && this.getFlareResistance() != 0.0f) {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.flare_resistance").m_130946_(": " + this.getFlareResistance()).m_6270_(Style.f_131099_.m_178520_(6266528)));
        }
    }

    @Override
    public String getWeaponTypeCode() {
        return UtilMCText.transString((String)"weapon_code.dscombat.fox2");
    }

    @Override
    public String getDefaultIconLocation() {
        return "dscombat:textures/ui/weapon_icons/ir_missile.png";
    }

    @Override
    public boolean isIRMissile() {
        return true;
    }
}

