/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.parts;

import com.onewhohears.dscombat.common.network.toserver.ToServerGetHookChains;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.ChainHookInstance;
import com.onewhohears.dscombat.data.parts.stats.ChainHookStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilServerPacket;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityChainHook
extends EntityPart<ChainHookStats, ChainHookInstance<ChainHookStats>> {
    public static final double CHAIN_LENGTH = 8.0;
    private final List<ChainConnection> chains = new ArrayList<ChainConnection>();

    public EntityChainHook(EntityType<?> entityType, Level level) {
        super(entityType, level, "chain_hook");
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        ListTag conns = nbt.m_128437_("chains", 10);
        for (int i = 0; i < conns.size(); ++i) {
            CompoundTag tag = conns.m_128728_(i);
            ChainConnection conn = this.fromNBT(tag, this.getWorld());
            if (conn == null) continue;
            this.chains.add(conn);
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag conns = new ListTag();
        for (int i = 0; i < this.chains.size(); ++i) {
            CompoundTag tag = this.chains.get(i).toNBT();
            if (tag == null) continue;
            conns.add((Object)tag);
        }
        nbt.m_128365_("chains", (Tag)conns);
    }

    @Override
    public void m_8119_() {
        if (this.f_19803_ && this.isClientSide()) {
            this.requestChainsFromServer();
        }
        super.m_8119_();
        for (int i = 0; i < this.chains.size(); ++i) {
            ChainConnection chain = this.chains.get(i);
            chain.tick();
            if (this.isClientSide() || !chain.isDisconnected()) continue;
            this.disconnectChain(i--);
        }
    }

    public boolean isClientSide() {
        return this.getWorld().m_5776_();
    }

    @Override
    public Level getWorld() {
        return UtilEntity.getLevel((Entity)this);
    }

    private void requestChainsFromServer() {
        if (!this.isClientSide()) {
            return;
        }
        new ToServerGetHookChains(this).sendToServer();
    }

    public void sendAllVehicleChainsToClient(ServerPlayer reciever) {
        if (this.isClientSide()) {
            return;
        }
        for (ChainConnection chain : this.chains) {
            if (!chain.isVehicleConnection()) continue;
            UtilServerPacket.sendChainAddVehicleTo(chain.getVehicle(), this, reciever);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (!item.m_41619_() && item.m_204117_(ModTags.Items.VEHICLE_CHAIN)) {
            this.handleChainInteract(player, item);
            return InteractionResult.m_19078_((boolean)this.isClientSide());
        }
        if (this.hasChain()) {
            this.disconnectAllChains();
            return InteractionResult.m_19078_((boolean)this.isClientSide());
        }
        return InteractionResult.PASS;
    }

    protected void handleChainInteract(Player player, ItemStack item) {
        if (this.isClientSide()) {
            return;
        }
        if (this.isPlayerConnected(player)) {
            return;
        }
        List vehicles = this.getWorld().m_6443_(EntityVehicle.class, this.m_20191_().m_82400_(8.0), vehicle -> vehicle.isChainConnectedToPlayer(player));
        if (vehicles.size() == 0) {
            this.addPlayerConnection(player);
            return;
        }
        for (EntityVehicle vehicle2 : vehicles) {
            this.addVehicleConnection(null, vehicle2);
        }
    }

    public void addPlayerConnection(Player player) {
        this.chains.add(new ChainConnection(this, player, null));
        if (!this.isClientSide()) {
            UtilServerPacket.sendChainAddPlayer(this, player);
            this.playChainConnectSound();
        }
    }

    public boolean addVehicleConnection(@Nullable Player player, EntityVehicle vehicle) {
        boolean foundConnection;
        block5: {
            block4: {
                if (vehicle.equals(this.getParentVehicle())) {
                    return false;
                }
                foundConnection = false;
                if (player != null) break block4;
                boolean alreadyConnected = false;
                for (ChainConnection chain : this.chains) {
                    if (!chain.isVehicleConnection() || !chain.getVehicle().equals(vehicle)) continue;
                    alreadyConnected = true;
                    break;
                }
                if (alreadyConnected) break block5;
                this.chains.add(new ChainConnection(this, null, vehicle));
                break block5;
            }
            for (ChainConnection chain : this.chains) {
                if (!chain.attachVehicle(player, vehicle)) continue;
                foundConnection = true;
                break;
            }
        }
        if (!this.isClientSide()) {
            UtilServerPacket.sendChainAddVehicle(vehicle, this, player);
            this.playChainConnectSound();
        }
        return foundConnection;
    }

    public void playChainConnectSound() {
        this.getWorld().m_6269_(null, (Entity)this, SoundEvents.f_11745_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void playChainDisconnectSound() {
        this.getWorld().m_6269_(null, (Entity)this, SoundEvents.f_11794_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void disconnectVehicle(EntityVehicle vehicle) {
        for (int i = 0; i < this.chains.size(); ++i) {
            if (!this.chains.get(i).isVehicleConnection() || !this.chains.get(i).getVehicle().equals(vehicle)) continue;
            this.disconnectChain(i--);
        }
    }

    public void disconnectPlayer(Player player) {
        for (int i = 0; i < this.chains.size(); ++i) {
            if (!this.chains.get(i).isPlayerConnected(player)) continue;
            this.disconnectChain(i--);
        }
    }

    public boolean hasChain() {
        return this.chains.size() > 0;
    }

    public void disconnectAllChains() {
        for (int i = 0; i < this.chains.size(); ++i) {
            this.disconnectChain(i--);
        }
    }

    public void disconnectChain(int index) {
        this.chains.get(index).onDisconnect();
        this.chains.remove(index);
    }

    public boolean isPlayerConnected(Player player) {
        for (ChainConnection chain : this.chains) {
            if (!chain.isPlayerConnected(player)) continue;
            return true;
        }
        return false;
    }

    public List<ChainConnection> getConnections() {
        return this.chains;
    }

    @Nullable
    private ChainConnection fromNBT(CompoundTag nbt, Level level) {
        UUID vehicleId = nbt.m_128342_("vehicle");
        if (vehicleId == null) {
            return null;
        }
        return new ChainConnection(this, vehicleId);
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    public PartType getPartType() {
        return PartType.CHAIN_HOOK;
    }

    @Override
    public boolean canGetHurt() {
        return true;
    }

    @Override
    public void m_6074_() {
        this.disconnectAllChains();
        super.m_6074_();
    }

    @Override
    protected void onNoParent() {
        this.disconnectAllChains();
        super.onNoParent();
    }

    public static class ChainConnection {
        private final EntityChainHook hook;
        private Player player;
        private EntityVehicle vehicle;
        private UUID vehicleUUID;
        private int vehicleId = -1;

        private ChainConnection(EntityChainHook hook, @Nullable Player player, @Nullable EntityVehicle vehicle) {
            this.hook = hook;
            this.player = player;
            this.vehicle = vehicle;
            if (vehicle != null) {
                this.vehicleUUID = vehicle.m_20148_();
                this.vehicleId = vehicle.m_19879_();
            }
        }

        private ChainConnection(EntityChainHook hook, UUID vehicleUUID) {
            this.hook = hook;
            this.vehicleUUID = vehicleUUID;
        }

        private ChainConnection(EntityChainHook hook, int vehicleId) {
            this.hook = hook;
            this.vehicleId = vehicleId;
        }

        @Nullable
        private CompoundTag toNBT() {
            if (!this.isVehicleConnection()) {
                return null;
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("vehicle", this.vehicleUUID);
            return tag;
        }

        protected void tickPhysics() {
            if (this.getVehicle() == null) {
                return;
            }
            EntityVehicle parent = this.hook.getParentVehicle();
            if (parent == null) {
                return;
            }
            Vec3 vehicleHookDiff = this.hook.m_20182_().m_82546_(this.getVehicle().m_20182_());
            double distance = vehicleHookDiff.m_82553_();
            if (distance > 7.5 || !parent.isOnGround() && !this.getVehicle().isOnGround()) {
                parent.addForceMomentToClient(this.getVehicle().getWeightForce(), Vec3.f_82478_);
            }
            if (distance <= 8.0) {
                return;
            }
            double fraction = (distance - 8.0) / distance;
            double yMove = vehicleHookDiff.f_82480_ * fraction;
            if (parent.isOnGround() && this.getVehicle().isOnGround()) {
                yMove = 0.0;
            }
            Vec3 move = new Vec3(vehicleHookDiff.f_82479_ * fraction, yMove, vehicleHookDiff.f_82481_ * fraction);
            if (this.getVehicle().isOnGround()) {
                double speed = (double)(this.getVehicle().getXZSpeed() * (float)this.getVehicle().getXZSpeedDir()) + move.m_165924_();
                this.getVehicle().m_20256_(move.m_82541_().m_82490_(speed));
            } else {
                this.getVehicle().m_20256_(this.getVehicle().m_20184_().m_82549_(move));
            }
            this.getVehicle().m_6478_(MoverType.SELF, move);
            if (move.m_165925_() > 0.01) {
                float turn = Mth.m_14148_((float)this.getVehicle().m_146908_(), (float)UtilAngles.getYaw((Vec3)move), (float)this.getVehicle().getMaxDeltaYaw());
                this.getVehicle().m_146922_(turn);
            }
        }

        protected double moveComponent(double diff, double fraction) {
            return diff * fraction;
        }

        public void tick() {
            if (this.isVehicleConnection()) {
                this.tickPhysics();
                return;
            }
        }

        private void onDisconnect() {
            if (this.getVehicle() != null) {
                this.getVehicle().disconnectChain();
                if (!this.hook.isClientSide()) {
                    Containers.m_18992_((Level)this.hook.getWorld(), (double)this.hook.m_20185_(), (double)this.hook.m_20186_(), (double)this.hook.m_20189_(), (ItemStack)Items.f_42026_.m_7968_());
                    UtilServerPacket.sendChainDisconnectVehicle(this.getVehicle(), this.hook);
                }
            } else if (this.player != null && !this.hook.isClientSide()) {
                UtilServerPacket.sendChainDisconnectPlayer(this.hook, this.player);
            }
            if (!this.hook.isClientSide()) {
                this.hook.playChainDisconnectSound();
            }
            this.resetVehicle();
            this.player = null;
        }

        public boolean attachVehicle(Player player, EntityVehicle vehicle) {
            if (!this.canAttachVehicle(player, vehicle)) {
                return false;
            }
            this.player = null;
            this.vehicleId = vehicle.m_19879_();
            this.vehicleUUID = vehicle.m_20148_();
            this.vehicle = vehicle;
            this.vehicle.chainToHook(this.hook);
            return true;
        }

        public void resetVehicle() {
            this.vehicle = null;
            this.vehicleUUID = null;
            this.vehicleId = -1;
        }

        public boolean canAttachVehicle(Player player, EntityVehicle vehicle) {
            return this.isPlayerConnected(player) && vehicle.getChainHolderHook() == null;
        }

        public boolean isPlayerConnected(Player player) {
            return this.isPlayerConnection() && this.getPlayer().equals((Object)player);
        }

        @Nullable
        public Player getPlayer() {
            return this.player;
        }

        @Nullable
        public EntityVehicle getVehicle() {
            if (this.vehicle == null) {
                if (this.vehicleUUID != null && !this.hook.isClientSide()) {
                    Entity entity = ((ServerLevel)this.hook.getWorld()).m_8791_(this.vehicleUUID);
                    if (!(entity instanceof EntityVehicle)) {
                        this.resetVehicle();
                        return null;
                    }
                    EntityVehicle v = (EntityVehicle)entity;
                    this.vehicle = v;
                    this.vehicleId = this.vehicle.m_19879_();
                    this.vehicle.chainToHook(this.hook);
                } else if (this.vehicleId != -1 && this.hook.isClientSide()) {
                    Entity entity = this.hook.getWorld().m_6815_(this.vehicleId);
                    if (!(entity instanceof EntityVehicle)) {
                        this.resetVehicle();
                        return null;
                    }
                    EntityVehicle v = (EntityVehicle)entity;
                    this.vehicle = v;
                    this.vehicle.chainToHook(this.hook);
                }
            }
            return this.vehicle;
        }

        @Nullable
        public Entity getEntity() {
            return this.getVehicle() != null ? this.getVehicle() : this.player;
        }

        public boolean isDisconnected() {
            return this.getVehicle() == null && this.player == null || this.isVehicleDead() || this.isVehicleDisconnected() || this.isPlayerTooFar();
        }

        public boolean isPlayerConnection() {
            return this.player != null;
        }

        public boolean isVehicleConnection() {
            return this.getVehicle() != null;
        }

        public boolean isVehicleDead() {
            return this.isVehicleConnection() && this.getVehicle().m_213877_();
        }

        public boolean isVehicleDisconnected() {
            return this.isVehicleConnection() && this.getVehicle().getChainHolderHook() == null;
        }

        public boolean isPlayerTooFar() {
            return this.isPlayerConnection() && (double)this.hook.m_20270_((Entity)this.player) > 8.0;
        }

        @Nullable
        public UUID getVehicleUUID() {
            return this.vehicleUUID;
        }
    }

    public static enum ChainUpdateType {
        CHAIN_ADD_VEHICLE,
        CHAIN_ADD_PLAYER,
        CHAIN_DISCONNECT_PLAYER,
        CHAIN_DISCONNECT_VEHICLE,
        VEHICLE_ADD_PLAYER;

    }
}

