/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.parts;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.model.obj.ObjRadarModel;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.client.PartAssets;
import com.onewhohears.dscombat.data.parts.client.PartClientStats;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetAssetReader;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.entity.CustomAnimEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityPart<P extends PartStats, I extends PartInstance<P>>
extends CustomAnimEntity<P, PartClientStats> {
    public static final EntityDataAccessor<Vec3> POS = SynchedEntityData.m_135353_(EntityPart.class, DataSerializers.VEC3);
    public static final EntityDataAccessor<String> SLOT_ID = SynchedEntityData.m_135353_(EntityPart.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(EntityPart.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float z_rot;
    protected double renderSqrDistance = 0.0;

    protected EntityPart(EntityType<?> entityType, Level level, String defaultPresetId) {
        super(entityType, level, defaultPresetId);
        if (this.isClientSide() && this.shouldRender()) {
            double dist = this.getClientRenderDistance();
            this.renderSqrDistance = dist * dist;
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(POS, (Object)Vec3.f_82478_);
        this.f_19804_.m_135372_(SLOT_ID, (Object)"");
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRelativePos(UtilParse.readVec3((CompoundTag)compound, (String)"relpos"));
        this.setSlotId(compound.m_128461_("slotid"));
        this.setHealth(compound.m_128457_("health"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        UtilParse.writeVec3((CompoundTag)compound, (Vec3)this.getRelativePos(), (String)"relpos");
        compound.m_128359_("slotid", this.getSlotId());
        compound.m_128350_("health", this.getHealth());
    }

    public void init() {
        PartSlot ps = this.getSlot();
        if (ps != null) {
            this.z_rot = ps.getZRot();
            this.setRelativePos(ps.getRelPos());
        }
    }

    public void m_8119_() {
        if (this.f_19803_) {
            this.init();
        }
        super.m_8119_();
        if (!this.isClientSide() && this.f_19797_ > 10 && this.m_20202_() == null) {
            this.onNoParent();
        }
    }

    protected void onNoParent() {
        this.m_146870_();
    }

    public Vec3 getRelativePos() {
        return (Vec3)this.f_19804_.m_135370_(POS);
    }

    public void setRelativePos(Vec3 pos) {
        this.f_19804_.m_135381_(POS, (Object)pos);
    }

    public String getSlotId() {
        return (String)this.f_19804_.m_135370_(SLOT_ID);
    }

    public void setSlotId(String id) {
        this.f_19804_.m_135381_(SLOT_ID, (Object)id);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.canGetHurt()) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle != null) {
            amount = vehicle.calcDamageToRider(source, amount);
        }
        this.addHealth(-amount);
        if (this.getHealth() <= 0.0f) {
            this.m_6074_();
        }
        return true;
    }

    public void onDeath() {
        if (!this.canGetHurt()) {
            return;
        }
        Entity entity = this.m_20202_();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle plane = (EntityVehicle)entity;
        plane.partsManager.killPartInSlot(this.getSlotId());
    }

    public void m_6074_() {
        this.onDeath();
        super.m_6074_();
    }

    @Nullable
    public EntityVehicle getParentVehicle() {
        Entity entity = this.m_20202_();
        if (entity instanceof EntityVehicle) {
            EntityVehicle vehicle = (EntityVehicle)entity;
            return vehicle;
        }
        return null;
    }

    public abstract boolean shouldRender();

    protected double getClientRenderDistance() {
        return (Double)Config.CLIENT.renderOtherExternalPartDistance.get();
    }

    public boolean m_6783_(double dist) {
        return this.shouldRender() && dist <= this.renderSqrDistance;
    }

    public float getZRot() {
        return this.z_rot;
    }

    public boolean m_6087_() {
        return this.canGetHurt();
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public abstract PartType getPartType();

    public boolean isPilotSeat() {
        return PartSlot.isPilotSeat(this.getSlotId());
    }

    public boolean isCoPilotSeat() {
        return PartSlot.isCoPilotSeat(this.getSlotId());
    }

    public boolean isSeat() {
        return false;
    }

    public boolean isTurret() {
        return false;
    }

    public boolean canPassengerShootParentWeapon() {
        return this.isPilotSeat() || this.isCoPilotSeat();
    }

    public boolean m_7307_(Entity entity) {
        if (entity == null) {
            return false;
        }
        LivingEntity c = entity.m_6688_();
        if (c != null) {
            return this.m_20031_(c.m_5647_());
        }
        return super.m_7307_(entity);
    }

    public boolean m_20031_(Team team) {
        if (team == null) {
            return false;
        }
        Entity v = this.m_20202_();
        if (v == null) {
            return false;
        }
        LivingEntity c = v.m_6688_();
        if (c != null) {
            return team.m_83536_(c.m_5647_());
        }
        return super.m_20031_(team);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity v = this.m_20202_();
        if (v == null) {
            return null;
        }
        return v.m_6688_();
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue();
    }

    public void setHealth(float health) {
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(Math.max(0.0f, health)));
    }

    public void addHealth(float health) {
        this.setHealth(this.getHealth() + health);
    }

    public abstract boolean canGetHurt();

    @NotNull
    protected AABB m_142242_() {
        if (!this.isStatsHolderLoaded()) {
            return super.m_142242_();
        }
        double pX = this.m_20185_();
        double pY = this.m_20186_();
        double pZ = this.m_20189_();
        EntityDimensions d = ((PartStats)this.getStats()).getEntityDimensions();
        double f = d.f_20377_ / 2.0f;
        double f1 = d.f_20378_;
        if (Mth.m_14154_((float)this.getZRot()) > 90.0f) {
            f1 *= -1.0;
        }
        return new AABB(pX - f, pY, pZ - f, pX + f, pY + f1, pZ + f);
    }

    public ObjRadarModel.MastType getVehicleMastType() {
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle == null) {
            return ObjRadarModel.MastType.NONE;
        }
        return vehicle.getMastType();
    }

    @Nullable
    public PartSlot getSlot() {
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle == null) {
            return null;
        }
        return vehicle.partsManager.getSlot(this.getSlotId());
    }

    @Nullable
    public I getPartInstance() {
        PartSlot slot = this.getSlot();
        if (slot == null) {
            return null;
        }
        if (slot.getPartData() == null) {
            return null;
        }
        return (I)((Object)slot.getPartData());
    }

    @Nullable
    public String getAssetId() {
        return this.getStatsId();
    }

    @Nullable
    public JsonPresetAssetReader<PartClientStats> getClientPresets() {
        if (!this.isClientSide()) {
            return null;
        }
        return PartAssets.get();
    }

    @NotNull
    public JsonPresetReloadListener<P> getPresets() {
        return PartPresets.get();
    }

    public Level getWorld() {
        return UtilEntity.getLevel((Entity)this);
    }
}

