/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.parts;

import com.onewhohears.dscombat.client.event.ClientInputEventHandlers;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.SeatInstance;
import com.onewhohears.dscombat.data.parts.stats.SeatStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityRidablePart<P extends SeatStats, I extends SeatInstance<P>>
extends EntityPart<P, I> {
    public EntityRidablePart(EntityType<?> type, Level level, String defaultPreset) {
        super(type, level, defaultPreset);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isClientSide() && this.getWorld().m_46469_().m_46207_(DSCGameRules.MOBS_RIDE_VEHICLES)) {
            this.tickRideCollision();
        }
    }

    protected void tickRideCollision() {
        if (this.isPilotSeat()) {
            return;
        }
        if (this.getPassenger() != null) {
            return;
        }
        Entity entity = this.m_20202_();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        if ((double)vehicle.getXZSpeed() > 0.1) {
            return;
        }
        List entities = this.getWorld().m_6249_((Entity)this, this.m_20191_().m_82400_(0.1), this.getRidePredicate());
        for (Entity entity2 : entities) {
            if (!entity2.m_20329_((Entity)this)) continue;
            return;
        }
    }

    protected Predicate<? super Entity> getRidePredicate() {
        return entity -> {
            if (this.equals(entity.m_20201_())) {
                return false;
            }
            if (entity.m_5833_()) {
                return false;
            }
            return entity instanceof Mob;
        };
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.isClientSide()) {
            if (player.m_20159_()) {
                return InteractionResult.PASS;
            }
            if (player.m_20329_((Entity)this)) {
                return InteractionResult.CONSUME;
            }
            if (this.m_20202_() != null && player.m_20329_(this.m_20202_())) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean m_6087_() {
        return true;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        Entity entity = this.m_20202_();
        if (!(entity instanceof EntityVehicle)) {
            super.m_19956_(passenger, moveFunction);
            return;
        }
        EntityVehicle craft = (EntityVehicle)entity;
        if (this.f_19797_ % 20 == 0 && passenger instanceof Player) {
            Player player = (Player)passenger;
            if (craft.nightVisionHud) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 240, 0, false, false));
            }
            if (((VehicleStats)craft.getStats()).isSub()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 240, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 240, 0, false, false));
            }
        }
        Vec3 pos = this.m_20182_().m_82549_(this.getPassengerRelPos(passenger, craft));
        moveFunction.m_20372_(passenger, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    protected Vec3 getPassengerRelPos(Entity passenger, EntityVehicle craft) {
        QuaternionF q = craft.getQBySide();
        double offset = this.m_6048_() + passenger.m_6049_() + (double)passenger.m_20192_();
        return UtilAngles.rotateVector((Vec3)new Vec3(0.0, offset, 0.0), (QuaternionF)q).m_82492_(0.0, (double)passenger.m_20192_(), 0.0);
    }

    protected void m_20348_(Entity passenger) {
        if (!this.isClientSide()) {
            EntityVehicle vehicle = this.getParentVehicle();
            if (vehicle != null && !vehicle.hasOwner()) {
                vehicle.setOwner(passenger);
            }
        } else {
            ClientInputEventHandlers.onEntityMountVehicle(passenger);
        }
        super.m_20348_(passenger);
    }

    public boolean m_7310_(Entity passenger) {
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle == null) {
            return false;
        }
        if (!vehicle.hasPermission(passenger)) {
            return false;
        }
        if (passenger instanceof LivingEntity) {
            return this.getPassenger() == null;
        }
        return false;
    }

    protected boolean m_7341_(Entity entityIn) {
        return entityIn instanceof EntityVehicle;
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (this.isClientSide()) {
            return;
        }
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle == null) {
            return;
        }
        vehicle.onSeatDismount(passenger);
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity entity) {
        int minY = this.getWorld().m_141937_() + 4;
        EntityHitResult ehr = UtilEntity.getEntityHitResultAtClip((Level)this.getWorld(), (Entity)entity, (Vec3)this.m_20182_().m_82520_(0.0, 10.0, 0.0), (Vec3)this.m_20182_(), (AABB)entity.m_20191_(), e -> !e.equals((Object)entity), (float)0.3f);
        Vec3 dis = ehr != null ? ehr.m_82450_().m_82520_(0.0, 0.2, 0.0) : super.m_7688_(entity);
        if (dis.m_7098_() < (double)minY) {
            dis = new Vec3(dis.m_7096_(), (double)minY, dis.m_7094_());
        }
        return dis;
    }

    @Nullable
    public Player getPlayer() {
        List list = this.m_20197_();
        for (Entity e : list) {
            if (!(e instanceof Player)) continue;
            Player p = (Player)e;
            return p;
        }
        return null;
    }

    @Nullable
    public LivingEntity getPassenger() {
        List list = this.m_20197_();
        for (Entity e : list) {
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity l = (LivingEntity)e;
            return l;
        }
        return null;
    }

    @Override
    @Nullable
    public LivingEntity m_6688_() {
        Player p = this.getPlayer();
        if (p == null) {
            return super.m_6688_();
        }
        return p;
    }

    public boolean isPlayerOrBotRiding() {
        if (this.getPlayer() != null) {
            return true;
        }
        return this.hasAIUsingTurret();
    }

    public void explode(DamageSource source, Entity parent) {
        this.getWorld().m_254877_(parent, source, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, true, Level.ExplosionInteraction.TNT);
    }

    public boolean hasAIUsingTurret() {
        return false;
    }

    public double m_6048_() {
        return this.getPassengerOffsets().f_82480_;
    }

    @Override
    public boolean shouldRender() {
        return false;
    }

    @Override
    public PartType getPartType() {
        return PartType.SEAT;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public boolean canGetHurt() {
        return false;
    }

    public float getCameraYOffset() {
        return 0.0f;
    }

    @Override
    public boolean isSeat() {
        return true;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6084_() {
        return false;
    }

    public boolean canEject() {
        SeatInstance data = (SeatInstance)((Object)this.getPartInstance());
        if (data == null) {
            return false;
        }
        return data.canEject();
    }

    public void useEject() {
        SeatInstance data = (SeatInstance)((Object)this.getPartInstance());
        if (data == null) {
            return;
        }
        data.setCanEject(false);
    }

    public Vec3 getPassengerOffsets() {
        return ((SeatStats)this.getStats()).getPassengerOffsets();
    }
}

