/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityHelicopter
extends EntityVehicle {
    private int altitudeWarningTicks;
    private double rotorPower = 0.0;

    public double getRotorPower() {
        return this.rotorPower;
    }

    public EntityHelicopter(EntityType<? extends EntityHelicopter> entity, Level level, String defaultPreset) {
        super(entity, level, defaultPreset);
    }

    @Override
    public VehicleType getVehicleType() {
        return VehicleType.HELICOPTER;
    }

    @Override
    public double getDriveAcc() {
        return 0.0;
    }

    @Override
    public void calcAirMovement(QuaternionF q) {
        super.calcAirMovement(q);
        if (this.inputs.special && this.isOperational()) {
            this.flatten(q, this.getMaxDeltaPitch(), this.getMaxDeltaRoll(), false);
            float max_th = (float)UtilAngles.getYawAxis((QuaternionF)q).f_82480_ * this.getMaxPushThrust();
            float yForceNoLift = (float)(-(this.getWeightForce().f_82480_ + this.addForceBetweenTicks.f_82480_));
            double liftMul = this.computeLiftMultiplier(q);
            float effMaxTh = (float)((double)max_th * liftMul);
            if (effMaxTh != 0.0f) {
                this.inputs.setThrottleOverride(yForceNoLift / effMaxTh, this);
            }
            double hoverD = (Double)Config.SERVER.heliHoverDamping.get();
            this.m_20256_(this.m_20184_().m_82490_(hoverD));
        } else {
            double hMax;
            Vec3 dm = this.m_20184_();
            double lateral = (Double)Config.SERVER.heliLateralDampingXZ.get();
            double igeExtra = (Double)Config.SERVER.igeExtraLateralDamping.get();
            if (igeExtra > 0.0 && (hMax = ((Double)Config.SERVER.igeDampingMaxHeight.get()).doubleValue()) > 0.0) {
                int limit = (int)Math.ceil(hMax) + 1;
                int aglBlocks = UtilVehicleEntity.getDistFromGround((Entity)this, limit, true);
                double h = Math.min((double)aglBlocks, hMax);
                double f = Math.max(0.0, 1.0 - h / hMax);
                double extraMul = 1.0 - igeExtra * f;
                lateral *= extraMul;
            }
            this.m_20256_(dm.m_82542_(lateral, 1.0, lateral));
        }
    }

    @Override
    public Vec3 getThrustForce(QuaternionF q) {
        Vec3 direction = UtilAngles.getYawAxis((QuaternionF)q);
        double liftMul = this.computeLiftMultiplier(q);
        return direction.m_82490_(this.getPushThrustMag() * liftMul);
    }

    @Override
    public float getMaxPushThrust() {
        return this.getMaxSpinThrust() * (float)this.getFluidDensity() * ((VehicleStats)this.getStats()).asHeli().heliLiftFactor;
    }

    @Override
    public double getPushThrustMag() {
        if (this.getCurrentFuel() <= 0.0f || !this.isOperational()) {
            return 0.0;
        }
        return this.rotorPower * (double)this.getMaxPushThrust();
    }

    protected double computeLiftMultiplier(QuaternionF q) {
        double maxH;
        double mult = 1.0;
        if (((Boolean)Config.SERVER.enableGroundEffect.get()).booleanValue() && (maxH = ((Double)Config.SERVER.groundEffectMaxHeight.get()).doubleValue()) > 0.0) {
            int limit = (int)Math.ceil(maxH) + 1;
            int aglBlocks = UtilVehicleEntity.getDistFromGround((Entity)this, limit, true);
            double h = Math.min((double)aglBlocks, maxH);
            double factor = Math.max(0.0, 1.0 - h / maxH);
            double ge = (Double)Config.SERVER.groundEffectStrength.get() * factor;
            mult += ge;
        }
        if (((Boolean)Config.SERVER.enableTranslationalLift.get()).booleanValue()) {
            Vec3 dm = this.m_20184_();
            double speedXZ = Math.sqrt(dm.f_82479_ * dm.f_82479_ + dm.f_82481_ * dm.f_82481_);
            double full = Math.max(1.0E-6, (Double)Config.SERVER.translationalLiftFullSpeed.get());
            double factor = Math.min(1.0, speedXZ / full);
            double tl = (Double)Config.SERVER.translationalLiftMaxBonus.get() * factor;
            mult += tl;
        }
        if (((Boolean)Config.SERVER.enableVRS.get()).booleanValue()) {
            Vec3 dm = this.m_20184_();
            double vy = dm.f_82480_;
            double descent = vy < 0.0 ? -vy : 0.0;
            double speedXZ = Math.sqrt(dm.f_82479_ * dm.f_82479_ + dm.f_82481_ * dm.f_82481_);
            double trigger = (Double)Config.SERVER.vrsDescentTrigger.get();
            double horizMax = (Double)Config.SERVER.vrsHorizMaxSpeed.get();
            if (descent > trigger && speedXZ < horizMax) {
                double severity = Math.min(1.0, (descent - trigger) / Math.max(1.0E-6, trigger));
                double penalty = (Double)Config.SERVER.vrsMaxPenalty.get() * severity;
                mult *= Math.max(0.0, 1.0 - penalty);
            }
        }
        if (Double.isNaN(mult) || Double.isInfinite(mult)) {
            return 1.0;
        }
        return Math.max(0.0, mult);
    }

    @Override
    public void addControllingTorques(QuaternionF q) {
        double gain;
        double factor;
        double full;
        double ydGain;
        boolean scaleTorque = (Boolean)Config.SERVER.scaleTorqueWithRotorPower.get();
        if (scaleTorque) {
            if (this.canTurnViaTorque()) {
                minAuth = (Double)Config.SERVER.minControlAuthorityAtIdle.get();
                authority = Math.max(0.0, Math.min(1.0, minAuth + (1.0 - minAuth) * this.rotorPower));
                float torqueScale = (float)authority;
                if (this.canControlPitch()) {
                    if (this.isHardCodedRotAcc()) {
                        this.hardCodedAccPitch();
                    } else {
                        this.addMomentX(this.inputs.pitch * this.getPitchTorque() * torqueScale, true);
                    }
                }
                if (this.canControlYaw()) {
                    if (this.isHardCodedRotAcc()) {
                        this.hardCodedAccYaw();
                    } else {
                        this.addMomentY(this.inputs.yaw * this.getYawTorque() * torqueScale, true);
                    }
                }
                if (this.canControlRoll()) {
                    if (this.isHardCodedRotAcc()) {
                        this.hardCodedAccRoll();
                    } else if (this.inputs.bothRoll) {
                        this.flatten(q, 0.0f, this.getMaxDeltaRoll(), false);
                    } else {
                        this.addMomentZ(this.inputs.roll * this.getRollTorque() * torqueScale, true);
                    }
                }
            }
        } else {
            super.addControllingTorques(q);
            if (!this.isOperational()) {
                return;
            }
            if (!((Boolean)Config.SERVER.scaleAuthorityPreClamp.get()).booleanValue() && (authority = Math.max(0.0, Math.min(1.0, (minAuth = ((Double)Config.SERVER.minControlAuthorityAtIdle.get()).doubleValue()) + (1.0 - minAuth) * this.rotorPower))) < 1.0) {
                Vec3 cm = this.getControlMoment();
                if (cm.f_82479_ != 0.0 || cm.f_82480_ != 0.0 || cm.f_82481_ != 0.0) {
                    this.setControlMoment(cm.m_82490_(authority));
                }
            }
        }
        if (((Boolean)Config.SERVER.enableAntiTorque.get()).booleanValue()) {
            double rollCoeff;
            double coeff = (Double)Config.SERVER.antiTorqueCoeff.get();
            double dir = (Double)Config.SERVER.antiTorqueDirection.get();
            double thrust = this.getPushThrustMag() * this.computeLiftMultiplier(q);
            double yawMoment = dir * coeff * thrust;
            this.addMoment(new Vec3(0.0, yawMoment, 0.0), false, true);
            if (((Boolean)Config.SERVER.enableTailRotorRollCoupling.get()).booleanValue() && (rollCoeff = ((Double)Config.SERVER.tailRotorRollCoeff.get()).doubleValue()) != 0.0) {
                this.addMoment(new Vec3(0.0, 0.0, -yawMoment * rollCoeff), false, true);
            }
        }
        if ((ydGain = ((Double)Config.SERVER.yawDamperGain.get()).doubleValue()) > 0.0) {
            Vec3 I = this.getTotalRotInertia();
            Vec3 av = this.getAngularVel();
            this.addMoment(new Vec3(0.0, -av.f_82480_ * ydGain * I.f_82480_, 0.0), false, true);
        }
        if (((Boolean)Config.SERVER.enableETLPitchUp.get()).booleanValue()) {
            Vec3 dm = this.m_20184_();
            double speedXZ = Math.sqrt(dm.f_82479_ * dm.f_82479_ + dm.f_82481_ * dm.f_82481_);
            full = Math.max(1.0E-6, (Double)Config.SERVER.translationalLiftFullSpeed.get());
            factor = Math.min(1.0, speedXZ / full);
            gain = (Double)Config.SERVER.etlPitchGain.get();
            if (gain != 0.0 && factor > 0.0) {
                this.addMoment(new Vec3(-gain * factor * this.getTotalRotInertia().f_82479_, 0.0, 0.0), false, true);
            }
        }
        if (((Boolean)Config.SERVER.enableETLTrimAssist.get()).booleanValue()) {
            Vec3 dm = this.m_20184_();
            double speedXZ = Math.sqrt(dm.f_82479_ * dm.f_82479_ + dm.f_82481_ * dm.f_82481_);
            full = Math.max(1.0E-6, (Double)Config.SERVER.translationalLiftFullSpeed.get());
            factor = Math.min(1.0, speedXZ / full);
            gain = (Double)Config.SERVER.etlTrimGain.get();
            if (gain != 0.0 && factor > 0.0) {
                this.addMoment(new Vec3(gain * factor * this.getTotalRotInertia().f_82479_, 0.0, 0.0), false, true);
            }
        }
    }

    @Override
    public float getControlMaxDeltaPitch() {
        float base = super.getControlMaxDeltaPitch();
        if (!((Boolean)Config.SERVER.scaleAuthorityPreClamp.get()).booleanValue()) {
            return base;
        }
        double minAuth = (Double)Config.SERVER.minControlAuthorityAtIdle.get();
        double authority = Math.max(0.0, Math.min(1.0, minAuth + (1.0 - minAuth) * this.rotorPower));
        return (float)((double)base * authority);
    }

    @Override
    public float getControlMaxDeltaYaw() {
        float base = super.getControlMaxDeltaYaw();
        if (!((Boolean)Config.SERVER.scaleAuthorityPreClamp.get()).booleanValue()) {
            return base;
        }
        double minAuth = (Double)Config.SERVER.minControlAuthorityAtIdle.get();
        double authority = Math.max(0.0, Math.min(1.0, minAuth + (1.0 - minAuth) * this.rotorPower));
        return (float)((double)base * authority);
    }

    @Override
    public float getControlMaxDeltaRoll() {
        float base = super.getControlMaxDeltaRoll();
        if (!((Boolean)Config.SERVER.scaleAuthorityPreClamp.get()).booleanValue()) {
            return base;
        }
        double minAuth = (Double)Config.SERVER.minControlAuthorityAtIdle.get();
        double authority = Math.max(0.0, Math.min(1.0, minAuth + (1.0 - minAuth) * this.rotorPower));
        return (float)((double)base * authority);
    }

    @Deprecated
    public float getAccForward() {
        return ((VehicleStats)this.getStats()).asHeli().accForward;
    }

    @Deprecated
    public float getAccSide() {
        return ((VehicleStats)this.getStats()).asHeli().accSide;
    }

    @Override
    public boolean isCustomBoundingBox() {
        return true;
    }

    @Override
    public boolean canToggleLandingGear() {
        return !((VehicleStats)this.getStats()).asHeli().alwaysLandingGear;
    }

    @Override
    public boolean canHover() {
        return true;
    }

    @Override
    public boolean cutThrottleOnNoPilot() {
        return false;
    }

    @Override
    protected float calcDamageFromBullet(DamageSource source, float amount) {
        return amount * DSCGameRules.getBulletDamageHeliFactor(this.getWorld());
    }

    @Override
    public double getMaxSpeedFactor() {
        return super.getMaxSpeedFactor() * (Double)Config.SERVER.heliSpeedFactor.get();
    }

    @Override
    public int getAltitudeWarningTicks() {
        return this.altitudeWarningTicks;
    }

    @Override
    public void calcMoveStatsPre(QuaternionF q) {
        double step;
        super.calcMoveStatsPre(q);
        double goal = this.getCurrentThrottle();
        double up = (Double)Config.SERVER.rotorSpoolUpRate.get();
        double down = (Double)Config.SERVER.rotorSpoolDownRate.get();
        double d = step = goal >= this.rotorPower ? up : down;
        if (step < 0.0) {
            step = 0.0;
        }
        if (step > 1.0) {
            step = 1.0;
        }
        if (this.rotorPower < goal) {
            this.rotorPower = Math.min(goal, this.rotorPower + step);
        } else if (this.rotorPower > goal) {
            this.rotorPower = Math.max(goal, this.rotorPower - step);
        }
        this.altitudeWarningTicks = this.m_20184_().f_82480_ < 0.0 && this.getAltitude() < 40.0 ? ++this.altitudeWarningTicks : 0;
    }

    @Override
    public boolean canDriveOnGround() {
        return false;
    }

    @Override
    public double getMaxClimbSpeed() {
        return 1.0;
    }
}

