/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.BunkerBusterStats;
import com.onewhohears.dscombat.entity.weapon.EntityBomb;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EntityBunkerBuster<T extends BunkerBusterStats>
extends EntityBomb<T> {
    public static final EntityDataAccessor<Integer> BLOCK_STRENGTH = SynchedEntityData.m_135353_(EntityBunkerBuster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityBunkerBuster(EntityType<? extends EntityBunkerBuster<?>> type, Level level, String defaultWeaponId) {
        super((EntityType<? extends EntityBomb<?>>)type, level, defaultWeaponId);
        if (this.getWeaponStats() != null) {
            this.setBlockStrength(((BunkerBusterStats)((Object)this.getWeaponStats())).getBlockStrength());
        }
    }

    @Override
    public WeaponType getWeaponType() {
        return WeaponType.BUNKER_BUSTER;
    }

    @Override
    protected BlockHitResult checkBlockCollide() {
        Iterator it = this.getWorld().m_186434_((Entity)this, this.m_20191_().m_82369_(this.m_20184_())).iterator();
        Entity owner = this.m_19749_();
        while (it.hasNext()) {
            VoxelShape voxel = (VoxelShape)it.next();
            BlockPos pos = UtilGeometry.toBlockPos((Vec3)voxel.m_83215_().m_82399_());
            BlockState state = this.getWorld().m_8055_(pos);
            int hit_block_strength = this.getBlockStrength(pos, state);
            if (this.getBlockStrength() >= hit_block_strength && UtilVehicleEntity.weaponHasPermissionToBreak(pos, state, this.getWorld(), owner)) {
                this.getWorld().m_46953_(pos, true, (Entity)this);
                this.reduceBlockStrength(hit_block_strength);
                continue;
            }
            return new BlockHitResult(voxel.m_83215_().m_82399_(), this.m_6350_(), pos, false);
        }
        Vec3 p = this.m_20182_().m_82549_(this.m_20184_());
        return BlockHitResult.m_82426_((Vec3)p, (Direction)this.m_6350_(), (BlockPos)UtilGeometry.toBlockPos((Vec3)p));
    }

    protected int getBlockStrength(BlockPos pos, BlockState state) {
        if (state.m_60713_(Blocks.f_50752_)) {
            return Integer.MAX_VALUE;
        }
        if (state.m_204336_(ModTags.Blocks.ABSORBENT)) {
            return 50;
        }
        return (int)state.m_60734_().m_7325_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLOCK_STRENGTH, (Object)0);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setBlockStrength(compound.m_128451_("blockStrength"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("blockStrength", this.getBlockStrength());
    }

    public int getBlockStrength() {
        return (Integer)this.f_19804_.m_135370_(BLOCK_STRENGTH);
    }

    public void setBlockStrength(int block_strength) {
        this.f_19804_.m_135381_(BLOCK_STRENGTH, (Object)block_strength);
    }

    public void reduceBlockStrength(int num) {
        this.setBlockStrength(Math.max(this.getBlockStrength() - num, 0));
    }
}

