/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.forge;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.DSCombatMod;
import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.client.event.ClientEventHandlers;
import com.onewhohears.dscombat.client.event.DSCEntityRenderers;
import com.onewhohears.dscombat.data.forge.BlockTagGen;
import com.onewhohears.dscombat.data.forge.DSCRecipeGenerator;
import com.onewhohears.dscombat.data.forge.DamageTypeTagGen;
import com.onewhohears.dscombat.data.forge.EntityTypeTagGen;
import com.onewhohears.dscombat.data.forge.FluidTagGen;
import com.onewhohears.dscombat.data.forge.ItemTagGen;
import com.onewhohears.dscombat.data.parts.PartPresetGenerator;
import com.onewhohears.dscombat.data.parts.client.PartClientPresetGenerator;
import com.onewhohears.dscombat.data.radar.RadarPresetGenerator;
import com.onewhohears.dscombat.data.sound.forge.DSCSoundDefinitionGenImpl;
import com.onewhohears.dscombat.data.vehicle.VehiclePresetGenerator;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientPresetGenerator;
import com.onewhohears.dscombat.data.weapon.WeaponPresetGenerator;
import com.onewhohears.dscombat.data.weapon.client.WeaponClientPresetGenerator;
import com.onewhohears.dscombat.init.ModCMTabs;
import com.onewhohears.dscombat.init.ModDamageTypes;
import com.onewhohears.dscombat.init.forge.DataSerializersImpl;
import com.onewhohears.dscombat.init.forge.ModArgumentTypesForge;
import com.onewhohears.dscombat.item.FillableItemCategory;
import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="dscombat")
public class DSCombatModForge {
    public DSCombatModForge(FMLJavaModLoadingContext loadingContext) {
        IEventBus modEventBus = loadingContext.getModEventBus();
        EventBuses.registerModEventBus((String)"dscombat", (IEventBus)modEventBus);
        loadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        loadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        loadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        modEventBus.addListener(this::onGatherData);
        modEventBus.addListener(this::buildCreativeModeTabs);
        DSCombatMod.init();
        if (Platform.getEnvironment() == Env.CLIENT && !DatagenModLoader.isRunningDataGen()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> DSCombatMod::clientInit);
        }
        DataSerializersImpl.register(modEventBus);
        ModArgumentTypesForge.register(modEventBus);
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        PackOutput output = generator.getPackOutput();
        if (event.includeServer()) {
            CompletableFuture completableFuture = event.getLookupProvider();
            generator.addProvider(true, (DataProvider)new VehiclePresetGenerator(output));
            generator.addProvider(true, (DataProvider)new WeaponPresetGenerator(output));
            generator.addProvider(true, (DataProvider)new RadarPresetGenerator(output));
            generator.addProvider(true, (DataProvider)new PartPresetGenerator(output));
            DependencySafety.serverDataGen(output, gen -> generator.addProvider(true, (DataProvider)gen));
            generator.addProvider(true, (DataProvider)new DSCRecipeGenerator(output));
            generator.addProvider(true, (DataProvider)new EntityTypeTagGen(output, completableFuture, fileHelper));
            BlockTagGen blockGen = new BlockTagGen(output, completableFuture, fileHelper);
            generator.addProvider(true, (DataProvider)blockGen);
            generator.addProvider(true, (DataProvider)new ItemTagGen(output, completableFuture, blockGen.m_274426_(), fileHelper));
            generator.addProvider(true, (DataProvider)new FluidTagGen(output, completableFuture, fileHelper));
            generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(output, completableFuture, new RegistrySetBuilder().m_254916_(Registries.f_268580_, ModDamageTypes::bootstrap), Set.of("dscombat")));
            generator.addProvider(true, (DataProvider)new DamageTypeTagGen(output, completableFuture, fileHelper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new DSCSoundDefinitionGenImpl(output, fileHelper));
            generator.addProvider(true, (DataProvider)new VehicleClientPresetGenerator(output));
            generator.addProvider(true, (DataProvider)new PartClientPresetGenerator(output));
            generator.addProvider(true, (DataProvider)new WeaponClientPresetGenerator(output));
        }
    }

    private void buildCreativeModeTabs(BuildCreativeModeTabContentsEvent event) {
        List<Supplier<? extends Item>> items = ModCMTabs.CREATIVE_TAB_MAP.get(event.getTabKey());
        if (items == null) {
            return;
        }
        items.forEach(item -> {
            Object patt0$temp = item.get();
            if (patt0$temp instanceof FillableItemCategory) {
                FillableItemCategory fill = (FillableItemCategory)patt0$temp;
                event.getEntries().remove((Object)((Item)item.get()).m_7968_());
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                fill.fillItemCategory(stacks);
                stacks.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246342_(arg_0));
            } else {
                event.accept(item);
            }
        });
    }

    @Mod.EventBusSubscriber(modid="dscombat", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            DSCEntityRenderers.register();
        }

        @SubscribeEvent
        public static void registerParticleFactory(RegisterParticleProvidersEvent event) {
            ClientEventHandlers.registerParticleProvider();
        }
    }
}

