/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.init;

import com.google.common.collect.ImmutableSet;
import com.onewhohears.dscombat.init.ModBlocks;
import com.onewhohears.dscombat.init.forge.ModVillagersImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ModVillagers {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((String)"dscombat", (ResourceKey)Registries.f_256805_);
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROS = DeferredRegister.create((String)"dscombat", (ResourceKey)Registries.f_256749_);
    public static final RegistrySupplier<PoiType> WEAPON_POI = POI_TYPES.register("weapon_workbench_poi", () -> new PoiType(ModVillagers.getBlockStates((Block)ModBlocks.WEAPONS_BLOCK.get()), 1, 1));
    public static final RegistrySupplier<PoiType> AIRCRAFT_POI = POI_TYPES.register("aircraft_workbench_poi", () -> new PoiType(ModVillagers.getBlockStates((Block)ModBlocks.AIRCRAFT_BLOCK.get()), 1, 1));
    public static final RegistrySupplier<VillagerProfession> WEAPONS_ENGINEER = VILLAGER_PROS.register("weapons_engineer", () -> new VillagerProfession("weapons_engineer", site -> site.m_203373_(WEAPON_POI.getId()), site -> site.m_203373_(WEAPON_POI.getId()), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12575_));
    public static final RegistrySupplier<VillagerProfession> AIRCRAFT_ENGINEER = VILLAGER_PROS.register("aircraft_engineer", () -> new VillagerProfession("aircraft_engineer", site -> site.m_203373_(AIRCRAFT_POI.getId()), site -> site.m_203373_(AIRCRAFT_POI.getId()), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12575_));

    public static RegistrySupplier<PoiType> registerPoi(String name, Supplier<Block> block, int workers, int range) {
        RegistrySupplier type = POI_TYPES.register(name, () -> new PoiType(ModVillagers.getBlockStates((Block)block.get()), workers, range));
        ModVillagers.platformRegisterPoiType(name, block, workers, range);
        return type;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void platformRegisterPoiType(String name, Supplier<Block> block, int workers, int range) {
        void var3_3;
        void var2_2;
        void var1_1;
        ModVillagersImpl.platformRegisterPoiType(name, (Supplier<Block>)var1_1, (int)var2_2, (int)var3_3);
    }

    public static void register() {
        POI_TYPES.register();
        VILLAGER_PROS.register();
    }

    private static Set<BlockState> getBlockStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_());
    }
}

