/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.entity.ai.goal.MoveToPassengerSeatGoal;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModCMTabs;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.item.VehicleInteractItem;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemTicketBook
extends Item
implements VehicleInteractItem {
    public static final int VEHICLE_SEARCH_RANGE = 32;

    public ItemTicketBook() {
        super(new Item.Properties().m_41487_(1).arch$tab(ModCMTabs.DSC_ITEMS));
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        Level level = UtilEntity.getLevel((Entity)player);
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        if (entity.m_20159_()) {
            return ItemTicketBook.sendError(player, "error.dscombat.entity_already_passenger");
        }
        if (!entity.m_6095_().m_204039_(ModTags.EntityTypes.TICKET_BOOKER) || !(entity instanceof PathfinderMob)) {
            return ItemTicketBook.sendError(player, "error.dscombat.entity_cant_use_tickets");
        }
        PathfinderMob mob = (PathfinderMob)entity;
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("vehicle")) {
            return ItemTicketBook.sendError(player, "error.dscombat.ticket_not_linked_vehicle");
        }
        UUID vehicleId = tag.m_128342_("vehicle");
        List vehicles = level.m_6443_(EntityVehicle.class, player.m_20191_().m_82400_(32.0), vehicle -> vehicle.m_20148_().equals(vehicleId));
        if (vehicles.isEmpty()) {
            return ItemTicketBook.sendError(player, "error.dscombat.vehicle_not_found");
        }
        EntityVehicle vehicle2 = (EntityVehicle)vehicles.get(0);
        if (!vehicle2.hasOpenPassengerSeat()) {
            return ItemTicketBook.sendError(player, "error.dscombat.no_open_seats");
        }
        mob.f_21345_.m_25352_(30, (Goal)new MoveToPassengerSeatGoal(mob, vehicle2));
        player.m_5661_((Component)UtilMCText.translatable((String)"success.dscombat.ticket_book_assign").m_6270_(Style.f_131099_.m_178520_(65280)), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onServerInteract(EntityVehicle vehicle, ItemStack stack, Player player, InteractionHand hand) {
        if (!vehicle.hasPermission((Entity)player)) {
            return InteractionResult.PASS;
        }
        Component name = vehicle.m_7755_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_("vehicle", vehicle.m_20148_());
        tag.m_128359_("vehicle_name", name.getString());
        stack.m_41751_(tag);
        player.m_5661_((Component)UtilMCText.translatable((String)"success.dscombat.ticket_book_link", (Object[])new Object[]{name}).m_6270_(Style.f_131099_.m_178520_(65280)), true);
        return InteractionResult.SUCCESS;
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("vehicle");
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tips, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tips, isAdvanced);
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("vehicle_name")) {
            return;
        }
        String name = tag.m_128461_("vehicle_name");
        tips.add((Component)UtilMCText.translatable((String)"info.dscombat.ticket_linked_to", (Object[])new Object[]{name}).m_6270_(Style.f_131099_.m_178520_(0xAAAAAA)));
    }

    public static InteractionResult sendError(Player player, String error) {
        player.m_5661_((Component)UtilMCText.translatable((String)error).m_6270_(Style.f_131099_.m_178520_(0xFF0000)), true);
        return InteractionResult.FAIL;
    }
}

